/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.command;

import java.util.List;
import java.util.Optional;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.command.InGameCommand;
import net.william278.huskhomes.command.UserListTabCompletable;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.teleport.Teleport;
import net.william278.huskhomes.user.OnlineUser;
import net.william278.huskhomes.user.SavedUser;
import net.william278.huskhomes.user.User;

public class TpOfflineCommand
extends InGameCommand
implements UserListTabCompletable {
    protected TpOfflineCommand(@NotNull HuskHomes plugin) {
        super(List.of("tpoffline"), "<player>", plugin);
        this.setOperatorCommand(true);
    }

    @Override
    public void execute(@NotNull OnlineUser executor, @NotNull String[] args) {
        Optional<String> optionalUser = this.parseStringArg(args, 0);
        if (optionalUser.isEmpty()) {
            this.plugin.getLocales().getLocale("error_invalid_syntax", this.getUsage()).ifPresent(executor::sendMessage);
            return;
        }
        Optional<User> targetUserData = this.plugin.getDatabase().getUser(optionalUser.get()).map(SavedUser::getUser);
        if (targetUserData.isEmpty()) {
            this.plugin.getLocales().getLocale("error_player_not_found", optionalUser.get()).ifPresent(executor::sendMessage);
            return;
        }
        this.teleportToOfflinePosition(executor, targetUserData.get(), args);
    }

    private void teleportToOfflinePosition(@NotNull OnlineUser user, @NotNull User target, @NotNull String[] args) {
        Optional<Position> position = this.plugin.getDatabase().getOfflinePosition(target);
        if (position.isEmpty()) {
            this.plugin.getLocales().getLocale("error_no_offline_position", target.getName()).ifPresent(user::sendMessage);
            return;
        }
        this.plugin.getLocales().getLocale("teleporting_offline_player", target.getName()).ifPresent(user::sendMessage);
        Teleport.builder(this.plugin).teleporter(user).target(position.get()).buildAndComplete(false, args);
    }
}

