/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes.network;

import java.util.HashSet;
import java.util.logging.Level;
import lombok.Generated;
import net.william278.huskhomes.HuskHomes;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.libraries.annotations.Blocking;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.network.Message;
import net.william278.huskhomes.network.PluginMessageBroker;
import net.william278.huskhomes.user.OnlineUser;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.Pool;

public class RedisBroker
extends PluginMessageBroker {
    private final Subscriber subscriber = new Subscriber(this, this.getSubChannelId());

    public RedisBroker(@NotNull HuskHomes plugin) {
        super(plugin);
    }

    @Override
    @Blocking
    public void initialize() throws IllegalStateException {
        super.initialize();
        Pool<Jedis> jedisPool = RedisBroker.getJedisPool(this.plugin.getSettings().getCrossServer().getRedis());
        try {
            ((Jedis)jedisPool.getResource()).ping();
        }
        catch (JedisException e) {
            throw new IllegalStateException("Failed to establish connection with Redis. Please check the supplied credentials in the config file", e);
        }
        this.subscriber.enable(jedisPool);
        Thread thread = new Thread(this.subscriber::subscribe, "huskhomes:redis_subscriber");
        thread.setDaemon(true);
        thread.start();
    }

    @NotNull
    private static Pool<Jedis> getJedisPool(@NotNull Settings.CrossServerSettings.RedisSettings settings) {
        String password = settings.getPassword();
        String host = settings.getHost();
        int port = settings.getPort();
        int database = settings.getDatabase();
        int timeout = settings.getTimeout();
        boolean useSSL = settings.isUseSsl();
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(0);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        Settings.CrossServerSettings.RedisSettings.SentinelSettings sentinel = settings.getSentinel();
        HashSet<String> redisSentinelNodes = new HashSet<String>(sentinel.getNodes());
        if (!redisSentinelNodes.isEmpty()) {
            String sentinelPassword = sentinel.getPassword();
            return new JedisSentinelPool(sentinel.getMasterName(), redisSentinelNodes, (GenericObjectPoolConfig)config, timeout, password.isEmpty() ? null : password, sentinelPassword.isEmpty() ? null : sentinelPassword, database);
        }
        return new JedisPool((GenericObjectPoolConfig)config, host, port, timeout, password.isEmpty() ? null : password, database, useSSL);
    }

    @Override
    protected void send(@NotNull Message message, @Nullable OnlineUser sender) {
        this.plugin.runAsync(() -> this.subscriber.send(message));
    }

    @Override
    @Blocking
    public void close() {
        super.close();
        this.subscriber.disable();
    }

    private static class Subscriber
    extends JedisPubSub {
        private static final int RECONNECTION_TIME = 8000;
        private final RedisBroker broker;
        private final String channel;
        private Pool<Jedis> jedisPool;
        private boolean enabled;
        private boolean reconnected;

        private Subscriber(@NotNull RedisBroker broker, @NotNull String channel) {
            this.broker = broker;
            this.channel = channel;
        }

        private void enable(@NotNull Pool<Jedis> jedisPool) {
            this.jedisPool = jedisPool;
            this.enabled = true;
        }

        @Blocking
        private void disable() {
            this.enabled = false;
            if (this.jedisPool != null && !this.jedisPool.isClosed()) {
                this.jedisPool.close();
            }
            this.unsubscribe();
        }

        @Blocking
        public void send(@NotNull Message message) {
            try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
                jedis.publish(this.channel, this.broker.plugin.getGson().toJson(message));
            }
        }

        @Blocking
        private void subscribe() {
            while (this.enabled && !Thread.interrupted() && this.jedisPool != null && !this.jedisPool.isClosed()) {
                try {
                    Jedis jedis = (Jedis)this.jedisPool.getResource();
                    try {
                        if (this.reconnected) {
                            this.broker.plugin.log(Level.INFO, "Redis connection is alive again", new Throwable[0]);
                        }
                        jedis.subscribe((JedisPubSub)this, new String[]{this.channel});
                    }
                    finally {
                        if (jedis == null) continue;
                        jedis.close();
                    }
                }
                catch (Throwable t) {
                    this.onThreadUnlock(t);
                }
            }
        }

        private void onThreadUnlock(@NotNull Throwable t) {
            if (!this.enabled) {
                return;
            }
            if (this.reconnected) {
                this.broker.plugin.log(Level.WARNING, "Redis Server connection lost. Attempting reconnect in %ss...".formatted(8), t);
            }
            try {
                this.unsubscribe();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!this.reconnected) {
                this.reconnected = true;
            } else {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void onMessage(@NotNull String channel, @NotNull String encoded) {
            Message message;
            try {
                message = this.broker.plugin.getMessageFromJson(encoded);
            }
            catch (Exception e) {
                this.broker.plugin.log(Level.WARNING, "Failed to decode message from Redis: " + e.getMessage(), new Throwable[0]);
                return;
            }
            if (message.getTargetType() == Message.TargetType.PLAYER) {
                this.broker.plugin.getOnlineUsers().stream().filter(online -> message.getTarget().equals("ALL") || online.getName().equals(message.getTarget())).forEach(receiver -> this.broker.handle((OnlineUser)receiver, message));
                return;
            }
            if (message.getTarget().equals(this.broker.plugin.getServerName()) || message.getTarget().equals("ALL")) {
                if (message.getType() == Message.MessageType.REQUEST_RTP_LOCATION) {
                    this.broker.handleRtpRequestLocation(message);
                    return;
                }
                this.broker.plugin.getOnlineUsers().stream().findAny().ifPresent(receiver -> this.broker.handle((OnlineUser)receiver, message));
            }
        }

        @Generated
        public Subscriber(RedisBroker broker, String channel, Pool<Jedis> jedisPool, boolean enabled, boolean reconnected) {
            this.broker = broker;
            this.channel = channel;
            this.jedisPool = jedisPool;
            this.enabled = enabled;
            this.reconnected = reconnected;
        }
    }
}

