/*
 * Decompiled with CFR 0.152.
 */
package net.william278.huskhomes;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.kyori.adventure.key.Key;
import net.william278.huskhomes.api.BaseHuskHomesAPI;
import net.william278.huskhomes.command.Command;
import net.william278.huskhomes.command.CommandProvider;
import net.william278.huskhomes.config.ConfigProvider;
import net.william278.huskhomes.config.Server;
import net.william278.huskhomes.config.Settings;
import net.william278.huskhomes.database.DatabaseProvider;
import net.william278.huskhomes.event.EventDispatcher;
import net.william278.huskhomes.hook.HookProvider;
import net.william278.huskhomes.hook.PluginHook;
import net.william278.huskhomes.libraries.annotations.NotNull;
import net.william278.huskhomes.libraries.annotations.Nullable;
import net.william278.huskhomes.libraries.configlib.ConfigurationException;
import net.william278.huskhomes.listener.ListenerProvider;
import net.william278.huskhomes.manager.ManagerProvider;
import net.william278.huskhomes.network.BrokerProvider;
import net.william278.huskhomes.position.Position;
import net.william278.huskhomes.position.World;
import net.william278.huskhomes.random.RandomTeleportProvider;
import net.william278.huskhomes.user.ConsoleUser;
import net.william278.huskhomes.user.UserProvider;
import net.william278.huskhomes.util.AudiencesProvider;
import net.william278.huskhomes.util.DumpProvider;
import net.william278.huskhomes.util.GsonProvider;
import net.william278.huskhomes.util.MetaProvider;
import net.william278.huskhomes.util.SavePositionProvider;
import net.william278.huskhomes.util.Task;
import net.william278.huskhomes.util.TextValidator;
import net.william278.huskhomes.util.TransactionResolver;

public interface HuskHomes
extends Task.Supplier,
EventDispatcher,
SavePositionProvider,
TransactionResolver,
ConfigProvider,
DatabaseProvider,
BrokerProvider,
MetaProvider,
HookProvider,
RandomTeleportProvider,
AudiencesProvider,
UserProvider,
TextValidator,
ManagerProvider,
ListenerProvider,
CommandProvider,
GsonProvider,
DumpProvider {
    public static final int BSTATS_BUKKIT_PLUGIN_ID = 8430;

    default public void load() {
        try {
            this.loadConfigs();
            this.setHooks(Sets.newHashSet());
            this.loadHooks(PluginHook.Register.ON_LOAD);
            this.registerHooks(PluginHook.Register.ON_LOAD);
        }
        catch (ConfigurationException e) {
            this.log(Level.SEVERE, "Failed to load the HuskHomes config.yml file! HuskHomes will be disabled.\nPlease regenerate your HuskHomes config.yml file (delete it and restart your server.)", e);
            this.disablePlugin();
            return;
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "An error occurred whilst loading HuskHomes", e);
            this.disablePlugin();
            return;
        }
        this.log(Level.INFO, String.format("Successfully loaded HuskHomes v%s", this.getPluginVersion()), new Throwable[0]);
    }

    default public void enable() {
        try {
            this.loadDatabase();
            this.loadBroker();
            this.loadManager();
            this.loadRandomTeleportEngine();
            this.loadListeners();
            this.loadHooks(PluginHook.Register.ON_ENABLE);
            this.registerHooks(PluginHook.Register.ON_ENABLE);
            this.loadAPI();
            if (this.getPluginVersion().getMetadata().isBlank()) {
                this.loadMetrics();
            }
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "An error occurred whilst enabling HuskHomes", e);
            this.disablePlugin();
            return;
        }
        this.log(Level.INFO, String.format("Successfully enabled HuskHomes v%s", this.getPluginVersion()), new Throwable[0]);
        this.checkForUpdates();
        this.loadAfterLoadHooks();
    }

    default public void shutdown() {
        this.log(Level.INFO, String.format("Disabling HuskHomes v%s...", this.getPluginVersion()), new Throwable[0]);
        try {
            this.unloadHooks(PluginHook.Register.values());
            this.closeDatabase();
            this.closeBroker();
            this.cancelTasks();
            this.unloadAPI();
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "An error occurred whilst disabling HuskHomes", e);
        }
        this.log(Level.INFO, String.format("Successfully disabled HuskHomes v%s", this.getPluginVersion()), new Throwable[0]);
    }

    public void loadAPI();

    default public void unloadAPI() {
        BaseHuskHomesAPI.unregister();
    }

    public void loadMetrics();

    public void disablePlugin();

    @Override
    @NotNull
    public ConsoleUser getConsole();

    default public Optional<Position> getSpawn() {
        Settings.CrossServerSettings crossServer = this.getSettings().getCrossServer();
        return crossServer.isEnabled() && crossServer.getGlobalSpawn().isEnabled() ? this.getDatabase().getWarp(crossServer.getGlobalSpawn().getWarpName()).map(warp -> warp) : this.getServerSpawn().map(spawn -> spawn.getPosition(this.getServerName()));
    }

    public void setWorldSpawn(@NotNull Position var1);

    @Override
    public void setServerName(@NotNull Server var1);

    @Override
    @Nullable
    public InputStream getResource(@NotNull String var1);

    @NotNull
    public List<World> getWorlds();

    @Override
    @NotNull
    public List<Command> getCommands();

    @Override
    default public <T extends Command> Optional<T> getCommand(@NotNull Class<T> type) {
        return this.getCommands().stream().filter(command -> command.getClass() == type).findFirst().map(type::cast);
    }

    @NotNull
    public Set<UUID> getCurrentlyOnWarmup();

    @NotNull
    public Set<UUID> getWarmupDamagedUsers();

    default public boolean isWarmingUp(@NotNull UUID userUuid) {
        return this.getCurrentlyOnWarmup().contains(userUuid);
    }

    default public boolean hasTakenWarmupDamage(@NotNull UUID userUuid) {
        return this.getWarmupDamagedUsers().contains(userUuid);
    }

    public void log(@NotNull Level var1, @NotNull String var2, Throwable ... var3);

    @NotNull
    default public Key getKey(String ... data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Cannot create a key with no data");
        }
        String joined = String.join((CharSequence)"/", data);
        return Key.key("huskhomes", joined);
    }
}

