/*
 * Decompiled with CFR 0.152.
 */
package eu.webducer.conductivesignsminecraft.utils;

import eu.webducer.conductivesignsminecraft.repositories.ConfigRepository;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Leu/webducer/conductivesignsminecraft/utils/SoundManager;", "", "configRepository", "Leu/webducer/conductivesignsminecraft/repositories/ConfigRepository;", "<init>", "(Leu/webducer/conductivesignsminecraft/repositories/ConfigRepository;)V", "playSound", "", "event", "Leu/webducer/conductivesignsminecraft/utils/SoundManager$SoundEvent;", "soundLocation", "Lorg/bukkit/Location;", "getSoundKey", "Lnet/kyori/adventure/key/Key;", "keyAsString", "", "SoundEvent", "ConductiveSigns-Minecraft"})
public final class SoundManager {
    @NotNull
    private final ConfigRepository configRepository;

    public SoundManager(@NotNull ConfigRepository configRepository) {
        Intrinsics.checkNotNullParameter(configRepository, "configRepository");
        this.configRepository = configRepository;
    }

    public final void playSound(@NotNull SoundEvent event, @NotNull Location soundLocation) {
        Intrinsics.checkNotNullParameter((Object)event, "event");
        Intrinsics.checkNotNullParameter(soundLocation, "soundLocation");
        Sound.Builder builder = Sound.sound().source(Sound.Source.BLOCK);
        Intrinsics.checkNotNullExpressionValue(builder, "source(...)");
        Sound.Builder selectedSound = builder;
        switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                Sound.Builder builder2 = selectedSound.type(this.getSoundKey(this.configRepository.getSuccessSound())).volume(this.configRepository.getSuccessSoundVolume()).pitch(this.configRepository.getSuccessSoundPitch());
                break;
            }
            case 2: {
                Sound.Builder builder2 = selectedSound.type(this.getSoundKey(this.configRepository.getFailureSound())).volume(this.configRepository.getFailureSoundVolume()).pitch(this.configRepository.getFailureSoundPitch());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        soundLocation.getWorld().playSound((Sound)selectedSound.build(), soundLocation.getX(), soundLocation.getY(), soundLocation.getZ());
    }

    private final Key getSoundKey(String keyAsString) {
        Key key;
        String[] stringArray = new String[]{":"};
        List keyList = StringsKt.split$default((CharSequence)keyAsString, stringArray, false, 0, 6, null);
        if (((Collection)keyList).size() == 2) {
            Key key2 = Key.key((String)keyList.get(0), (String)keyList.get(1));
            key = key2;
            Intrinsics.checkNotNullExpressionValue(key2, "key(...)");
        } else {
            Key key3 = Key.key(keyAsString);
            key = key3;
            Intrinsics.checkNotNullExpressionValue(key3, "key(...)");
        }
        return key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Leu/webducer/conductivesignsminecraft/utils/SoundManager$SoundEvent;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "FAILURE", "ConductiveSigns-Minecraft"})
    public static final class SoundEvent
    extends Enum<SoundEvent> {
        public static final /* enum */ SoundEvent SUCCESS = new SoundEvent();
        public static final /* enum */ SoundEvent FAILURE = new SoundEvent();
        private static final /* synthetic */ SoundEvent[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SoundEvent[] values() {
            return (SoundEvent[])$VALUES.clone();
        }

        public static SoundEvent valueOf(String value) {
            return Enum.valueOf(SoundEvent.class, value);
        }

        @NotNull
        public static EnumEntries<SoundEvent> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = soundEventArray = new SoundEvent[]{SoundEvent.SUCCESS, SoundEvent.FAILURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoundEvent.values().length];
            try {
                nArray[SoundEvent.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoundEvent.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

