/*
 * Decompiled with CFR 0.152.
 */
package eu.webducer.conductivesignsminecraft.repositories;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Leu/webducer/conductivesignsminecraft/repositories/VaultRepository;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "econ", "Lnet/milkbowl/vault/economy/Economy;", "chat", "Lnet/milkbowl/vault/chat/Chat;", "perm", "Lnet/milkbowl/vault/permission/Permission;", "withdraw", "", "player", "Lorg/bukkit/OfflinePlayer;", "amount", "", "deposit", "getBalance", "setupEconomy", "", "setupChat", "setupPermissions", "ConductiveSigns-Minecraft"})
public final class VaultRepository {
    @NotNull
    private final JavaPlugin plugin;
    @Nullable
    private Economy econ;
    @Nullable
    private Chat chat;
    @Nullable
    private Permission perm;

    public VaultRepository(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.setupEconomy();
        this.setupChat();
        this.setupPermissions();
    }

    public final boolean withdraw(@NotNull OfflinePlayer player, double amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Economy economy = this.econ;
        return (economy != null && (economy = economy.withdrawPlayer(player, amount)) != null ? economy.type : null) == EconomyResponse.ResponseType.SUCCESS;
    }

    public final boolean deposit(@NotNull OfflinePlayer player, double amount) {
        Intrinsics.checkNotNullParameter(player, "player");
        Economy economy = this.econ;
        return (economy != null && (economy = economy.depositPlayer(player, amount)) != null ? economy.type : null) == EconomyResponse.ResponseType.SUCCESS;
    }

    public final double getBalance(@NotNull OfflinePlayer player) {
        Intrinsics.checkNotNullParameter(player, "player");
        Economy economy = this.econ;
        return economy != null ? economy.getBalance(player) : 0.0;
    }

    private final void setupEconomy() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            this.econ = (Economy)rsp.getProvider();
        }
    }

    private final void setupChat() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Chat.class);
        if (rsp != null) {
            this.chat = (Chat)rsp.getProvider();
        }
    }

    private final void setupPermissions() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp != null) {
            this.perm = (Permission)rsp.getProvider();
        }
    }
}

