/*
 * Decompiled with CFR 0.152.
 */
package eu.webducer.conductivesignsminecraft.events;

import eu.webducer.conductivesignsminecraft.repositories.BlocksRepository;
import eu.webducer.conductivesignsminecraft.repositories.ConfigRepository;
import eu.webducer.conductivesignsminecraft.repositories.VaultRepository;
import eu.webducer.conductivesignsminecraft.utils.MiniMessagesFormatter;
import eu.webducer.conductivesignsminecraft.utils.SoundManager;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\"H\u0007J4\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0)H\u0002J\u0013\u0010+\u001a\u0004\u0018\u00010,*\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010-J\f\u0010.\u001a\u00020/*\u00020,H\u0002J.\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020%2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020,2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u001e0)H\u0002J \u00106\u001a\u00020\u001e*\u0002072\b\b\u0002\u00108\u001a\u0002092\b\b\u0002\u0010:\u001a\u00020;H\u0002J\f\u0010<\u001a\u00020/*\u000207H\u0002J\u0018\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000207H\u0002J\u0010\u0010A\u001a\u00020/2\u0006\u00108\u001a\u00020BH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Leu/webducer/conductivesignsminecraft/events/SignInteractionListener;", "Lorg/bukkit/event/Listener;", "vaultRepository", "Leu/webducer/conductivesignsminecraft/repositories/VaultRepository;", "configRepository", "Leu/webducer/conductivesignsminecraft/repositories/ConfigRepository;", "blocksRepository", "Leu/webducer/conductivesignsminecraft/repositories/BlocksRepository;", "miniMessagesFormatter", "Leu/webducer/conductivesignsminecraft/utils/MiniMessagesFormatter;", "soundManager", "Leu/webducer/conductivesignsminecraft/utils/SoundManager;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Leu/webducer/conductivesignsminecraft/repositories/VaultRepository;Leu/webducer/conductivesignsminecraft/repositories/ConfigRepository;Leu/webducer/conductivesignsminecraft/repositories/BlocksRepository;Leu/webducer/conductivesignsminecraft/utils/MiniMessagesFormatter;Leu/webducer/conductivesignsminecraft/utils/SoundManager;Lorg/bukkit/plugin/java/JavaPlugin;)V", "scheduler", "Lorg/bukkit/scheduler/BukkitScheduler;", "Lorg/jetbrains/annotations/NotNull;", "prefix", "", "unitSymbol", "namespace", "playerNameKey", "Lorg/bukkit/NamespacedKey;", "playerIdKey", "descriptionKey", "priceKey", "lastUsageTime", "onSignChange", "", "event", "Lorg/bukkit/event/block/SignChangeEvent;", "onPlayerInteractEvent", "Lorg/bukkit/event/player/PlayerInteractEvent;", "confirmationDialog", "player", "Lorg/bukkit/entity/Player;", "message", "Lnet/kyori/adventure/text/Component;", "onConfirm", "Lkotlin/Function0;", "onDeny", "toNormalizedDouble", "", "(Ljava/lang/String;)Ljava/lang/Double;", "isValidPrice", "", "handleTransaction", "debtor", "creditor", "Lorg/bukkit/OfflinePlayer;", "amount", "onSuccess", "setBlockForDuration", "Lorg/bukkit/Location;", "block", "Lorg/bukkit/Material;", "ticks", "", "isBlocked", "getRedstoneBlockLocation", "facingDirection", "Lorg/bukkit/block/BlockFace;", "signLocation", "isWallSign", "Lorg/bukkit/block/Block;", "ConductiveSigns-Minecraft"})
@SourceDebugExtension(value={"SMAP\nSignInteractionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SignInteractionListener.kt\neu/webducer/conductivesignsminecraft/events/SignInteractionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n1557#2:287\n1628#2,3:288\n*S KotlinDebug\n*F\n+ 1 SignInteractionListener.kt\neu/webducer/conductivesignsminecraft/events/SignInteractionListener\n*L\n53#1:287\n53#1:288,3\n*E\n"})
public final class SignInteractionListener
implements Listener {
    @NotNull
    private final VaultRepository vaultRepository;
    @NotNull
    private final ConfigRepository configRepository;
    @NotNull
    private final BlocksRepository blocksRepository;
    @NotNull
    private final MiniMessagesFormatter miniMessagesFormatter;
    @NotNull
    private final SoundManager soundManager;
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private final BukkitScheduler scheduler;
    @NotNull
    private final String prefix;
    @NotNull
    private final String unitSymbol;
    @NotNull
    private final String namespace;
    @NotNull
    private final NamespacedKey playerNameKey;
    @NotNull
    private final NamespacedKey playerIdKey;
    @NotNull
    private final NamespacedKey descriptionKey;
    @NotNull
    private final NamespacedKey priceKey;
    @NotNull
    private final NamespacedKey lastUsageTime;

    public SignInteractionListener(@NotNull VaultRepository vaultRepository, @NotNull ConfigRepository configRepository, @NotNull BlocksRepository blocksRepository, @NotNull MiniMessagesFormatter miniMessagesFormatter, @NotNull SoundManager soundManager, @NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(vaultRepository, "vaultRepository");
        Intrinsics.checkNotNullParameter(configRepository, "configRepository");
        Intrinsics.checkNotNullParameter(blocksRepository, "blocksRepository");
        Intrinsics.checkNotNullParameter(miniMessagesFormatter, "miniMessagesFormatter");
        Intrinsics.checkNotNullParameter(soundManager, "soundManager");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.vaultRepository = vaultRepository;
        this.configRepository = configRepository;
        this.blocksRepository = blocksRepository;
        this.miniMessagesFormatter = miniMessagesFormatter;
        this.soundManager = soundManager;
        this.plugin = plugin;
        BukkitScheduler bukkitScheduler = this.plugin.getServer().getScheduler();
        Intrinsics.checkNotNullExpressionValue(bukkitScheduler, "getScheduler(...)");
        this.scheduler = bukkitScheduler;
        this.prefix = this.configRepository.getPrefix();
        this.unitSymbol = this.configRepository.getCurrencySymbol();
        String string = String.valueOf(Reflection.getOrCreateKotlinClass(SignInteractionListener.class).getQualifiedName()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        this.namespace = string;
        this.playerNameKey = new NamespacedKey(this.namespace, "player-name");
        this.playerIdKey = new NamespacedKey(this.namespace, "player-id");
        this.descriptionKey = new NamespacedKey(this.namespace, "description");
        this.priceKey = new NamespacedKey(this.namespace, "price");
        this.lastUsageTime = new NamespacedKey(this.namespace, "last-interaction-date-time");
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    public final void onSignChange(@NotNull SignChangeEvent event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(event, "event");
        List list = event.lines();
        Intrinsics.checkNotNullExpressionValue(list, "lines(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Component component = (Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it, "null cannot be cast to non-null type net.kyori.adventure.text.TextComponent");
            collection.add((TextComponent)it);
        }
        List signLines = (List)destination$iv$iv;
        if (Intrinsics.areEqual(((TextComponent)signLines.get(0)).content(), this.prefix)) {
            Block block = event.getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
            if (this.isWallSign(block)) {
                BlockState blockState = event.getBlock().getState();
                Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.Sign");
                Sign signState = (Sign)blockState;
                BlockData blockData = signState.getBlockData();
                Intrinsics.checkNotNull(blockData, "null cannot be cast to non-null type org.bukkit.block.data.type.WallSign");
                WallSign wallSign = (WallSign)blockData;
                String string = event.getPlayer().getName();
                Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
                String playerName = string;
                String string2 = event.getPlayer().getUniqueId().toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                String playerId = string2;
                String string3 = ((TextComponent)signLines.get(2)).content();
                Intrinsics.checkNotNullExpressionValue(string3, "content(...)");
                Double price = this.toNormalizedDouble(string3);
                String string4 = ((TextComponent)signLines.get(3)).content();
                Intrinsics.checkNotNullExpressionValue(string4, "content(...)");
                String description = string4;
                if (price == null) {
                    event.getPlayer().sendMessage((Component)Component.translatable("empty_price"));
                    return;
                }
                if (!this.isValidPrice(price)) {
                    Object item$iv$iv;
                    Player player = event.getPlayer();
                    item$iv$iv = new ComponentLike[2];
                    String string5 = "%s%.2f";
                    Object[] objectArray = new Object[]{this.unitSymbol, this.configRepository.getMinPrice()};
                    String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string6, "format(...)");
                    item$iv$iv[0] = Component.text(string6);
                    string5 = "%s%.2f";
                    objectArray = new Object[]{this.unitSymbol, this.configRepository.getMaxPrice()};
                    String string7 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue(string7, "format(...)");
                    item$iv$iv[1] = Component.text(string7);
                    player.sendMessage((Component)Component.translatable("price_range_error", item$iv$iv));
                    return;
                }
                BlockFace blockFace = wallSign.getFacing();
                Intrinsics.checkNotNullExpressionValue(blockFace, "getFacing(...)");
                Location location = signState.getLocation();
                Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
                Location redstoneLocation = this.getRedstoneBlockLocation(blockFace, location);
                if (this.isBlocked(redstoneLocation)) {
                    event.getPlayer().sendMessage((Component)Component.translatable("block_obstructed"));
                    return;
                }
                event.line(0, this.miniMessagesFormatter.getFormattedPrefix());
                event.line(1, this.miniMessagesFormatter.getFormattedPlayerName(playerName));
                String string8 = "%s%.2f";
                Object[] objectArray = new Object[]{this.unitSymbol, price};
                String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue(string9, "format(...)");
                event.line(2, this.miniMessagesFormatter.getFormattedPrice(string9));
                event.line(3, this.miniMessagesFormatter.getFormattedDescription(description));
                BlockState blockState2 = event.getBlock().getState();
                Intrinsics.checkNotNull(blockState2, "null cannot be cast to non-null type org.bukkit.block.Sign");
                Sign sign = (Sign)blockState2;
                sign.setWaxed(true);
                sign.getPersistentDataContainer().set(this.playerNameKey, PersistentDataType.STRING, (Object)playerName);
                sign.getPersistentDataContainer().set(this.playerIdKey, PersistentDataType.STRING, (Object)playerId);
                sign.getPersistentDataContainer().set(this.descriptionKey, PersistentDataType.STRING, (Object)description);
                sign.getPersistentDataContainer().set(this.priceKey, PersistentDataType.DOUBLE, (Object)price);
                sign.update();
            }
        }
    }

    @EventHandler
    public final void onPlayerInteractEvent(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block clickedBlock = block;
        if (!this.isWallSign(clickedBlock)) {
            return;
        }
        BlockState blockState = clickedBlock.getState();
        Intrinsics.checkNotNull(blockState, "null cannot be cast to non-null type org.bukkit.block.Sign");
        Sign signState = (Sign)blockState;
        BlockData blockData = clickedBlock.getState().getBlockData();
        Intrinsics.checkNotNull(blockData, "null cannot be cast to non-null type org.bukkit.block.data.type.WallSign");
        WallSign wallSign = (WallSign)blockData;
        PersistentDataContainer persistentDataContainer = signState.getPersistentDataContainer();
        Intrinsics.checkNotNullExpressionValue(persistentDataContainer, "getPersistentDataContainer(...)");
        PersistentDataContainer dataContainer = persistentDataContainer;
        String playerName = (String)dataContainer.get(this.playerNameKey, PersistentDataType.STRING);
        String playerId = (String)dataContainer.get(this.playerIdKey, PersistentDataType.STRING);
        Double price = (Double)dataContainer.get(this.priceKey, PersistentDataType.DOUBLE);
        Long lastInteractionDateTime = (Long)dataContainer.get(this.lastUsageTime, PersistentDataType.LONG);
        CharSequence charSequence = playerName;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (event.getAction().isLeftClick()) {
            return;
        }
        long currentEpochTime = Instant.now().getEpochSecond();
        if (lastInteractionDateTime != null && currentEpochTime - lastInteractionDateTime < this.configRepository.getSignDelay() / (long)1000) {
            event.getPlayer().sendMessage((Component)Component.translatable("rate_limit_exceeded"));
            return;
        }
        signState.getPersistentDataContainer().set(this.lastUsageTime, PersistentDataType.LONG, (Object)currentEpochTime);
        signState.update();
        if (price == null || !this.isValidPrice(price)) {
            Player player = event.getPlayer();
            ComponentLike[] componentLikeArray = new ComponentLike[2];
            String string = "%s%.2f";
            Object[] objectArray = new Object[]{this.unitSymbol, this.configRepository.getMinPrice()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            componentLikeArray[0] = Component.text(string2);
            string = "%s%.2f";
            objectArray = new Object[]{this.unitSymbol, this.configRepository.getMaxPrice()};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            componentLikeArray[1] = Component.text(string3);
            player.sendMessage((Component)Component.translatable("price_range_error", componentLikeArray));
            return;
        }
        BlockFace blockFace = wallSign.getFacing();
        Intrinsics.checkNotNullExpressionValue(blockFace, "getFacing(...)");
        Location location = signState.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        Location redstoneLocation = this.getRedstoneBlockLocation(blockFace, location);
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerId));
        Intrinsics.checkNotNullExpressionValue(offlinePlayer, "getOfflinePlayer(...)");
        OfflinePlayer signOwner = offlinePlayer;
        if (this.isBlocked(redstoneLocation)) {
            event.getPlayer().sendMessage((Component)Component.translatable("block_obstructed"));
            return;
        }
        double percThreshold = this.configRepository.getPriceThresholdPercentage();
        double priceThreshold = this.configRepository.getMaxPrice() / (double)100 * percThreshold;
        if (!(percThreshold == -1.0) && price >= priceThreshold && !Intrinsics.areEqual(event.getPlayer(), signOwner)) {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            TranslatableComponent translatableComponent = Component.translatable("confirm_transaction");
            Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
            this.confirmationDialog(player, translatableComponent, () -> SignInteractionListener.onPlayerInteractEvent$lambda$2(this, event, signOwner, price, signState, redstoneLocation), () -> SignInteractionListener.onPlayerInteractEvent$lambda$3(event));
        } else {
            Player player = event.getPlayer();
            Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
            boolean signActivated = this.handleTransaction(player, signOwner, price, () -> SignInteractionListener.onPlayerInteractEvent$lambda$4(this, redstoneLocation));
            SoundManager.SoundEvent soundEvent = signActivated ? SoundManager.SoundEvent.SUCCESS : SoundManager.SoundEvent.FAILURE;
            Location location2 = signState.getLocation();
            Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
            this.soundManager.playSound(soundEvent, location2);
        }
    }

    private final void confirmationDialog(Player player, Component message, Function0<Unit> onConfirm, Function0<Unit> onDeny) {
        Ref.BooleanRef confirmationPending = new Ref.BooleanRef();
        confirmationPending.element = true;
        player.sendMessage(message.appendNewline().append(Component.text("[/confirm]", (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.callback(arg_0 -> SignInteractionListener.confirmationDialog$lambda$5(confirmationPending, onConfirm, arg_0)))).appendSpace().append(Component.text("[/cancel]", (TextColor)NamedTextColor.RED).clickEvent(ClickEvent.callback(arg_0 -> SignInteractionListener.confirmationDialog$lambda$6(confirmationPending, onDeny, arg_0)))));
    }

    private final Double toNormalizedDouble(String $this$toNormalizedDouble) {
        return StringsKt.toDoubleOrNull(StringsKt.replace$default($this$toNormalizedDouble, ",", ".", false, 4, null));
    }

    private final boolean isValidPrice(double $this$isValidPrice) {
        if (this.configRepository.getMaxPrice() == -1.0) {
            return $this$isValidPrice >= this.configRepository.getMinPrice();
        }
        double d = this.configRepository.getMinPrice();
        return $this$isValidPrice <= this.configRepository.getMaxPrice() ? d <= $this$isValidPrice : false;
    }

    private final boolean handleTransaction(Player debtor, OfflinePlayer creditor, double amount, Function0<Unit> onSuccess) {
        if (Intrinsics.areEqual(debtor, creditor)) {
            onSuccess.invoke();
            return true;
        }
        double debtorFunds = this.vaultRepository.getBalance((OfflinePlayer)debtor);
        if (debtorFunds < amount) {
            debtor.sendMessage((Component)Component.translatable("insufficient_funds"));
            return false;
        }
        boolean isWithdrawSuccessful = this.vaultRepository.withdraw((OfflinePlayer)debtor, amount);
        if (!isWithdrawSuccessful) {
            debtor.sendMessage((Component)Component.translatable("withdraw_error"));
            return false;
        }
        boolean isDepositSuccessful = this.vaultRepository.deposit(creditor, amount);
        if (!isDepositSuccessful) {
            this.vaultRepository.deposit((OfflinePlayer)debtor, amount);
            debtor.sendMessage((Component)Component.translatable("deposit_error"));
            return false;
        }
        debtor.sendMessage((Component)Component.translatable("activation_successful"));
        onSuccess.invoke();
        return true;
    }

    private final void setBlockForDuration(Location $this$setBlockForDuration, Material block, long ticks) {
        this.blocksRepository.addBlock($this$setBlockForDuration);
        $this$setBlockForDuration.getBlock().setType(block);
        this.scheduler.runTaskLater((Plugin)this.plugin, () -> SignInteractionListener.setBlockForDuration$lambda$7($this$setBlockForDuration, this), ticks);
    }

    static /* synthetic */ void setBlockForDuration$default(SignInteractionListener signInteractionListener, Location location, Material material, long l, int n, Object object) {
        if ((n & 1) != 0) {
            material = Material.REDSTONE_BLOCK;
        }
        if ((n & 2) != 0) {
            l = 2L;
        }
        signInteractionListener.setBlockForDuration(location, material, l);
    }

    private final boolean isBlocked(Location $this$isBlocked) {
        return $this$isBlocked.getBlock().getType() != Material.AIR;
    }

    private final Location getRedstoneBlockLocation(BlockFace facingDirection, Location signLocation) {
        Location location;
        switch (WhenMappings.$EnumSwitchMapping$0[facingDirection.ordinal()]) {
            case 1: {
                Location location2 = signLocation.add(2.0, 0.0, 0.0);
                location = location2;
                Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
                break;
            }
            case 2: {
                Location location3 = signLocation.add(0.0, 0.0, 2.0);
                location = location3;
                Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
                break;
            }
            case 3: {
                Location location4 = signLocation.subtract(2.0, 0.0, 0.0);
                location = location4;
                Intrinsics.checkNotNullExpressionValue(location4, "subtract(...)");
                break;
            }
            case 4: {
                Location location5 = signLocation.subtract(0.0, 0.0, 2.0);
                location = location5;
                Intrinsics.checkNotNullExpressionValue(location5, "subtract(...)");
                break;
            }
            default: {
                location = signLocation;
            }
        }
        return location;
    }

    private final boolean isWallSign(Block block) {
        return Tag.WALL_SIGNS.isTagged((Keyed)block.getType());
    }

    private static final Unit onPlayerInteractEvent$lambda$2$lambda$1(SignInteractionListener this$0, Location $redstoneLocation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($redstoneLocation, "$redstoneLocation");
        this$0.setBlockForDuration($redstoneLocation, Material.REDSTONE_BLOCK, 2L);
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerInteractEvent$lambda$2(SignInteractionListener this$0, PlayerInteractEvent $event, OfflinePlayer $signOwner, Double $price, Sign $signState, Location $redstoneLocation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($event, "$event");
        Intrinsics.checkNotNullParameter($signOwner, "$signOwner");
        Intrinsics.checkNotNullParameter($signState, "$signState");
        Intrinsics.checkNotNullParameter($redstoneLocation, "$redstoneLocation");
        Player player = $event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        boolean signActivated = this$0.handleTransaction(player, $signOwner, $price, () -> SignInteractionListener.onPlayerInteractEvent$lambda$2$lambda$1(this$0, $redstoneLocation));
        SoundManager.SoundEvent soundEvent = signActivated ? SoundManager.SoundEvent.SUCCESS : SoundManager.SoundEvent.FAILURE;
        SoundManager soundManager = this$0.soundManager;
        Location location = $signState.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        soundManager.playSound(soundEvent, location);
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerInteractEvent$lambda$3(PlayerInteractEvent $event) {
        Intrinsics.checkNotNullParameter($event, "$event");
        $event.getPlayer().sendMessage((Component)Component.translatable("payment_cancelled", (TextColor)NamedTextColor.RED));
        return Unit.INSTANCE;
    }

    private static final Unit onPlayerInteractEvent$lambda$4(SignInteractionListener this$0, Location $redstoneLocation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($redstoneLocation, "$redstoneLocation");
        this$0.setBlockForDuration($redstoneLocation, Material.REDSTONE_BLOCK, 2L);
        return Unit.INSTANCE;
    }

    private static final void confirmationDialog$lambda$5(Ref.BooleanRef $confirmationPending, Function0 $onConfirm, Audience it) {
        Intrinsics.checkNotNullParameter($confirmationPending, "$confirmationPending");
        Intrinsics.checkNotNullParameter($onConfirm, "$onConfirm");
        Intrinsics.checkNotNullParameter(it, "it");
        if ($confirmationPending.element) {
            $confirmationPending.element = false;
            $onConfirm.invoke();
        }
    }

    private static final void confirmationDialog$lambda$6(Ref.BooleanRef $confirmationPending, Function0 $onDeny, Audience it) {
        Intrinsics.checkNotNullParameter($confirmationPending, "$confirmationPending");
        Intrinsics.checkNotNullParameter($onDeny, "$onDeny");
        Intrinsics.checkNotNullParameter(it, "it");
        if ($confirmationPending.element) {
            $confirmationPending.element = false;
            $onDeny.invoke();
        }
    }

    private static final void setBlockForDuration$lambda$7(Location $this_setBlockForDuration, SignInteractionListener this$0) {
        Intrinsics.checkNotNullParameter($this_setBlockForDuration, "$this_setBlockForDuration");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        $this_setBlockForDuration.getBlock().setType(Material.AIR);
        this$0.blocksRepository.removeBlock($this_setBlockForDuration);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockFace.values().length];
            try {
                nArray[BlockFace.WEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.NORTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockFace.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

