/*
 * Decompiled with CFR 0.152.
 */
package eu.webducer.conductivesignsminecraft.events;

import eu.webducer.conductivesignsminecraft.repositories.BlocksRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Leu/webducer/conductivesignsminecraft/events/BlockProtectionListener;", "Lorg/bukkit/event/Listener;", "blocksRepository", "Leu/webducer/conductivesignsminecraft/repositories/BlocksRepository;", "<init>", "(Leu/webducer/conductivesignsminecraft/repositories/BlocksRepository;)V", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "onPistonExtend", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "onPistonRetract", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "ConductiveSigns-Minecraft"})
@SourceDebugExtension(value={"SMAP\nBlockProtectionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockProtectionListener.kt\neu/webducer/conductivesignsminecraft/events/BlockProtectionListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n1863#2,2:40\n1863#2,2:42\n*S KotlinDebug\n*F\n+ 1 BlockProtectionListener.kt\neu/webducer/conductivesignsminecraft/events/BlockProtectionListener\n*L\n24#1:40,2\n33#1:42,2\n*E\n"})
public final class BlockProtectionListener
implements Listener {
    @NotNull
    private final BlocksRepository blocksRepository;

    public BlockProtectionListener(@NotNull BlocksRepository blocksRepository) {
        Intrinsics.checkNotNullParameter(blocksRepository, "blocksRepository");
        this.blocksRepository = blocksRepository;
    }

    @EventHandler
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Location location = event.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.blocksRepository.isSecuredBlock(location)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPistonExtend(@NotNull BlockPistonExtendEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List list = event.getBlocks();
        Intrinsics.checkNotNullExpressionValue(list, "getBlocks(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            Location location = it.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (!this.blocksRepository.isSecuredBlock(location)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onPistonRetract(@NotNull BlockPistonRetractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        List list = event.getBlocks();
        Intrinsics.checkNotNullExpressionValue(list, "getBlocks(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Block it = (Block)element$iv;
            boolean bl = false;
            Location location = it.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            if (!this.blocksRepository.isSecuredBlock(location)) continue;
            event.setCancelled(true);
        }
    }
}

