/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.utils;

import com.palmergames.bukkit.towny.object.Translatable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class Time {
    public static final SimpleDateFormat registeredFormat = new SimpleDateFormat("MMM d yyyy");
    private static final long MINUTE_SECONDS = TimeUnit.MINUTES.toSeconds(1L);
    private static final long HOUR_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final long DAY_SECONDS = TimeUnit.DAYS.toSeconds(1L);

    public static Translatable ago(long time) {
        long now = System.currentTimeMillis();
        if (time > now) {
            return Translatable.of((String)"time-future");
        }
        long diff = TimeUnit.MILLISECONDS.toSeconds(now - time);
        if (diff < MINUTE_SECONDS) {
            return Translatable.of((String)"time-just-now");
        }
        if (diff < 2L * MINUTE_SECONDS) {
            return Translatable.of((String)"time-a-minute-ago");
        }
        if (diff < 60L * MINUTE_SECONDS) {
            return Translatable.of((String)"time-x-minutes-ago", (Object[])new Object[]{diff / MINUTE_SECONDS});
        }
        if (diff < 2L * HOUR_SECONDS) {
            return Translatable.of((String)"time-an-hour-ago");
        }
        if (diff < 24L * HOUR_SECONDS) {
            return Translatable.of((String)"time-x-hours-ago", (Object[])new Object[]{diff / HOUR_SECONDS});
        }
        if (diff < 48L * HOUR_SECONDS) {
            return Translatable.of((String)"time-yesterday");
        }
        return Translatable.of((String)"time-x-days-ago", (Object[])new Object[]{diff / DAY_SECONDS});
    }

    public static String formatRegistered(long registered) {
        return registeredFormat.format(new Date(registered));
    }

    public static String registeredOrAgo(long time, Locale locale) {
        if (time + TimeUnit.DAYS.toMillis(30L) < System.currentTimeMillis()) {
            return Time.formatRegistered(time);
        }
        return Time.ago(time).translate(locale);
    }
}

