/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.menu.helper;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.util.MathUtil;
import io.github.townyadvanced.townymenus.gui.MenuHelper;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import io.github.townyadvanced.townymenus.gui.action.UserInputAction;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.SlotAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;
import io.github.townyadvanced.townymenus.menu.NationMenu;
import io.github.townyadvanced.townymenus.menu.TownMenu;
import io.github.townyadvanced.townymenus.utils.Localization;
import java.lang.reflect.Method;
import java.util.Locale;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class GovernmentMenus {
    public static MenuItem.Builder createTogglePropertyItem(Player player, Government government, Material material, boolean propertyEnabled, String property) {
        Locale locale = Localization.localeOrDefault(player);
        if (!GovernmentMenus.governmentExists(government)) {
            return MenuItem.builder(Material.BARRIER).name(Translatable.of((String)"government-menus-invalid").component(locale));
        }
        boolean isTown = government instanceof Town;
        String townOrNation = isTown ? "town" : "nation";
        String permNode = String.format("towny.command.%s.toggle.%s", townOrNation, property);
        return MenuItem.builder(material).name(Translatable.of((String)"government-menus-toggle").append(" ").append(property.substring(0, 1).toUpperCase(Locale.ROOT) + property.substring(1)).component(locale).color((TextColor)(propertyEnabled ? NamedTextColor.GREEN : NamedTextColor.RED))).lore(() -> {
            if (GovernmentMenus.getGovernment(player, isTown) == null) {
                return Translatable.of((String)"government-menus-not-in").append(townOrNation + ".").component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!player.hasPermission(permNode)) {
                return Translatable.of((String)"government-menus-no-permission").append(property + ".").component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(propertyEnabled ? Translatable.of((String)"government-menus-disable") : Translatable.of((String)"government-menus-enable")).append(" " + property + ".").component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(!player.hasPermission(permNode) ? ClickAction.NONE : ClickAction.confirmation(Translatable.of((String)"government-menus-toggle-confirm").append(property).append(Translatable.of((String)"government-menus-in-your")).append(townOrNation + "?").component(locale), (ClickAction)ClickAction.run(() -> {
            Government playerGovernment = GovernmentMenus.getGovernment(player, isTown);
            if (playerGovernment == null) {
                return;
            }
            try {
                if (playerGovernment instanceof Town) {
                    Town town = (Town)playerGovernment;
                    TownCommand.townToggle((CommandSender)player, (String[])new String[]{property}, (boolean)false, (Town)town);
                } else if (playerGovernment instanceof Nation) {
                    Nation nation = (Nation)playerGovernment;
                    NationCommand.nationToggle((CommandSender)player, (String[])new String[]{property}, (boolean)false, (Nation)nation);
                }
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
            MenuHistory.reOpen(player, () -> isTown ? TownMenu.formatTownToggleMenu(player) : NationMenu.formatNationToggleMenu(player));
        })));
    }

    public static MenuInventory createDepositWithdrawMenu(Player player, Government government) {
        Locale locale = Localization.localeOrDefault(player);
        if (!GovernmentMenus.governmentExists(government)) {
            return MenuInventory.builder().rows(1).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.BARRIER).name(Translatable.of((String)"government-menus-invalid").component(locale)).build()).build();
        }
        PermissionNodes root = government instanceof Town ? PermissionNodes.TOWNY_COMMAND_TOWN : PermissionNodes.TOWNY_COMMAND_NATION;
        return MenuInventory.builder().title(Translatable.of((String)"government-menus-deposit-or-withdraw").component(locale)).rows(3).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.EMERALD).name(Translatable.of((String)"government-menus-deposit").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (!player.hasPermission(root.getNode("deposit"))) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"government-menus-deposit-into-bank")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"government-menus-deposit-into-bank")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(!player.hasPermission(root.getNode("deposit")) ? ClickAction.NONE : GovernmentMenus.depositOrWithdraw(player, government, false)).build()).addItem(MenuItem.builder(Material.REDSTONE).name(Translatable.of((String)"government-menus-withdraw").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).lore(() -> {
            if (!player.hasPermission(root.getNode("withdraw"))) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"government-menus-withdraw-from-bank")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"government-menus-withdraw-from-bank")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(!player.hasPermission(root.getNode("withdraw")) ? ClickAction.NONE : GovernmentMenus.depositOrWithdraw(player, government, true)).build()).build();
    }

    private static UserInputAction depositOrWithdraw(Player player, Government government, boolean withdraw) {
        Locale locale = Localization.localeOrDefault(player);
        return ClickAction.userInput(Translatable.of((String)"government-menus-input").append(withdraw ? Translatable.of((String)"government-menus-input-withdraw") : Translatable.of((String)"government-menus-input-deposit")).append(Translatable.of((String)"government-menus-input-amount")).stripColors(true).translate(locale), completion -> {
            try {
                MathUtil.getIntOrThrow((String)completion.getText());
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            boolean town = government instanceof Town;
            if (!player.hasPermission(town ? PermissionNodes.TOWNY_COMMAND_TOWN_DEPOSIT.getNode() : PermissionNodes.TOWNY_COMMAND_NATION_DEPOSIT.getNode())) {
                return InputResponse.finish();
            }
            Class clazz = town ? TownCommand.class : NationCommand.class;
            try {
                Method method = clazz.getDeclaredMethod(town ? "townTransaction" : "nationTransaction", Player.class, String[].class, Boolean.TYPE);
                method.setAccessible(true);
                method.invoke(null, player, new String[]{completion.getText()}, withdraw);
                return InputResponse.openPreviousMenu();
            }
            catch (ReflectiveOperationException e) {
                return InputResponse.finish();
            }
        });
    }

    private static boolean governmentExists(Government government) {
        if (government instanceof Town) {
            Town town = (Town)government;
            return TownyUniverse.getInstance().hasTown(town.getUUID());
        }
        if (government instanceof Nation) {
            Nation nation = (Nation)government;
            return TownyUniverse.getInstance().hasNation(nation.getUUID());
        }
        return false;
    }

    private static boolean hasGovernment(Player player, Government government) {
        if (!GovernmentMenus.governmentExists(government)) {
            return false;
        }
        Government playerGovernment = GovernmentMenus.getGovernment(player, government instanceof Town);
        return playerGovernment != null && playerGovernment.getUUID().equals(government.getUUID());
    }

    @Nullable
    private static Government getGovernment(Player player, boolean town) {
        return town ? TownyAPI.getInstance().getTown(player) : TownyAPI.getInstance().getNation(player);
    }
}

