/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.menu;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.TownCommand;
import com.palmergames.bukkit.towny.event.TownAddResidentRankEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentRankEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeCache;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.BankTransaction;
import com.palmergames.bukkit.towny.object.economy.transaction.TransactionType;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import io.github.townyadvanced.townymenus.gui.MenuHelper;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.SlotAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;
import io.github.townyadvanced.townymenus.listeners.AwaitingConfirmation;
import io.github.townyadvanced.townymenus.menu.ResidentMenu;
import io.github.townyadvanced.townymenus.menu.helper.GovernmentMenus;
import io.github.townyadvanced.townymenus.utils.Localization;
import io.github.townyadvanced.townymenus.utils.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class TownMenu {
    public static MenuInventory createTownMenu(@NotNull Player player) {
        Resident resident = TownyAPI.getInstance().getResident(player);
        Town town = resident != null ? resident.getTownOrNull() : null;
        Locale locale = Localization.localeOrDefault(player);
        return MenuInventory.builder().rows(6).title(Translatable.of((String)"town-menu-title", (Object[])new Object[]{town != null ? town.getName() : Translatable.of((String)"town-menu-no-town")}).component(locale)).addItem(MenuHelper.backButton().build()).addItem(TownMenu.formatTownInfo(player, town).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).build()).addItem(MenuItem.builder(Material.EMERALD_BLOCK).name(Translatable.of((String)"town-menu-bank").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(1), HorizontalAnchor.fromLeft(3))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-bank-subtitle")).component(locale);
        }).action(town == null ? ClickAction.NONE : ClickAction.openInventory(() -> TownMenu.formatTownBankMenu(player))).build()).addItem(MenuItem.builder(Material.GRASS_BLOCK).name(Translatable.of((String)"town-menu-plots").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(1), HorizontalAnchor.fromRight(3))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_PLOTS.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-plots-subtitle")).component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-plots-subtitle")).component(locale);
        }).action(town == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_PLOTS.getNode()) ? ClickAction.NONE : ClickAction.openInventory(() -> {
            if (!TownyUniverse.getInstance().hasTown(town.getUUID())) {
                return MenuInventory.paginator().title(Translatable.of((String)"town-menu-plots").component(locale)).build();
            }
            ArrayList<MenuItem> plotItems = new ArrayList<MenuItem>();
            TownBlockTypeCache cache = town.getTownBlockTypeCache();
            for (TownBlockType type : TownBlockTypeHandler.getTypes().values()) {
                int residentOwned = cache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.RESIDENTOWNED);
                plotItems.add(MenuItem.builder(Material.GRASS_BLOCK).name((Component)Component.text((String)type.getFormattedName(), (TextColor)NamedTextColor.GREEN)).lore(() -> Translatable.of((String)"town-menu-plots-resident-owned", (Object[])new Object[]{residentOwned}).component(locale)).lore(() -> Translatable.of((String)"town-menu-plots-for-sale", (Object[])new Object[]{cache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.FORSALE)}).component(locale)).lore(() -> Translatable.of((String)"town-menu-plots-total", (Object[])new Object[]{cache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.ALL)}).component(locale)).lore((Component)(!TownyEconomyHandler.isActive() ? Component.empty() : Translatable.of((String)"town-menu-plots-daily-revenue", (Object[])new Object[]{cache.getNumTownBlocks(type, TownBlockTypeCache.CacheType.ALL)}).component(locale))).build());
            }
            return MenuInventory.paginator().addItems(plotItems).addExtraItem(MenuItem.builder(Material.OAK_SIGN).name(Translatable.of((String)"town-menu-plots").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromLeft(1))).lore(Translatable.of((String)"msg_town_plots_town_size", (Object[])new Object[]{town.getTownBlocks().size(), town.getMaxTownBlocksAsAString()}).component(locale).append((Component)(town.hasUnlimitedClaims() ? Component.empty() : (TownySettings.isSellingBonusBlocks((Town)town) ? Translatable.of((String)"msg_town_plots_town_bought", (Object[])new Object[]{town.getPurchasedBlocks(), TownySettings.getMaxPurchasedBlocks((Town)town)}).component(locale) : ((TextComponent)Component.empty().append((Component)(town.getBonusBlocks() > 0 ? Translatable.of((String)"msg_town_plots_town_bonus", (Object[])new Object[]{town.getBonusBlocks()}).component(locale) : Component.empty()))).append((Component)(TownySettings.getNationBonusBlocks((Town)town) > 0 ? Translatable.of((String)"msg_town_plots_town_nationbonus", (Object[])new Object[]{TownySettings.getNationBonusBlocks((Town)town)}).component(locale) : Component.empty())))))).lore(Translatable.of((String)"msg_town_plots_town_owned_land", (Object[])new Object[]{town.getTownBlocks().size() - cache.getNumberOfResidentOwnedTownBlocks()}).component(locale)).build()).title(Translatable.of((String)"town-menu-plots").component(locale)).build();
        })).build()).addItem(MenuItem.builder(Material.RED_BED).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).name(Translatable.of((String)"town-menu-spawn").component(locale)).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission("towny.town.spawn.town")) {
                return Translatable.of((String)"msg-no-permission").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-spawn-subtitle")).component(locale);
        }).action(town == null || !player.hasPermission("towny.town.spawn.town") ? ClickAction.NONE : ClickAction.confirmation(() -> Translatable.of((String)"msg-click-to-confirm", (Object[])new Object[]{"/town spawn"}).component(locale), (ClickAction)ClickAction.run(() -> {
            if (!player.hasPermission("towny.town.spawn.town")) {
                return;
            }
            try {
                TownCommand.townSpawn((Player)player, (String[])new String[0], (Boolean)false, (boolean)true);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
            player.closeInventory();
        }))).build()).addItem(MenuItem.builder(Material.ENDER_EYE).name(Translatable.of((String)"town-menu-online").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(2), HorizontalAnchor.fromLeft(1))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-online-subtitle")).component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-online-subtitle")).component(locale);
        }).action(town == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode()) ? ClickAction.NONE : ClickAction.openInventory(() -> {
            Town playerTown = TownyAPI.getInstance().getTown(player);
            if (playerTown == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_ONLINE.getNode())) {
                return MenuInventory.paginator().title(Translatable.of((String)"town-menu-online").component(locale)).build();
            }
            ArrayList<MenuItem> online = new ArrayList<MenuItem>();
            for (Player onlinePlayer : TownyAPI.getInstance().getOnlinePlayers((ResidentList)playerTown)) {
                if (!player.canSee(onlinePlayer)) continue;
                online.add(ResidentMenu.formatResidentInfo(onlinePlayer.getUniqueId(), player).build());
            }
            return MenuInventory.paginator().addItems(online).title(Translatable.of((String)"town-menu-online").component(locale)).build();
        })).build()).addItem(MenuItem.builder(Material.PLAYER_HEAD).name(Translatable.of((String)"town-menu-overview").component(locale)).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-overview-subtitle")).component(locale);
        }).action(town == null ? ClickAction.NONE : ClickAction.openInventory(() -> TownMenu.createResidentOverview(player))).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(2), HorizontalAnchor.fromRight(1))).build()).addItem(MenuItem.builder(Material.GOLDEN_AXE).name(Translatable.of((String)"town-menu-management").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(1))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-subtitle")).component(locale);
        }).action(town == null ? ClickAction.NONE : ClickAction.openInventory(() -> TownMenu.formatTownManagementMenu(player))).build()).build();
    }

    public static MenuInventory createBankHistoryMenu(Player player, Government government) {
        Locale locale = Localization.localeOrDefault(player);
        if (government == null || !TownyEconomyHandler.isActive()) {
            return MenuInventory.paginator().title(Translatable.of((String)"town-menu-transaction-history").component(locale)).build();
        }
        ArrayList<MenuItem> transactionItems = new ArrayList<MenuItem>();
        ArrayList transactions = new ArrayList(government.getAccount().getAuditor().getTransactions());
        for (int i = 0; i < transactions.size(); ++i) {
            BankTransaction transaction = (BankTransaction)transactions.get(i);
            boolean added = transaction.getType() == TransactionType.ADD || transaction.getType() == TransactionType.DEPOSIT;
            transactionItems.add(MenuItem.builder(added ? Material.EMERALD_BLOCK : Material.REDSTONE_BLOCK).name(Translatable.of((String)"town-menu-transaction-number", (Object[])new Object[]{i + 1, transaction.getTime()}).component(locale).color((TextColor)(added ? NamedTextColor.GREEN : NamedTextColor.RED))).lore(Translatable.of((String)"town-menu-transaction-amount", (Object[])new Object[]{TownyEconomyHandler.getFormattedBalance((double)transaction.getAmount())}).component(locale)).lore(Translatable.of((String)"town-menu-transaction-new-balance", (Object[])new Object[]{TownyEconomyHandler.getFormattedBalance((double)transaction.getBalance())}).component(locale)).lore(Translatable.of((String)"town-menu-transaction-reason", (Object[])new Object[]{transaction.getReason()}).component(locale)).build());
        }
        Collections.reverse(transactionItems);
        return MenuInventory.paginator().addItems(transactionItems).title(Translatable.of((String)"town-menu-transaction-history").component(locale)).build();
    }

    public static MenuInventory createResidentOverview(Player player) {
        Town town;
        Locale locale = Localization.localeOrDefault(player);
        Resident res = TownyAPI.getInstance().getResident(player);
        Town town2 = town = res != null ? res.getTownOrNull() : null;
        if (town == null) {
            return MenuInventory.paginator().title(Translatable.of((String)"town-menu-overview").component(locale)).build();
        }
        MenuInventory.PaginatorBuilder builder = MenuInventory.paginator().title(Translatable.of((String)"town-menu-overview").append(" - ").append(town.getName()).component(locale));
        for (Resident resident : town.getResidents()) {
            builder.addItem(ResidentMenu.formatResidentInfo(resident, player).lore(Translatable.of((String)"town-menu-overview-joined-town", (Object[])new Object[]{Time.registeredOrAgo(res.getJoinedTownAt(), Translation.getLocale((CommandSender)player))}).component(locale)).lore((Component)Component.space()).lore(Translatable.of((String)"msg-right-click-additional-options").component(locale)).action(ClickAction.rightClick(ClickAction.openInventory(() -> TownMenu.createResidentManagementScreen(player, town, resident)))).build());
        }
        return builder.build();
    }

    public static MenuInventory createResidentManagementScreen(Player player, Town town, Resident resident) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuInventory.builder().rows(5).title(Translatable.of((String)"town-menu-management-resident-title").component(locale)).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.WOODEN_AXE).name(Translatable.of((String)"town-menu-management-resident-kick-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_KICK.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-management-resident-kick")).component(locale);
            }
            if (player.getUniqueId().equals(resident.getUUID())) {
                return Translatable.of((String)"town-menu-management-resident-cannot-kick-self").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-resident-kick-subtitle")).component(locale);
        }).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_KICK.getNode()) || player.getUniqueId().equals(resident.getUUID()) ? ClickAction.NONE : ClickAction.confirmation((Component)Component.text((String)("Are you sure you want to kick " + resident.getName() + "?"), (TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
            if (town == null || !TownyUniverse.getInstance().hasTown(town.getUUID()) || !town.hasResident(resident)) {
                return;
            }
            try {
                TownCommand.townKick((Player)player, (String[])new String[]{resident.getName()});
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        }))).build()).addItem(ResidentMenu.formatResidentInfo(resident, player).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).build()).addItem(MenuItem.builder(Material.KNOWLEDGE_BOOK).name(Translatable.of((String)"town-menu-management-resident-ranks").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(1))).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-resident-ranks-subtitle")).component(locale)).action(ClickAction.openInventory(() -> TownMenu.formatRankManagementMenu(player, town, resident))).build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"town-menu-management-resident-title-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(3), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-management-resident-title-title-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Arrays.asList(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-resident-title-title-subtitle")).component(locale), Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"town-menu-management-resident-title-clear")).component(locale));
        }).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode()) ? ClickAction.NONE : ClickAction.leftClick(ClickAction.userInput(Translatable.of((String)"town-menu-management-resident-enter-new-title").toString(), completion -> {
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode());
                TownCommand.townSetTitle((CommandSender)player, (String[])new String[]{resident.getName(), completion.getText()}, (boolean)false);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.openPreviousMenu();
        }))).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode()) ? ClickAction.NONE : ClickAction.rightClick(ClickAction.run(() -> {
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_TOWN_SET_TITLE.getNode());
                TownCommand.townSetTitle((CommandSender)player, (String[])new String[]{resident.getName(), ""}, (boolean)false);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        }))).build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"town-menu-management-resident-surname").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(3), HorizontalAnchor.fromRight(2))).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-management-resident-surname-subtitle")).component(locale);
            }
            return Arrays.asList(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-resident-surname-subtitle")).component(locale), Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"town-menu-management-resident-surname-clear")).component(locale));
        }).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode()) ? ClickAction.NONE : ClickAction.leftClick(ClickAction.userInput(Translatable.of((String)"town-menu-management-resident-enter-new-surname").toString(), completion -> {
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode());
                TownCommand.townSetSurname((CommandSender)player, (String[])new String[]{resident.getName(), completion.getText()}, (boolean)false);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.openPreviousMenu();
        }))).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode()) ? ClickAction.NONE : ClickAction.rightClick(ClickAction.run(() -> {
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_TOWN_SET_SURNAME.getNode());
                TownCommand.townSetSurname((CommandSender)player, (String[])new String[]{resident.getName(), ""}, (boolean)false);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        }))).build()).build();
    }

    public static MenuInventory formatRankManagementMenu(Player player, Town town, Resident resident) {
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.PaginatorBuilder paginator = MenuInventory.paginator().title(Translatable.of((String)"town-menu-management-rank").component(locale));
        for (String townRank : TownyPerms.getTownRanks()) {
            MenuItem.Builder item = MenuItem.builder(Material.KNOWLEDGE_BOOK).name((Component)Component.text((String)(townRank.substring(0, 1).toUpperCase(Locale.ROOT) + townRank.substring(1)), (TextColor)NamedTextColor.GREEN));
            boolean hasPermission = player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(townRank.toLowerCase(Locale.ROOT)));
            if (resident.hasTownRank(townRank)) {
                item.withGlint();
                if (hasPermission) {
                    item.lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"rank-remove")).append(townRank).append(Translatable.of((String)"rank-from")).append(resident.getName()).append((Component)Component.text((String)".")).component(locale).color((TextColor)NamedTextColor.GRAY));
                    item.action(ClickAction.confirmation(Translatable.of((String)"rank-remove-confirmation").append(townRank).append(Translatable.of((String)"from").append(resident.getName()).append("?")).component(locale).color((TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
                        if (!resident.hasTownRank(townRank) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(townRank.toLowerCase(Locale.ROOT)))) {
                            MenuHistory.reOpen(player, () -> TownMenu.formatRankManagementMenu(player, town, resident));
                            return;
                        }
                        Resident playerResident = TownyAPI.getInstance().getResident(player);
                        if (town == null || resident.getTownOrNull() != town || playerResident == null || playerResident.getTownOrNull() != town) {
                            return;
                        }
                        TownRemoveResidentRankEvent event = new TownRemoveResidentRankEvent(resident, townRank, town);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            TownyMessaging.sendErrorMsg((Object)player, (String)event.getCancelMessage());
                            MenuHistory.reOpen(player, () -> TownMenu.formatRankManagementMenu(player, town, resident));
                            return;
                        }
                        resident.removeTownRank(townRank);
                        if (resident.isOnline()) {
                            TownyMessaging.sendMsg((Resident)resident, (Translatable)Translatable.of((String)"msg_you_have_had_rank_taken", (Object[])new Object[]{Translatable.of((String)"town_sing"), townRank}));
                            Towny.getPlugin().deleteCache(resident);
                        }
                        TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_you_have_taken_rank_from", (Object[])new Object[]{Translatable.of((String)"town_sing"), townRank, resident.getName()}));
                        MenuHistory.reOpen(player, () -> TownMenu.formatRankManagementMenu(player, town, resident));
                    })));
                }
            } else if (hasPermission) {
                item.lore(Translatable.of((String)"msg-click-to-grant-the").append(townRank).append(Translatable.of((String)"rank-to")).append(resident.getName()).append(".").component(locale).color((TextColor)NamedTextColor.GRAY));
                item.action(ClickAction.confirmation(Translatable.of((String)"rank-give-confirmation").append(townRank).append(Translatable.of((String)"to").append(resident.getName()).append("?")).component(locale).color((TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
                    if (resident.hasTownRank(townRank) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(townRank.toLowerCase(Locale.ROOT)))) {
                        MenuHistory.reOpen(player, () -> TownMenu.formatRankManagementMenu(player, town, resident));
                        return;
                    }
                    Resident playerResident = TownyAPI.getInstance().getResident(player);
                    if (town == null || resident.getTownOrNull() != town || playerResident == null || playerResident.getTownOrNull() != town) {
                        return;
                    }
                    TownAddResidentRankEvent event = new TownAddResidentRankEvent(resident, townRank, town);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg((Object)player, (String)event.getCancelMessage());
                        MenuHistory.reOpen(player, () -> TownMenu.formatRankManagementMenu(player, town, resident));
                        return;
                    }
                    resident.addTownRank(townRank);
                    if (resident.isOnline()) {
                        TownyMessaging.sendMsg((Resident)resident, (Translatable)Translatable.of((String)"msg_you_have_been_given_rank", (Object[])new Object[]{Translatable.of((String)"town_sing"), townRank}));
                        Towny.getPlugin().deleteCache(resident);
                    }
                    TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_you_have_given_rank", (Object[])new Object[]{Translatable.of((String)"town_sing"), townRank, resident.getName()}));
                    MenuHistory.reOpen(player, () -> TownMenu.formatRankManagementMenu(player, town, resident));
                })));
            }
            paginator.addItem(item.build());
        }
        return paginator.build();
    }

    public static MenuInventory formatTownManagementMenu(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuInventory.builder().rows(3).title(Translatable.of((String)"town-menu-management").component(locale)).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.GRASS_BLOCK).name(Translatable.of((String)"town-menu-management-town-menu-title").component(locale)).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-town-menu-subtitle")).component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).action(ClickAction.openInventory(() -> TownMenu.formatTownSetMenu(player))).build()).addItem(MenuItem.builder(Material.LEVER).name(Translatable.of((String)"town-menu-management-town-toggle-title").component(locale)).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-management-town-toggle-subtitle")).component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).action(ClickAction.openInventory(() -> TownMenu.formatTownToggleMenu(player))).build()).build();
    }

    public static MenuInventory formatTownToggleMenu(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Town town = TownyAPI.getInstance().getTown(player);
        boolean fireEnabled = town != null && town.isFire();
        boolean explosionEnabled = town != null && town.isExplosion();
        boolean mobsEnabled = town != null && town.hasMobs();
        boolean pvpEnabled = town != null && town.isPVP();
        boolean isOpen = town != null && town.isOpen();
        boolean isPublic = town != null && town.isPublic();
        return MenuInventory.builder().title(Translatable.of((String)"town-menu-management").component(locale)).rows(4).addItem(MenuHelper.backButton().build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)town, Material.TNT, explosionEnabled, "explosion").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).build()).addItem(MenuItem.builder(explosionEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(1))).name((Component)Component.empty()).build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)town, Material.FLINT_AND_STEEL, fireEnabled, "fire").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).build()).addItem(MenuItem.builder(fireEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(2))).name((Component)Component.empty()).build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)town, Material.BAT_SPAWN_EGG, mobsEnabled, "mobs").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(3))).build()).addItem(MenuItem.builder(mobsEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(3))).name((Component)Component.empty()).build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)town, Material.WOODEN_AXE, pvpEnabled, "pvp").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).build()).addItem(MenuItem.builder(pvpEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(4))).name((Component)Component.empty()).build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)town, Material.GRASS_BLOCK, isOpen, "open").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(6))).build()).addItem(MenuItem.builder(isOpen ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(6))).name((Component)Component.empty()).build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)town, Material.GRASS_BLOCK, isPublic, "public").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(7))).build()).addItem(MenuItem.builder(isPublic ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(7))).name((Component)Component.empty()).build()).build();
    }

    public static MenuInventory formatTownSetMenu(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Town town = TownyAPI.getInstance().getTown(player);
        return MenuInventory.builder().title(Translatable.of((String)"town-menu-town-set-title").component(locale)).rows(3).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"town-menu-town-set-change-name").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_NAME.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-town-set-change-name-subtitle")).component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-town-set-change-name-subtitle")).component(locale);
        }).action(town == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_NAME.getNode()) ? ClickAction.NONE : ClickAction.userInput(Translatable.of((String)"town-menu-town-set-enter-town-name").forLocale((CommandSender)player), completion -> {
            Town playerTown = TownyAPI.getInstance().getTown(player);
            if (playerTown == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_NAME.getNode())) {
                return InputResponse.finish();
            }
            AwaitingConfirmation.await(player);
            try {
                TownCommand.townSetName((CommandSender)player, (String[])new String[]{completion.getText().replaceAll(" ", "_")}, (Town)town);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.openPreviousMenu();
        })).build()).addItem(MenuItem.builder(Material.OAK_SIGN).name(Translatable.of((String)"town-menu-town-set-change-board").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-town-set-change-board-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Arrays.asList(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-town-set-change-board-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY), Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"town-menu-town-set-change-board-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY));
        }).action(town == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode()) ? ClickAction.NONE : ClickAction.leftClick(ClickAction.userInput(Translatable.of((String)"town-menu-town-set-enter-town-board").toString(), completion -> {
            Town playerTown = TownyAPI.getInstance().getTown(player);
            if (playerTown == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode())) {
                return InputResponse.finish();
            }
            try {
                TownCommand.townSetBoard((CommandSender)player, (String)completion.getText(), (Town)playerTown);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.reOpen(() -> TownMenu.formatTownSetMenu(player));
        }))).action(town == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode()) ? ClickAction.NONE : ClickAction.rightClick(ClickAction.run(() -> {
            Town playerTown = TownyAPI.getInstance().getTown(player);
            if (playerTown == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_BOARD.getNode())) {
                return;
            }
            try {
                TownCommand.townSetBoard((CommandSender)player, (String)"reset", (Town)playerTown);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        }))).build()).addItem(MenuItem.builder(Material.RED_BED).name(Translatable.of((String)"town-menu-town-set-change-spawn").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWN.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-town-set-change-spawn-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-town-set-change-spawn-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(town == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWN.getNode()) ? ClickAction.NONE : ClickAction.run(() -> {
            Town playerTown = TownyAPI.getInstance().getTown(player);
            if (playerTown == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_SET_SPAWN.getNode())) {
                return;
            }
            try {
                TownCommand.townSetSpawn((CommandSender)player, (Town)playerTown, (boolean)false);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        })).build()).build();
    }

    public static MenuInventory formatTownBankMenu(Player player) {
        Town town = TownyAPI.getInstance().getTown(player);
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.Builder builder = MenuInventory.builder().title(Translatable.of((String)"town-menu-bank").component(locale)).rows(3).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.EMERALD_BLOCK).name(Translatable.of((String)"town-menu-bank-deposit-or-withdraw").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!TownyEconomyHandler.isActive()) {
                return Translatable.of((String)"msg_err_no_economy").component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-bank-deposit-or-withdraw-subtitle")).component(locale);
        }).action(town == null || !TownyEconomyHandler.isActive() ? ClickAction.NONE : ClickAction.openInventory(() -> GovernmentMenus.createDepositWithdrawMenu(player, (Government)town))).build()).addItem(MenuItem.builder(Material.WRITABLE_BOOK).name(Translatable.of((String)"town-menu-bank-transaction-history").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).lore(() -> {
            if (town == null) {
                return Translatable.of((String)"msg-err-not-part-of-town").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_BANKHISTORY.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"town-menu-bank-transaction-history")).component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"town-menu-bank-transaction-history-subtitle")).component(locale);
        }).action(town != null && player.hasPermission(PermissionNodes.TOWNY_COMMAND_TOWN_BANKHISTORY.getNode()) ? ClickAction.openInventory(() -> TownMenu.createBankHistoryMenu(player, (Government)town)) : ClickAction.NONE).build());
        if (town != null && TownyEconomyHandler.isActive()) {
            builder.addItem(TownMenu.formatBankStatus(player, (Account)town.getAccount(), true).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(0), HorizontalAnchor.fromLeft(4))).build());
        }
        return builder.build();
    }

    public static MenuItem.Builder formatBankStatus(Player player, Account account, boolean town) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuItem.builder(Material.OAK_SIGN).name(Translatable.of((String)"town-menu-bank-status").component(locale)).lore(Translatable.of((String)"town-menu-bank-balance").component(locale).append((Component)Component.text((String)TownyEconomyHandler.getFormattedBalance((double)account.getCachedBalance()), (TextColor)NamedTextColor.GREEN))).lore(() -> {
            if (!player.hasPermission((town ? PermissionNodes.TOWNY_COMMAND_TOWN_BANKHISTORY : PermissionNodes.TOWNY_COMMAND_NATION_BANKHISTORY).getNode())) {
                return Component.empty();
            }
            List transactions = account.getAuditor().getTransactions();
            if (transactions.isEmpty()) {
                return Translatable.of((String)"town-menu-bank-last-transaction").append(Translatable.of((String)"town-menu-bank-no-transaction")).component(locale);
            }
            return Translatable.of((String)"town-menu-bank-last-transaction").component(locale).append((Component)Component.text((String)((BankTransaction)transactions.get(transactions.size() - 1)).getTime(), (TextColor)NamedTextColor.GREEN));
        });
    }

    public static MenuItem.Builder formatTownInfo(Player player, Town town) {
        Locale locale = Localization.localeOrDefault(player);
        if (town == null) {
            return MenuItem.builder(Material.GRASS_BLOCK).name(Translatable.of((String)"town-menu-no-town").component(locale).color((TextColor)NamedTextColor.GREEN));
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        lore.add(Translatable.of((String)"town-menu-town-info-founded").append(Time.ago(town.getRegistered()).translate()).component(locale).color((TextColor)NamedTextColor.GREEN));
        lore.add(Component.text((int)town.getNumResidents(), (TextColor)NamedTextColor.DARK_GREEN).append(Translatable.of((String)"town-menu-town-info-resident").append(town.getNumResidents() == 1 ? "" : "s").component(locale).color((TextColor)NamedTextColor.GREEN)));
        if (TownyEconomyHandler.isActive()) {
            if (TownySettings.isEconomyAsync()) {
                lore.add(Translatable.of((String)"town-menu-town-info-balance").component(locale).append((Component)Component.text((String)TownyEconomyHandler.getFormattedBalance((double)town.getAccount().getCachedBalance()), (TextColor)NamedTextColor.GREEN)));
            }
            if (town.hasUpkeep()) {
                lore.add(Translatable.of((String)"status_bank_town2").component(locale).color((TextColor)NamedTextColor.DARK_GREEN).appendSpace().append((Component)Component.text((String)TownyEconomyHandler.getFormattedBalance((double)TownySettings.getTownUpkeepCost((Town)town)), (TextColor)NamedTextColor.GREEN)));
            }
        }
        if (town.getMayor() != null) {
            lore.add(Translatable.of((String)"town-menu-town-info-owned-by").component(locale).append((Component)Component.text((String)town.getMayor().getName(), (TextColor)NamedTextColor.GREEN)));
        }
        if (town.getNationOrNull() != null) {
            lore.add(Translatable.of((String)"town-menu-town-info-member-of").component(locale).append((Component)Component.text((String)town.getNationOrNull().getName(), (TextColor)NamedTextColor.GREEN)));
        }
        return MenuItem.builder(Material.GRASS_BLOCK).name((Component)Component.text((String)town.getFormattedName(), (TextColor)NamedTextColor.GREEN)).lore(lore);
    }
}

