/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.menu;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.ResidentCommand;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.SpawnType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.SpawnUtil;
import io.github.townyadvanced.townymenus.gui.MenuHelper;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.SlotAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;
import io.github.townyadvanced.townymenus.utils.Localization;
import io.github.townyadvanced.townymenus.utils.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResidentMenu {
    public static MenuInventory createResidentMenu(@NotNull Player player) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuInventory.builder().rows(3).title(Translatable.of((String)"resident-menu-title").component(locale)).addItem(MenuItem.builder(Material.PLAYER_HEAD).name(Translatable.of((String)"resident-menu-view-friends").component(locale)).lore(Translatable.of((String)"resident-menu-view-friends-subtitle").component(locale)).slot(11).action(ClickAction.openInventory(() -> ResidentMenu.formatResidentFriends(player))).build()).addItem(ResidentMenu.formatResidentInfo(player.getUniqueId()).slot(13).build()).addItem(MenuItem.builder(Material.RED_BED).name(Translatable.of((String)"resident-menu-spawn").component(locale)).lore(player.hasPermission(PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode()) ? Translatable.of((String)"resident-res-spawn").component(locale) : Translatable.of((String)"msg-no-permission").component(locale)).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode()) ? ClickAction.NONE : ClickAction.confirmation(() -> Translatable.of((String)"msg-click-to-confirm", (Object[])new Object[]{"/resident spawn"}).component(locale), (ClickAction)ClickAction.run(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_RESIDENT_SPAWN.getNode())) {
                return;
            }
            Resident resident = TownyAPI.getInstance().getResident(player);
            if (resident == null) {
                return;
            }
            try {
                SpawnUtil.sendToTownySpawn((Player)player, (String[])new String[0], (TownyObject)resident, (String)Translatable.of((String)"msg_err_cant_afford_tp").forLocale((CommandSender)player), (boolean)false, (boolean)true, (SpawnType)SpawnType.RESIDENT);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
            player.closeInventory();
        }))).slot(15).build()).addItem(MenuHelper.backButton().build()).build();
    }

    public static MenuItem.Builder formatResidentInfo(@NotNull UUID uuid) {
        return ResidentMenu.formatResidentInfo(uuid, null);
    }

    public static MenuItem.Builder formatResidentInfo(@NotNull UUID uuid, @Nullable Player viewer) {
        return ResidentMenu.formatResidentInfo(TownyAPI.getInstance().getResident(uuid), viewer);
    }

    public static MenuItem.Builder formatResidentInfo(@Nullable Resident resident) {
        return ResidentMenu.formatResidentInfo(resident, null);
    }

    public static MenuItem.Builder formatResidentInfo(@Nullable Resident resident, @Nullable Player viewer) {
        Locale locale = Localization.localeOrDefault(viewer);
        if (resident == null) {
            return MenuItem.builder(Material.PLAYER_HEAD).name(Translatable.of((String)"msg-error").component(locale)).lore(Translatable.of((String)"resident-info-unknown").component(locale));
        }
        ArrayList<Component> lore = new ArrayList<Component>();
        Player player = resident.getPlayer();
        lore.add(Translatable.of((String)"resident-info-status").component(locale).append(player != null && (viewer == null || viewer.canSee(player)) ? Translatable.of((String)"status-online").component(locale) : Translatable.of((String)"status-offline").component(locale)));
        if (resident.hasTown()) {
            lore.add(Translatable.of((String)(resident.isMayor() ? "mayor_sing" : "res_sing")).append(Translatable.of((String)"resident-info-of")).component(locale).color((TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.text((String)resident.getTownOrNull().getName(), (TextColor)NamedTextColor.GREEN)));
            if (resident.hasNation()) {
                lore.add(Translatable.of((String)(resident.isKing() ? "king_sing" : "resident-info-member")).append(Translatable.of((String)"resident-info-of")).component(locale).color((TextColor)NamedTextColor.DARK_GREEN).append((Component)Component.text((String)resident.getNationOrNull().getName(), (TextColor)NamedTextColor.GREEN)));
            }
        }
        if (TownySettings.isEconomyAsync() && TownyEconomyHandler.isActive()) {
            lore.add(Translatable.of((String)"resident-info-balance").component(locale).append((Component)Component.text((String)TownyEconomyHandler.getFormattedBalance((double)resident.getAccount().getCachedBalance()), (TextColor)NamedTextColor.GREEN)));
        }
        lore.add(Translatable.of((String)"resident-info-registered").component(locale).append((Component)Component.text((String)Time.formatRegistered(resident.getRegistered()), (TextColor)NamedTextColor.GREEN)));
        if (!resident.isOnline()) {
            lore.add(Translatable.of((String)"resident-info-last-online").component(locale).append(Time.ago(resident.getLastOnline()).component(locale).color((TextColor)NamedTextColor.GREEN)));
        }
        return MenuItem.builder(Material.PLAYER_HEAD).skullOwner(resident.getUUID()).name((Component)Component.text((String)resident.getName(), (TextColor)NamedTextColor.GREEN)).lore(lore);
    }

    public static List<MenuItem> formatFriendsView(@NotNull Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null || resident.getFriends().size() == 0) {
            return Collections.singletonList(MenuItem.builder(Material.BARRIER).name(Translatable.of((String)"msg-error").component(locale)).lore(Translatable.of((String)"resident-menu-no-friends").component(locale)).build());
        }
        ArrayList<MenuItem> friends = new ArrayList<MenuItem>();
        for (Resident friend : resident.getFriends()) {
            friends.add(ResidentMenu.formatResidentInfo(friend.getUUID(), player).lore(Translatable.of((String)"resident-menu-remove-friend").component(locale)).action(ClickAction.rightClick(ClickAction.confirmation(() -> Translatable.of((String)"resident-menu-remove-friend-confirm", (Object[])new Object[]{friend.getName()}).component(locale), (ClickAction)ClickAction.run(() -> {
                if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode())) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_err_command_disable"));
                    return;
                }
                if (!resident.hasFriend(friend)) {
                    return;
                }
                ResidentCommand.residentFriendRemove((Player)player, (Resident)resident, Collections.singletonList(friend));
                MenuHistory.reOpen(player, () -> ResidentMenu.formatResidentFriends(player));
            })))).build());
        }
        return friends;
    }

    private static MenuInventory formatResidentFriends(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.PaginatorBuilder builder = MenuInventory.paginator().title(Translatable.of((String)"resident-menu-friends-title").component(locale)).addItems(ResidentMenu.formatFriendsView(player));
        if (player.hasPermission(PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode())) {
            builder.addExtraItem(MenuItem.builder(Material.WRITABLE_BOOK).name(Translatable.of((String)"resident-menu-add-friend").component(locale)).lore(Translatable.of((String)"resident-menu-add-friend-subtitle").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromLeft(1))).action(ClickAction.userInput(Translatable.of((String)"resident-menu-add-friend-prompt").translate(locale), completion -> {
                if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_RESIDENT_FRIEND.getNode())) {
                    return InputResponse.finish();
                }
                Resident resident = TownyAPI.getInstance().getResident(player);
                if (resident == null) {
                    return InputResponse.errorMessage(Translatable.of((String)"msg_err_not_registered").component(locale));
                }
                Resident friend = TownyAPI.getInstance().getResident(completion.getText());
                if (friend == null || friend.isNPC() || friend.getUUID().equals(resident.getUUID())) {
                    return InputResponse.errorMessage(Translatable.of((String)"resident-menu-add-friend-invalid", (Object[])new Object[]{completion.getText()}).component(locale));
                }
                if (resident.hasFriend(friend)) {
                    return InputResponse.errorMessage(Translatable.of((String)"resident-menu-add-friend-already-friend", (Object[])new Object[]{friend.getName()}).component(locale));
                }
                ArrayList<Resident> friends = new ArrayList<Resident>();
                friends.add(friend);
                ResidentCommand.residentFriendAdd((Player)player, (Resident)resident, friends);
                return InputResponse.reOpen(() -> ResidentMenu.formatResidentFriends(player));
            })).build());
        }
        return builder.build();
    }
}

