/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.menu;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.PlotCommand;
import com.palmergames.bukkit.towny.event.PlotPreChangeTypeEvent;
import com.palmergames.bukkit.towny.event.plot.PlotTrustAddEvent;
import com.palmergames.bukkit.towny.event.plot.PlotTrustRemoveEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.PermissionData;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownBlockTypeHandler;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.utils.PermissionGUIUtil;
import io.github.townyadvanced.townymenus.gui.MenuHelper;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import io.github.townyadvanced.townymenus.gui.action.RunnableAction;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.SlotAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;
import io.github.townyadvanced.townymenus.listeners.AwaitingConfirmation;
import io.github.townyadvanced.townymenus.menu.ResidentMenu;
import io.github.townyadvanced.townymenus.utils.Localization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class PlotMenu {
    public static MenuInventory createPlotMenu(@NotNull Player player) {
        return PlotMenu.createPlotMenu(player, WorldCoord.parseWorldCoord((Entity)player));
    }

    public static MenuInventory createPlotMenu(@NotNull Player player, WorldCoord worldCoord) {
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
        Locale locale = Localization.localeOrDefault(player);
        boolean isOwner = PlotMenu.testPlotOwner(player, worldCoord);
        boolean isWilderness = townBlock == null;
        return MenuInventory.builder().title(Translatable.of((String)"plot-menu-title").component(locale)).rows(4).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"plot-menu-plot-set").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).lore((Component)(isWilderness ? Translatable.of((String)"plot-menu-cannot-open-in-wilderness").component(locale) : Component.empty())).action(isWilderness ? ClickAction.NONE : ClickAction.openInventory(() -> PlotMenu.createPlotSetMenu(player, worldCoord, isOwner))).build()).addItem(MenuItem.builder(Material.EMERALD_BLOCK).name(Translatable.of((String)"plot-menu-sell-plot").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(3))).lore(() -> {
            if (isWilderness) {
                return Translatable.of((String)"plot-menu-cannot-sell-wild-plot").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"plot-menu-put-for-sale")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!isOwner) {
                return Translatable.of((String)"plot-menu-sell-not-owner").component(locale);
            }
            return Component.empty();
        }).action(isOwner && player.hasPermission(townBlock != null && townBlock.hasPlotObjectGroup() ? PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_FORSALE.getNode() : PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode()) ? PlotMenu.putForSaleOrOpenForSaleMenu(player, worldCoord) : ClickAction.NONE).build()).addItem(MenuItem.builder(Material.REDSTONE_BLOCK).name(Translatable.of((String)"plot-menu-sell-plot").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(3))).lore(() -> {
            if (isWilderness) {
                return Translatable.of((String)"plot-menu-cannot-sell-wild-plot").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"plot-menu-put-for-sale")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!isOwner) {
                return Translatable.of((String)"plot-menu-sell-not-owner").component(locale);
            }
            return Component.empty();
        }).action(isOwner && player.hasPermission(townBlock != null && townBlock.hasPlotObjectGroup() ? PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_NOTFORSALE.getNode() : PermissionNodes.TOWNY_COMMAND_PLOT_NOTFORSALE.getNode()) ? ClickAction.run(() -> PlotMenu.putNotForSale(player, worldCoord)) : ClickAction.NONE).build()).addItem(MenuItem.builder(Material.OAK_SIGN).name(Translatable.of((String)"plot-menu-trusted-players").component(locale)).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-trusted-players-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(1))).action(ClickAction.openInventory(() -> PlotMenu.formatPlotTrustMenu(player, worldCoord))).build()).addItem(MenuItem.builder(Material.GRASS_BLOCK).name(Translatable.of((String)"plot-menu-claim-plot-title").component(locale)).lore(() -> {
            if (townBlock == null) {
                return Translatable.of((String)"plot-menu-only-claim-town-plots").component(locale);
            }
            if (!townBlock.isForSale()) {
                return Translatable.of((String)"plot-menu-only-claim-for-sale-plots").component(locale);
            }
            return Arrays.asList(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-claim-plot")).component(locale), !TownyEconomyHandler.isActive() ? Component.empty() : Translatable.of((String)"plot-menu-claim-plot-will-cost").append(TownyEconomyHandler.getFormattedBalance((double)townBlock.getPlotPrice())).append(".").component(locale).color((TextColor)NamedTextColor.GRAY));
        }).action(ClickAction.run(() -> PlotMenu.plotCommand().ifPresent(plotCommand -> {
            block2: {
                AwaitingConfirmation.await(player);
                try {
                    plotCommand.parsePlotCommand(player, new String[]{"claim"});
                }
                catch (Exception e) {
                    if (!(e instanceof TownyException)) break block2;
                    TownyException tex = (TownyException)((Object)((Object)((Object)e)));
                    TownyMessaging.sendErrorMsg((Object)player, (String)tex.getMessage((CommandSender)player));
                }
            }
        }))).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(5))).build()).addItem(MenuItem.builder(Material.LEVER).name(Translatable.of((String)"plot-menu-plot-toggle-title").component(locale)).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-plot-toggle-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(5))).action(ClickAction.openInventory(() -> PlotMenu.formatPlotToggle(player, worldCoord))).build()).addItem(MenuItem.builder(Material.GRAY_WOOL).name(Translatable.of((String)"plot-menu-plot-permission-overrides-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(1))).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-plot-permission-overrides-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY)).action(ClickAction.openInventory(() -> PlotMenu.formatPlotPermissionOverrideMenu(player, worldCoord))).build()).build();
    }

    private static MenuInventory createPlotSetMenu(Player player, WorldCoord worldCoord, boolean isOwner) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuInventory.builder().rows(4).title(Translatable.of((String)"plot-menu-plot-set-title").component(locale)).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.NAME_TAG).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).name(Translatable.of((String)"plot-menu-plot-set-name-title").component(locale)).lore(Translatable.of((String)"plot-menu-plot-set-name-subtitle").component(locale)).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"plot-menu-plot-set-name")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!isOwner) {
                return Translatable.of((String)"plot-menu-only-owner-can-set-name").component(locale);
            }
            return Component.empty();
        }).action(!isOwner || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode()) ? ClickAction.NONE : ClickAction.userInput("Input new plot name", completion -> {
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
            if (townBlock == null || !PlotMenu.testPlotOwner(player, worldCoord) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode())) {
                return InputResponse.openPreviousMenu();
            }
            String newName = completion.getText().replaceAll(" ", "_");
            return PlotMenu.plotCommand().map(command -> {
                try {
                    command.parsePlotSetName(player, new String[]{newName}, townBlock);
                    return InputResponse.openPreviousMenu();
                }
                catch (TownyException e) {
                    return InputResponse.errorMessage(e.getMessage((CommandSender)player));
                }
            }).orElse(InputResponse.openPreviousMenu());
        })).build()).addItem(MenuItem.builder(Material.REDSTONE_BLOCK).name(Translatable.of((String)"plot-menu-clear-plot-name-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(3))).lore(Translatable.of((String)"plot-menu-clear-plot-name-subtitle").component(locale)).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"plot-menu-clear-plot-name")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!isOwner) {
                return Translatable.of((String)"plot-menu-only-owner-clear-plot-name").component(locale);
            }
            return Component.empty();
        }).action(!isOwner || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode()) ? ClickAction.NONE : ClickAction.confirmation(() -> Component.text((String)"Click to confirm removing the plot's name.", (TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
            if (townBlock == null || !PlotMenu.testPlotOwner(player, worldCoord) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET_NAME.getNode())) {
                MenuHistory.last(player);
                return;
            }
            townBlock.setName("");
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_plot_name_removed"));
            MenuHistory.reOpen(player, () -> PlotMenu.createPlotSetMenu(player, worldCoord, true));
        }))).build()).addItem(MenuItem.builder(Material.GRASS_BLOCK).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(1))).name(Translatable.of((String)"plot-menu-set-plot-type-title").component(locale)).lore(Translatable.of((String)"plot-menu-set-plot-type-subtitle").component(locale)).lore((Component)(!isOwner ? Component.text((String)"plot-menu-only-owner-can-set-plot-type") : Component.empty())).action(!isOwner ? ClickAction.NONE : ClickAction.openInventory(() -> PlotMenu.formatPlotSetType(player, worldCoord))).build()).build();
    }

    private static MenuInventory formatPlotSetType(Player player, WorldCoord worldCoord) {
        Locale locale = Localization.localeOrDefault(player);
        ArrayList<MenuItem> plotTypeItems = new ArrayList<MenuItem>();
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
        TownBlockType currentType = townBlock == null ? null : townBlock.getType();
        PlotGroup group = townBlock == null ? null : townBlock.getPlotObjectGroup();
        for (TownBlockType type : TownBlockTypeHandler.getTypes().values()) {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(type.getName().toLowerCase(Locale.ROOT)))) continue;
            boolean alreadySelected = type == currentType;
            double changeCost = group == null ? type.getCost() : type.getCost() * (double)group.getTownBlocks().size();
            Runnable onClick = () -> {
                if (!PlotMenu.testPlotOwner(player, worldCoord) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_SET.getNode(type.getName().toLowerCase(Locale.ROOT)))) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"plot-menu-change-plot-type")));
                    MenuHistory.back(player);
                    return;
                }
                TownBlock townBlock1 = TownyAPI.getInstance().getTownBlock(worldCoord);
                if (townBlock1 == null || townBlock1.getTypeName().equalsIgnoreCase(type.getName())) {
                    return;
                }
                PlotGroup plotGroup = townBlock1.getPlotObjectGroup();
                double cost = plotGroup == null ? type.getCost() : type.getCost() * (double)plotGroup.getTownBlocks().size();
                Resident resident = TownyAPI.getInstance().getResident(player);
                if (cost > 0.0 && TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(cost)) {
                    TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_err_cannot_afford_plot_set_type_cost", (Object[])new Object[]{type.getFormattedName(), TownyEconomyHandler.getFormattedBalance((double)cost)}));
                    MenuHistory.reOpen(player, () -> PlotMenu.formatPlotSetType(player, worldCoord));
                    return;
                }
                if (plotGroup == null) {
                    if (TownBlockType.ARENA.equals((Object)type) && TownySettings.getOutsidersPreventPVPToggle()) {
                        for (Player target : Bukkit.getOnlinePlayers()) {
                            if (townBlock1.getTownOrNull().hasResident(target) || player.getName().equals(target.getName()) || !worldCoord.equals((Object)WorldCoord.parseWorldCoord((Entity)target))) continue;
                            TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_cant_toggle_pvp_outsider_in_plot"));
                            MenuHistory.reOpen(player, () -> PlotMenu.formatPlotSetType(player, worldCoord));
                            return;
                        }
                    }
                    PlotPreChangeTypeEvent preEvent = new PlotPreChangeTypeEvent(type, townBlock1, resident);
                    Bukkit.getPluginManager().callEvent((Event)preEvent);
                    if (preEvent.isCancelled()) {
                        TownyMessaging.sendErrorMsg((Object)player, (String)preEvent.getCancelMessage());
                        return;
                    }
                    try {
                        townBlock1.setType(type, resident);
                    }
                    catch (TownyException e) {
                        TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
                        MenuHistory.reOpen(player, () -> PlotMenu.formatPlotSetType(player, worldCoord));
                        return;
                    }
                } else {
                    for (TownBlock groupBlock : plotGroup.getTownBlocks()) {
                        if (TownBlockType.ARENA.equals((Object)type) && TownySettings.getOutsidersPreventPVPToggle()) {
                            for (Player target : Bukkit.getOnlinePlayers()) {
                                if (townBlock1.getTownOrNull().hasResident(target) || player.getName().equals(target.getName()) || !groupBlock.getWorldCoord().equals((Object)WorldCoord.parseWorldCoord((Entity)target))) continue;
                                TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_cant_toggle_pvp_outsider_in_plot"));
                                MenuHistory.reOpen(player, () -> PlotMenu.formatPlotSetType(player, worldCoord));
                                return;
                            }
                        }
                        PlotPreChangeTypeEvent preEvent = new PlotPreChangeTypeEvent(type, groupBlock, resident);
                        Bukkit.getPluginManager().callEvent((Event)preEvent);
                        if (!preEvent.isCancelled()) continue;
                        TownyMessaging.sendErrorMsg((Object)player, (String)preEvent.getCancelMessage());
                        return;
                    }
                    TownBlockType oldGroupType = plotGroup.getTownBlockType();
                    ArrayList<TownBlock> alteredTownBlocks = new ArrayList<TownBlock>();
                    for (TownBlock groupBlock : plotGroup.getTownBlocks()) {
                        try {
                            alteredTownBlocks.add(groupBlock);
                            groupBlock.setType(type, resident);
                        }
                        catch (TownyException e) {
                            TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
                            for (TownBlock alteredBlock : alteredTownBlocks) {
                                alteredBlock.setType(oldGroupType);
                                alteredBlock.save();
                            }
                            MenuHistory.reOpen(player, () -> PlotMenu.formatPlotSetType(player, worldCoord));
                            return;
                        }
                    }
                }
                if (cost > 0.0 && TownyEconomyHandler.isActive()) {
                    resident.getAccount().withdraw(cost, String.format("Plot set to %s", type.getFormattedName()));
                    TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_plot_set_cost", (Object[])new Object[]{cost, type.getFormattedName()}));
                }
                TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)(plotGroup == null ? "msg_plot_set_type" : "msg_set_group_type_to_x"), (Object[])new Object[]{type.getFormattedName()}));
                MenuHistory.reOpen(player, () -> PlotMenu.formatPlotSetType(player, worldCoord));
            };
            plotTypeItems.add(MenuItem.builder(Material.GRASS_BLOCK).name((Component)Component.text((String)type.getFormattedName(), (TextColor)NamedTextColor.GREEN)).lore(alreadySelected ? Translatable.of((String)"plot-menu-plot-currently-selected").component(locale) : Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-change-plot-type-to")).append(type.getFormattedName() + ".").component(locale).color((TextColor)NamedTextColor.GRAY)).lore((Component)(!alreadySelected && changeCost > 0.0 && TownyEconomyHandler.isActive() ? Translatable.of((String)"plot-menu-setting-type-cost").append(TownyEconomyHandler.getFormattedBalance((double)changeCost) + ".").component(locale).color((TextColor)NamedTextColor.GRAY) : Component.empty())).lore((Component)(!alreadySelected && TownyEconomyHandler.isActive() && townBlock.getTownOrNull() != null && type.getTax(townBlock.getTownOrNull()) > 0.0 ? Translatable.of((String)"plot-menu-plot-type-tax", (Object[])new Object[]{TownyEconomyHandler.getFormattedBalance((double)type.getTax(townBlock.getTownOrNull()))}).component(locale) : Component.empty())).withGlint(alreadySelected).action(alreadySelected ? ClickAction.NONE : (changeCost > 0.0 && TownyEconomyHandler.isActive() ? ClickAction.confirmation(() -> Translatable.of((String)"plot-menu-change-type-cost").append(TownyEconomyHandler.getFormattedBalance((double)changeCost)).append("plot-menu-change-type-confirm").component(locale).color((TextColor)NamedTextColor.RED), (ClickAction)ClickAction.run(onClick)) : ClickAction.run(onClick))).build());
        }
        return MenuInventory.paginator().addItems(plotTypeItems).title(Translatable.of((String)"plot-menu-select-plot-type").component(locale)).build();
    }

    private static ClickAction putForSaleOrOpenForSaleMenu(Player player, WorldCoord worldCoord) {
        Locale locale = Localization.localeOrDefault(player);
        RunnableAction putForSale = ClickAction.run(() -> {
            PermissionNodes node;
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
            PermissionNodes permissionNodes = node = townBlock != null && townBlock.hasPlotObjectGroup() ? PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_FORSALE : PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE;
            if (townBlock == null || !player.hasPermission(node.getNode()) || !PlotMenu.testPlotOwner(player, worldCoord)) {
                if (TownyEconomyHandler.isActive()) {
                    MenuHistory.back(player);
                }
                return;
            }
            PlotMenu.putTownBlockForSale(player, townBlock, 0.0);
            if (TownyEconomyHandler.isActive()) {
                MenuHistory.back(player);
            }
        });
        if (!TownyEconomyHandler.isActive()) {
            return putForSale;
        }
        return ClickAction.openInventory(() -> MenuInventory.builder().rows(3).title(Translatable.of((String)"plot-menu-plot-sell-price-title").component(locale)).addItem(MenuItem.builder(Material.PAPER).name(Translatable.of((String)"plot-menu-plot-sell-custom-amount").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-plot-sell-enter-new-amount")).component(locale)).action(ClickAction.userInput(Translatable.of((String)"plot-menu-plot-sell-enter-plot-price").translate(locale), completion -> {
            double plotPrice;
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
            if (townBlock == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_FORSALE.getNode()) || !PlotMenu.testPlotOwner(player, townBlock)) {
                return InputResponse.reOpen(() -> PlotMenu.createPlotMenu(player, worldCoord));
            }
            try {
                plotPrice = Double.parseDouble(completion.getText());
            }
            catch (NumberFormatException e) {
                return InputResponse.errorMessage(Translatable.of((String)"plot-menu-plot-sell-invalid-price", (Object[])new Object[]{completion.getText()}).component(locale));
            }
            if (plotPrice < 0.0) {
                return InputResponse.errorMessage(Translatable.of((String)"plot-menu-plot-sell-invalid-price", (Object[])new Object[]{completion.getText()}).component(locale));
            }
            PlotMenu.putTownBlockForSale(player, townBlock, plotPrice);
            return InputResponse.reOpen(() -> PlotMenu.createPlotMenu(player, worldCoord));
        })).build()).addItem(MenuItem.builder(Material.EMERALD).name(Translatable.of((String)"plot-menu-plot-sell-free").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-plot-sell-for-free")).component(locale)).action(putForSale).build()).addItem(MenuHelper.backButton().build()).build());
    }

    private static void putTownBlockForSale(Player player, TownBlock townBlock, double price) {
        PlotGroup group = townBlock.getPlotObjectGroup();
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (group == null) {
            townBlock.setPlotPrice(Math.min(price, TownySettings.getMaxPlotPrice()));
            townBlock.save();
            TownyMessaging.sendPrefixedTownMessage((Town)townBlock.getTownOrNull(), (Translatable)Translatable.of((String)"msg_plot_for_sale", (Object[])new Object[]{player.getName(), townBlock.getWorldCoord().toString()}));
            if (resident == null || !resident.hasTown() || townBlock.getTownOrNull() != resident.getTownOrNull()) {
                TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_plot_for_sale", (Object[])new Object[]{player.getName(), townBlock.getWorldCoord().toString()}));
            }
        } else {
            group.setPrice(Math.min(price, TownySettings.getMaxPlotPrice()));
            group.save();
            Translatable message = Translatable.of((String)"msg_player_put_group_up_for_sale", (Object[])new Object[]{player.getName(), group.getName(), TownyEconomyHandler.getFormattedBalance((double)group.getPrice())});
            TownyMessaging.sendPrefixedTownMessage((Town)townBlock.getTownOrNull(), (Translatable)message);
            if (resident == null || !resident.hasTown() || resident.getTownOrNull() != townBlock.getTownOrNull()) {
                TownyMessaging.sendMsg((CommandSender)player, (Translatable)message);
            }
        }
    }

    private static void putNotForSale(Player player, WorldCoord worldCoord) {
        PermissionNodes node;
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
        PermissionNodes permissionNodes = node = townBlock != null && townBlock.hasPlotObjectGroup() ? PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_NOTFORSALE : PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_FORSALE;
        if (townBlock == null || !player.hasPermission(node.getNode()) || !PlotMenu.testPlotOwner(player, townBlock)) {
            return;
        }
        PlotGroup group = townBlock.getPlotObjectGroup();
        if (group == null) {
            if (townBlock.getPlotPrice() == -1.0) {
                return;
            }
            townBlock.setPlotPrice(-1.0);
            townBlock.save();
            TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_plot_set_to_nfs"));
        } else {
            if (group.getPrice() == -1.0) {
                return;
            }
            group.setPrice(-1.0);
            group.save();
            TownyMessaging.sendPrefixedTownMessage((Town)townBlock.getTownOrNull(), (Translatable)Translatable.of((String)"msg_player_made_group_not_for_sale", (Object[])new Object[]{player.getName(), group.getName()}));
            Resident resident = TownyAPI.getInstance().getResident(player);
            if (resident == null || !resident.hasTown() || resident.getTownOrNull() != townBlock.getTownOrNull()) {
                TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_player_made_group_not_for_sale", (Object[])new Object[]{player.getName(), group.getName()}));
            }
        }
    }

    private static MenuInventory formatPlotTrustMenu(Player player, WorldCoord worldCoord) {
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.PaginatorBuilder builder = MenuInventory.paginator().title(Translatable.of((String)"plot-menu-trust-menu-title").component(locale));
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
        if (townBlock == null) {
            return builder.build();
        }
        PlotGroup plotGroup = townBlock.getPlotObjectGroup();
        boolean canAddRemove = player.hasPermission(plotGroup == null ? PermissionNodes.TOWNY_COMMAND_PLOT_TRUST.getNode() : PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TRUST.getNode()) && PlotMenu.testPlotOwner(player, townBlock);
        for (Resident trustedResident : townBlock.getTrustedResidents()) {
            MenuItem.Builder itemBuilder = ResidentMenu.formatResidentInfo(trustedResident, player);
            if (canAddRemove) {
                itemBuilder.lore(Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"plot-menu-trust-menu-remove")).component(locale)).action(ClickAction.rightClick(ClickAction.confirmation(() -> Translatable.of((String)"Are you sure you want to remove ", (Object[])new Object[]{trustedResident.getName(), " as trusted?"}).component(locale), (ClickAction)ClickAction.run(() -> {
                    TownBlock townBlock1 = TownyAPI.getInstance().getTownBlock(worldCoord);
                    if (townBlock1 == null) {
                        return;
                    }
                    PlotGroup group = townBlock1.getPlotObjectGroup();
                    if (!player.hasPermission(group == null ? PermissionNodes.TOWNY_COMMAND_PLOT_TRUST.getNode() : PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TRUST.getNode()) || !PlotMenu.testPlotOwner(player, townBlock1)) {
                        TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_err_command_disable"));
                        MenuHistory.back(player);
                        return;
                    }
                    if (group == null) {
                        PlotTrustRemoveEvent event = new PlotTrustRemoveEvent(townBlock, trustedResident, player);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            TownyMessaging.sendErrorMsg((Object)player, (String)event.getCancelMessage());
                            return;
                        }
                        townBlock.removeTrustedResident(trustedResident);
                        Towny.getPlugin().deleteCache(trustedResident);
                        TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_trusted_removed", (Object[])new Object[]{trustedResident.getName(), Translatable.of((String)"townblock")}));
                        if (trustedResident.isOnline() && !trustedResident.getName().equals(player.getName())) {
                            TownyMessaging.sendMsg((Resident)trustedResident, (Translatable)Translatable.of((String)"msg_trusted_removed_2", (Object[])new Object[]{player.getName(), Translatable.of((String)"townblock"), townBlock.getWorldCoord().getCoord().toString()}));
                        }
                    } else {
                        PlotTrustRemoveEvent event = new PlotTrustRemoveEvent(new ArrayList(group.getTownBlocks()), trustedResident, player);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            TownyMessaging.sendErrorMsg((Object)player, (String)event.getCancelMessage());
                            MenuHistory.back(player);
                            return;
                        }
                        group.removeTrustedResident(trustedResident);
                        Towny.getPlugin().deleteCache(trustedResident);
                        TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_trusted_removed", (Object[])new Object[]{trustedResident.getName(), Translatable.of((String)"plotgroup_sing")}));
                        if (trustedResident.isOnline() && !trustedResident.getName().equals(player.getName())) {
                            TownyMessaging.sendMsg((Resident)trustedResident, (Translatable)Translatable.of((String)"msg_trusted_removed_2", (Object[])new Object[]{player.getName(), Translatable.of((String)"plotgroup_sing"), group.getName()}));
                        }
                    }
                    MenuHistory.reOpen(player, () -> PlotMenu.formatPlotTrustMenu(player, worldCoord));
                }))));
            }
            builder.addItem(itemBuilder.build());
        }
        if (canAddRemove) {
            builder.addExtraItem(MenuItem.builder(Material.WRITABLE_BOOK).name(Translatable.of((String)"plot-menu-trust-add").component(locale)).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-trust-add-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromLeft(1))).action(ClickAction.userInput(Translatable.of((String)"plot-menu-trust-enter-player").translate(locale), completion -> {
                Resident resident = TownyAPI.getInstance().getResident(completion.getText());
                if (resident == null) {
                    return InputResponse.errorMessage(Translatable.of((String)"plot-menu-trust-invalid-resident").component(locale));
                }
                TownBlock townBlock1 = TownyAPI.getInstance().getTownBlock(worldCoord);
                if (townBlock1 == null) {
                    return InputResponse.finish();
                }
                PlotGroup group = townBlock1.getPlotObjectGroup();
                if (!player.hasPermission(group == null ? PermissionNodes.TOWNY_COMMAND_PLOT_TRUST.getNode() : PermissionNodes.TOWNY_COMMAND_PLOT_GROUP_TRUST.getNode()) || !PlotMenu.testPlotOwner(player, townBlock1)) {
                    return InputResponse.finish();
                }
                if (group == null) {
                    if (townBlock1.hasTrustedResident(resident)) {
                        return InputResponse.errorMessage(Translatable.of((String)"plot-menu-trust-already", (Object[])new Object[]{resident.getName()}).component(locale));
                    }
                    PlotTrustAddEvent event = new PlotTrustAddEvent(townBlock, resident, player);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return InputResponse.errorMessage(event.getCancelMessage());
                    }
                    townBlock.addTrustedResident(resident);
                    Towny.getPlugin().deleteCache(resident);
                    TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_trusted_added", (Object[])new Object[]{resident.getName(), Translatable.of((String)"townblock")}));
                    if (resident.isOnline() && !resident.getName().equals(player.getName())) {
                        TownyMessaging.sendMsg((Resident)resident, (Translatable)Translatable.of((String)"msg_trusted_added_2", (Object[])new Object[]{player.getName(), Translatable.of((String)"townblock"), townBlock.getWorldCoord().getCoord().toString()}));
                    }
                } else {
                    if (group.hasTrustedResident(resident)) {
                        return InputResponse.errorMessage(Translatable.of((String)"plot-menu-trust-already", (Object[])new Object[]{resident.getName()}).component(locale));
                    }
                    PlotTrustAddEvent event = new PlotTrustAddEvent(new ArrayList(group.getTownBlocks()), resident, player);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return InputResponse.errorMessage(event.getCancelMessage());
                    }
                    group.addTrustedResident(resident);
                    Towny.getPlugin().deleteCache(resident);
                    TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_trusted_added", (Object[])new Object[]{resident.getName(), Translatable.of((String)"plotgroup_sing")}));
                    if (resident.isOnline() && !resident.getName().equals(player.getName())) {
                        TownyMessaging.sendMsg((Resident)resident, (Translatable)Translatable.of((String)"msg_trusted_added_2", (Object[])new Object[]{player.getName(), Translatable.of((String)"plotgroup_sing"), group.getName()}));
                    }
                }
                return InputResponse.reOpen(() -> PlotMenu.formatPlotTrustMenu(player, worldCoord));
            })).build());
        }
        return builder.build();
    }

    private static MenuInventory formatPlotPermissionOverrideMenu(Player player, WorldCoord worldCoord) {
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.PaginatorBuilder builder = MenuInventory.paginator().title(Translatable.of((String)"plot-menu-permission-override-title").component(locale));
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
        if (townBlock == null) {
            return builder.build();
        }
        boolean canEdit = PlotMenu.testPlotOwner(player, worldCoord);
        for (Map.Entry entry : townBlock.getPermissionOverrides().entrySet()) {
            MenuItem.Builder itemBuilder = MenuItem.builder(Material.PLAYER_HEAD).name((Component)Component.text((String)((Resident)entry.getKey()).getName(), (TextColor)NamedTextColor.GREEN)).skullOwner(((Resident)entry.getKey()).getUUID()).lore(PlotMenu.formatPermissionTypes(player, ((PermissionData)entry.getValue()).getPermissionTypes()));
            if (canEdit) {
                if (((PermissionData)entry.getValue()).getLastChangedAt() > 0L && !((PermissionData)entry.getValue()).getLastChangedBy().isEmpty()) {
                    itemBuilder.lore(Translatable.of((String)"msg_last_edited", (Object[])new Object[]{TownyFormatter.lastOnlineFormat.format(((PermissionData)entry.getValue()).getLastChangedAt()), ((PermissionData)entry.getValue()).getLastChangedBy()}).component(locale));
                }
                itemBuilder.lore(Translatable.of((String)"msg_click_to_edit").component(locale)).lore(Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"plot-menu-remove-override")).component(locale).color((TextColor)NamedTextColor.GOLD)).action(ClickAction.leftClick(ClickAction.openInventory(() -> PlotMenu.openPermissionOverrideEditor(player, worldCoord, (Resident)entry.getKey(), (PermissionData)entry.getValue())))).action(ClickAction.rightClick(ClickAction.confirmation(Translatable.of((String)"plot-menu-remove-override-confirm").component(locale).color((TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
                    TownBlock tb = TownyAPI.getInstance().getTownBlock(worldCoord);
                    if (tb == null || !PlotMenu.testPlotOwner(player, tb) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_PERM_REMOVE.getNode())) {
                        MenuHistory.reOpen(player, () -> PlotMenu.formatPlotPermissionOverrideMenu(player, worldCoord));
                        return;
                    }
                    PlotGroup group = tb.getPlotObjectGroup();
                    if (group == null) {
                        tb.getPermissionOverrides().remove(entry.getKey());
                        tb.save();
                    } else {
                        group.removePermissionOverride((Resident)entry.getKey());
                        group.save();
                    }
                    Towny.getPlugin().deleteCache((Resident)entry.getKey());
                    MenuHistory.reOpen(player, () -> PlotMenu.formatPlotPermissionOverrideMenu(player, worldCoord));
                }))));
            }
            builder.addItem(itemBuilder.build());
        }
        if (canEdit) {
            builder.addExtraItem(MenuItem.builder(Material.WRITABLE_BOOK).name(Translatable.of((String)"plot-menu-permission-add-player").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromLeft(1))).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"plot-menu-permission-add-player-subtitle")).component(locale).color((TextColor)NamedTextColor.GRAY)).action(ClickAction.userInput(Translatable.of((String)"plot-menu-permission-enter-player-name").translate(locale), completion -> {
                TownBlock tb = TownyAPI.getInstance().getTownBlock(worldCoord);
                if (tb == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_PERM_ADD.getNode()) || !PlotMenu.testPlotOwner(player, tb)) {
                    return InputResponse.reOpen(() -> PlotMenu.formatPlotPermissionOverrideMenu(player, worldCoord));
                }
                Resident toAdd = TownyAPI.getInstance().getResident(completion.getText());
                if (toAdd == null) {
                    return InputResponse.errorMessage(Translatable.of((String)"msg_err_not_registered_1", (Object[])new Object[]{completion.getText()}).component(locale));
                }
                if (tb.getPermissionOverrides().containsKey(toAdd)) {
                    return InputResponse.errorMessage(Translatable.of((String)"msg_overrides_already_set", (Object[])new Object[]{toAdd.getName(), Translatable.of((String)"townblock")}).component(locale));
                }
                PlotGroup group = tb.getPlotObjectGroup();
                if (group != null) {
                    group.putPermissionOverride(toAdd, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
                    group.save();
                } else {
                    tb.getPermissionOverrides().put(toAdd, new PermissionData(PermissionGUIUtil.getDefaultTypes(), player.getName()));
                    tb.save();
                }
                TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_overrides_added", (Object[])new Object[]{toAdd.getName()}));
                return InputResponse.reOpen(() -> PlotMenu.formatPlotPermissionOverrideMenu(player, worldCoord));
            })).build());
        }
        return builder.build();
    }

    private static List<Component> formatPermissionTypes(Player player, PermissionGUIUtil.SetPermissionType[] types) {
        Locale locale = Localization.localeOrDefault(player);
        return Arrays.asList(Translatable.of((String)"plot-menu-permission-build").component(locale).color((TextColor)PlotMenu.colorFromType(types[TownyPermission.ActionType.BUILD.getIndex()])).append((Component)Component.text((String)"   | ", (TextColor)NamedTextColor.DARK_GRAY)).append(Translatable.of((String)"plot-menu-permission-destroy").component(locale).color((TextColor)PlotMenu.colorFromType(types[TownyPermission.ActionType.DESTROY.getIndex()]))), Translatable.of((String)"plot-menu-permission-switch").component(locale).color((TextColor)PlotMenu.colorFromType(types[TownyPermission.ActionType.SWITCH.getIndex()])).append((Component)Component.text((String)"   | ", (TextColor)NamedTextColor.DARK_GRAY)).append(Translatable.of((String)"plot-menu-permission-item").component(locale).color((TextColor)PlotMenu.colorFromType(types[TownyPermission.ActionType.ITEM_USE.getIndex()]))));
    }

    private static NamedTextColor colorFromType(PermissionGUIUtil.SetPermissionType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PermissionGUIUtil.SetPermissionType.UNSET -> NamedTextColor.DARK_GRAY;
            case PermissionGUIUtil.SetPermissionType.SET -> NamedTextColor.DARK_GREEN;
            case PermissionGUIUtil.SetPermissionType.NEGATED -> NamedTextColor.DARK_RED;
        };
    }

    private static MenuInventory openPermissionOverrideEditor(Player player, WorldCoord worldCoord, Resident resident, PermissionData data) {
        MenuInventory.Builder builder = MenuInventory.builder().title(Translatable.of((String)"permission_gui_header").locale(resident).component()).rows(5).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.PLAYER_HEAD).name((Component)Component.text((String)resident.getName(), (TextColor)NamedTextColor.GREEN)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(0), HorizontalAnchor.fromLeft(4))).skullOwner(resident.getUUID()).lore(PlotMenu.formatPermissionTypes(player, data.getPermissionTypes())).build());
        Consumer<TownyPermission.ActionType> onClick = actionType -> {
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
            if (townBlock == null || !PlotMenu.testPlotOwner(player, townBlock)) {
                MenuHistory.reOpen(player, () -> PlotMenu.formatPlotPermissionOverrideMenu(player, worldCoord));
                return;
            }
            PermissionGUIUtil.SetPermissionType existing = data.getPermissionTypes()[actionType.getIndex()];
            PermissionGUIUtil.SetPermissionType[] setPermissionTypeArray = data.getPermissionTypes();
            int n = actionType.getIndex();
            setPermissionTypeArray[n] = switch (existing) {
                default -> throw new MatchException(null, null);
                case PermissionGUIUtil.SetPermissionType.SET -> PermissionGUIUtil.SetPermissionType.NEGATED;
                case PermissionGUIUtil.SetPermissionType.NEGATED -> PermissionGUIUtil.SetPermissionType.UNSET;
                case PermissionGUIUtil.SetPermissionType.UNSET -> PermissionGUIUtil.SetPermissionType.SET;
            };
            PlotGroup group = townBlock.getPlotObjectGroup();
            if (group != null) {
                group.putPermissionOverride(resident, data);
                group.save();
            } else {
                townBlock.save();
            }
            Towny.getPlugin().deleteCache(resident);
            MenuHistory.reOpen(player, () -> PlotMenu.openPermissionOverrideEditor(player, worldCoord, resident, data));
        };
        for (TownyPermission.ActionType type : TownyPermission.ActionType.values()) {
            MenuItem.Builder builder2 = MenuItem.builder(data.getPermissionTypes()[type.getIndex()].getWoolColour()).name(Component.text((String)type.getCommonName(), (TextColor)PlotMenu.colorFromType(data.getPermissionTypes()[type.getIndex()])).decorate(TextDecoration.BOLD));
            builder.addItem(builder2.slot(switch (type) {
                default -> throw new MatchException(null, null);
                case TownyPermission.ActionType.BUILD -> SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(3));
                case TownyPermission.ActionType.DESTROY -> SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromRight(3));
                case TownyPermission.ActionType.SWITCH -> SlotAnchor.anchor(VerticalAnchor.fromTop(3), HorizontalAnchor.fromLeft(3));
                case TownyPermission.ActionType.ITEM_USE -> SlotAnchor.anchor(VerticalAnchor.fromTop(3), HorizontalAnchor.fromRight(3));
            }).action(ClickAction.run(() -> onClick.accept(type))).build());
        }
        return builder.build();
    }

    private static MenuInventory formatPlotToggle(Player player, WorldCoord worldCoord) {
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
        boolean fireEnabled = townBlock != null && townBlock.getPermissions().fire;
        boolean explosionEnabled = townBlock != null && townBlock.getPermissions().explosion;
        boolean mobsEnabled = townBlock != null && townBlock.getPermissions().mobs;
        boolean pvpEnabled = townBlock != null && townBlock.getPermissions().pvp;
        return MenuInventory.builder().title(Translatable.of((String)"plot-menu-plot-toggle-title").component(Localization.localeOrDefault(player))).rows(4).addItem(MenuHelper.backButton().build()).addItem(PlotMenu.createTogglePropertyItem(player, worldCoord, Material.TNT, explosionEnabled, "explosion").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).build()).addItem(MenuItem.builder(explosionEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(1))).name((Component)Component.empty()).build()).addItem(PlotMenu.createTogglePropertyItem(player, worldCoord, Material.FLINT_AND_STEEL, fireEnabled, "fire").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).build()).addItem(MenuItem.builder(fireEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(2))).name((Component)Component.empty()).build()).addItem(PlotMenu.createTogglePropertyItem(player, worldCoord, Material.BAT_SPAWN_EGG, mobsEnabled, "mobs").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(3))).build()).addItem(MenuItem.builder(mobsEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(3))).name((Component)Component.empty()).build()).addItem(PlotMenu.createTogglePropertyItem(player, worldCoord, Material.WOODEN_AXE, pvpEnabled, "pvp").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).build()).addItem(MenuItem.builder(pvpEnabled ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(4))).name((Component)Component.empty()).build()).build();
    }

    private static MenuItem.Builder createTogglePropertyItem(Player player, WorldCoord worldCoord, Material material, boolean propertyEnabled, String property) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuItem.builder(material).name(Translatable.of((String)"plot-menu-toggle-title").append((Component)Component.text((String)(property.substring(0, 1).toUpperCase(Locale.ROOT) + property.substring(1)))).component(locale).color((TextColor)(propertyEnabled ? NamedTextColor.GREEN : NamedTextColor.RED))).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(property)) || !PlotMenu.testPlotOwner(player, worldCoord)) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"plot-menu-toggle")).append(property + ".").component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(propertyEnabled ? Translatable.of((String)"plot-menu-toggle-disable") : Translatable.of((String)"plot-menu-toggle-enable")).append(" " + property + ".").component(locale);
        }).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_PLOT_TOGGLE.getNode(property)) ? ClickAction.NONE : ClickAction.confirmation((Component)Component.text((String)("Are you sure you want to toggle " + property + " in this plot?"), (TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(worldCoord);
            if (townBlock == null) {
                return;
            }
            PlotMenu.plotCommand().ifPresent(command -> {
                Resident resident = TownyAPI.getInstance().getResident(player);
                if (resident == null) {
                    return;
                }
                try {
                    command.plotToggle(player, resident, townBlock, new String[]{property});
                }
                catch (TownyException e) {
                    TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
                }
            });
            MenuHistory.reOpen(player, () -> PlotMenu.formatPlotToggle(player, worldCoord));
        })));
    }

    private static Optional<PlotCommand> plotCommand() {
        CommandExecutor commandExecutor;
        PluginCommand command = Towny.getPlugin().getCommand("plot");
        if (command == null || !((commandExecutor = command.getExecutor()) instanceof PlotCommand)) {
            return Optional.empty();
        }
        PlotCommand plotCommand = (PlotCommand)commandExecutor;
        return Optional.of(plotCommand);
    }

    private static boolean testPlotOwner(Player player, WorldCoord worldCoord) {
        return PlotMenu.testPlotOwner(player, TownyAPI.getInstance().getTownBlock(worldCoord));
    }

    private static boolean testPlotOwner(Player player, TownBlock townBlock) {
        Resident resident = TownyAPI.getInstance().getResident(player);
        if (resident == null || townBlock == null) {
            return false;
        }
        try {
            TownyAPI.getInstance().testPlotOwnerOrThrow(resident, townBlock);
            return true;
        }
        catch (TownyException e) {
            return false;
        }
    }
}

