/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.menu;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.command.NationCommand;
import com.palmergames.bukkit.towny.event.nation.NationRankAddEvent;
import com.palmergames.bukkit.towny.event.nation.NationRankRemoveEvent;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.Translatable;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import io.github.townyadvanced.townymenus.gui.MenuHelper;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.SlotAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;
import io.github.townyadvanced.townymenus.listeners.AwaitingConfirmation;
import io.github.townyadvanced.townymenus.menu.ResidentMenu;
import io.github.townyadvanced.townymenus.menu.TownMenu;
import io.github.townyadvanced.townymenus.menu.helper.GovernmentMenus;
import io.github.townyadvanced.townymenus.utils.Localization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;

public class NationMenu {
    public static MenuInventory createNationMenu(@NotNull Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Nation nation = TownyAPI.getInstance().getNation(player);
        return MenuInventory.builder().title(Translatable.of((String)"nation-menu-title").component(locale)).rows(6).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.EMERALD_BLOCK).name(Translatable.of((String)"nation-menu-bank-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(1), HorizontalAnchor.fromLeft(3))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-err-not-part-of-nation").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-view-bank")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null ? ClickAction.NONE : ClickAction.openInventory(() -> NationMenu.formatNationBankMenu(player))).build()).addItem(MenuItem.builder(Material.RED_BED).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).name(Translatable.of((String)"nation-menu-nation-spawn").component(locale)).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-err-not-part-of-nation").component(locale);
            }
            if (!player.hasPermission("towny.nation.spawn.nation")) {
                return Translatable.of((String)"msg-no-permission").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-teleport-to-spawn")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null || !player.hasPermission("towny.nation.spawn.nation") ? ClickAction.NONE : ClickAction.confirmation(() -> Translatable.of((String)"nation-menu-teleport-confirm").component(locale), (ClickAction)ClickAction.run(() -> {
            if (!player.hasPermission("towny.nation.spawn.nation")) {
                return;
            }
            try {
                NationCommand.nationSpawn((Player)player, (String[])new String[0], (boolean)false);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
            player.closeInventory();
        }))).build()).addItem(MenuItem.builder(Material.LEVER).name(Translatable.of((String)"nation-menu-toggle-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(1))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-must-be-in-nation-to").append(Translatable.of((String)"nation-menu-toggle-open")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-toggle-open")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null ? ClickAction.NONE : ClickAction.openInventory(() -> NationMenu.formatNationToggleMenu(player))).build()).addItem(MenuItem.builder(Material.GRASS_BLOCK).name(Translatable.of((String)"nation-menu-set-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(1), HorizontalAnchor.fromRight(3))).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-set-open")).component(locale).color((TextColor)NamedTextColor.GRAY)).action(ClickAction.openInventory(() -> NationMenu.formatNationSetMenu(player))).build()).addItem(MenuItem.builder(Material.ENDER_EYE).name(Translatable.of((String)"nation-menu-online").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(2), HorizontalAnchor.fromLeft(1))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-err-not-part-of-nation").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-view-online")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-view-online")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode()) ? ClickAction.NONE : ClickAction.openInventory(() -> {
            Nation playerNation = TownyAPI.getInstance().getNation(player);
            if (playerNation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_ONLINE.getNode())) {
                return MenuInventory.paginator().title(Translatable.of((String)"nation-menu-online").component(locale)).build();
            }
            ArrayList<MenuItem> online = new ArrayList<MenuItem>();
            for (Player onlinePlayer : TownyAPI.getInstance().getOnlinePlayers((ResidentList)playerNation)) {
                if (!player.canSee(onlinePlayer)) continue;
                online.add(ResidentMenu.formatResidentInfo(onlinePlayer.getUniqueId(), player).build());
            }
            return MenuInventory.paginator().title(Translatable.of((String)"nation-menu-online").component(locale)).addItems(online).build();
        })).build()).addItem(MenuItem.builder(Material.PLAYER_HEAD).name(Translatable.of((String)"nation-menu-resident-overview-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(2), HorizontalAnchor.fromRight(1))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-err-not-part-of-nation").component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-view-manage-resident")).component(locale);
        }).action(nation == null ? ClickAction.NONE : ClickAction.openInventory(() -> NationMenu.createResidentOverview(player))).build()).build();
    }

    public static MenuInventory formatNationToggleMenu(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Nation nation = TownyAPI.getInstance().getNation(player);
        boolean isPublic = nation != null && nation.isPublic();
        boolean isOpen = nation != null && nation.isOpen();
        return MenuInventory.builder().rows(4).title(Translatable.of((String)"nation-menu-toggle-title").component(locale)).addItem(MenuHelper.backButton().build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)nation, Material.GRASS_BLOCK, isOpen, "open").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(1))).build()).addItem(MenuItem.builder(isOpen ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(1))).name((Component)Component.empty()).build()).addItem(GovernmentMenus.createTogglePropertyItem(player, (Government)nation, Material.GRASS_BLOCK, isPublic, "public").slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).build()).addItem(MenuItem.builder(isPublic ? Material.GREEN_CONCRETE : Material.RED_CONCRETE).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(2))).name((Component)Component.empty()).build()).build();
    }

    public static MenuInventory formatNationSetMenu(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Nation nation = TownyAPI.getInstance().getNation(player);
        return MenuInventory.builder().title(Translatable.of((String)"nation-menu-set-title").component(locale)).rows(3).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"nation-menu-set-change-name-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-must-be-in-nation-to").append(Translatable.of((String)"nation-menu-set-change-name")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-set-change-name")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-set-change-name")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode()) ? ClickAction.NONE : ClickAction.userInput("Enter new nation name", snapshot -> {
            Nation playerNation = TownyAPI.getInstance().getNation(player);
            if (playerNation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_NAME.getNode())) {
                return InputResponse.finish();
            }
            AwaitingConfirmation.await(player);
            try {
                NationCommand.nationSet((CommandSender)player, (String[])("name " + snapshot.getText()).split(" "), (boolean)false, (Nation)playerNation);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.reOpen(() -> NationMenu.formatNationSetMenu(player));
        })).build()).addItem(MenuItem.builder(Material.OAK_SIGN).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).name(Translatable.of((String)"nation-menu-set-change-board-title").component(locale)).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-must-be-in-nation-to").append(Translatable.of((String)"nation-menu-set-change-board")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_BOARD.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-set-change-board")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-set-change-board")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_BOARD.getNode()) ? ClickAction.NONE : ClickAction.userInput("Enter nation board", board -> {
            Nation playerNation = TownyAPI.getInstance().getNation(player);
            if (playerNation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_BOARD.getNode())) {
                return InputResponse.finish();
            }
            try {
                NationCommand.nationSet((CommandSender)player, (String[])("board " + board.getText()).split(" "), (boolean)false, (Nation)playerNation);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.reOpen(() -> NationMenu.formatNationSetMenu(player));
        })).build()).addItem(MenuItem.builder(Material.RED_BED).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).name(Translatable.of((String)"nation-menu-set-change-spawn-title").component(locale)).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-must-be-in-nation-to").append(Translatable.of((String)"nation-menu-set-change-spawn")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWN.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-set-change-spawn")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-set-change-spawn")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWN.getNode()) ? ClickAction.NONE : ClickAction.run(() -> {
            Nation playerNation = TownyAPI.getInstance().getNation(player);
            if (playerNation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_SPAWN.getNode())) {
                return;
            }
            try {
                NationCommand.nationSet((CommandSender)player, (String[])new String[]{"spawn"}, (boolean)false, (Nation)playerNation);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        })).build()).build();
    }

    public static MenuInventory createResidentOverview(Player player) {
        Locale locale = Localization.localeOrDefault(player);
        Nation nation = TownyAPI.getInstance().getNation(player);
        if (nation == null) {
            return MenuInventory.paginator().title(Translatable.of((String)"nation-menu-resident-overview-title").component(locale)).build();
        }
        MenuInventory.PaginatorBuilder builder = MenuInventory.paginator().title(Translatable.of((String)"nation-menu-resident-overview-title").append(" - " + nation.getName()).component(locale));
        for (Resident resident : nation.getResidents()) {
            builder.addItem(ResidentMenu.formatResidentInfo(resident, player).lore((Component)Component.text((String)" ")).lore(Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"nation-menu-view-resident-options")).component(locale).color((TextColor)NamedTextColor.GRAY)).action(ClickAction.rightClick(ClickAction.openInventory(() -> NationMenu.createResidentManagementScreen(player, nation, resident)))).build());
        }
        return builder.build();
    }

    public static MenuInventory createResidentManagementScreen(Player player, Nation nation, Resident resident) {
        Locale locale = Localization.localeOrDefault(player);
        return MenuInventory.builder().title(Translatable.of((String)"nation-menu-resident-management").component(locale)).addItem(MenuHelper.backButton().build()).addItem(ResidentMenu.formatResidentInfo(resident, player).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(4))).build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"nation-menu-change-resident-title-title").component(locale).color((TextColor)NamedTextColor.GRAY)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-change-resident-title")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Arrays.asList(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-change-resident-title")).component(locale).color((TextColor)NamedTextColor.GRAY), Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"nation-menu-clear-resident-title")).component(locale).color((TextColor)NamedTextColor.GRAY));
        }).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode()) ? ClickAction.NONE : ClickAction.leftClick(ClickAction.userInput(Translatable.of((String)"nation-menu-enter-title").translate(locale), completion -> {
            Nation playerNation = TownyAPI.getInstance().getNation(player);
            if (playerNation == null || playerNation != resident.getNationOrNull()) {
                return InputResponse.finish();
            }
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode());
                NationCommand.nationSet((CommandSender)player, (String[])new String[]{"title", resident.getName(), completion.getText()}, (boolean)false, (Nation)nation);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.openPreviousMenu();
        }))).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode()) ? ClickAction.NONE : ClickAction.rightClick(ClickAction.run(() -> {
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_NATION_SET_TITLE.getNode());
                NationCommand.nationSet((CommandSender)player, (String[])new String[]{"title", resident.getName(), ""}, (boolean)false, (Nation)nation);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        }))).build()).addItem(MenuItem.builder(Material.NAME_TAG).name(Translatable.of((String)"nation-menu-change-resident-surname-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(2), HorizontalAnchor.fromRight(2))).lore(() -> {
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-change-resident-surname")).component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Arrays.asList(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-change-resident-surname")).component(locale).color((TextColor)NamedTextColor.GRAY), Translatable.of((String)"msg-right-click-to").append(Translatable.of((String)"nation-menu-clear-resident-title")).component(locale).color((TextColor)NamedTextColor.GRAY));
        }).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode()) ? ClickAction.NONE : ClickAction.leftClick(ClickAction.userInput(Translatable.of((String)"nation-menu-enter-surname").translate(locale), completion -> {
            Nation playerNation = TownyAPI.getInstance().getNation(player);
            if (playerNation == null || playerNation != resident.getNationOrNull()) {
                return InputResponse.finish();
            }
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode());
                NationCommand.nationSet((CommandSender)player, (String[])new String[]{"surname", resident.getName(), completion.getText()}, (boolean)false, (Nation)nation);
            }
            catch (TownyException e) {
                return InputResponse.errorMessage(e.getMessage((CommandSender)player));
            }
            return InputResponse.openPreviousMenu();
        }))).action(!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode()) ? ClickAction.NONE : ClickAction.rightClick(ClickAction.run(() -> {
            try {
                BaseCommand.checkPermOrThrow((Permissible)player, (String)PermissionNodes.TOWNY_COMMAND_NATION_SET_SURNAME.getNode());
                NationCommand.nationSet((CommandSender)player, (String[])new String[]{"surname", resident.getName(), ""}, (boolean)false, (Nation)nation);
            }
            catch (TownyException e) {
                TownyMessaging.sendErrorMsg((Object)player, (String)e.getMessage((CommandSender)player));
            }
        }))).build()).addItem(MenuItem.builder(Material.KNOWLEDGE_BOOK).name(Translatable.of((String)"nation-menu-manage-ranks-title").component(locale)).lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-manage-ranks")).component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(2), HorizontalAnchor.fromLeft(4))).action(ClickAction.openInventory(() -> NationMenu.formatRankManagementMenu(player, nation, resident))).build()).build();
    }

    public static MenuInventory formatRankManagementMenu(Player player, Nation nation, Resident resident) {
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.PaginatorBuilder paginator = MenuInventory.paginator().title(Translatable.of((String)"nation-menu-manage-ranks-title").component(locale));
        for (String nationRank : TownyPerms.getNationRanks()) {
            MenuItem.Builder item = MenuItem.builder(Material.KNOWLEDGE_BOOK).name((Component)Component.text((String)(nationRank.substring(0, 1).toUpperCase(Locale.ROOT) + nationRank.substring(1)), (TextColor)NamedTextColor.GREEN));
            boolean hasPermission = player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(nationRank.toLowerCase(Locale.ROOT)));
            if (resident.hasNationRank(nationRank)) {
                item.withGlint();
                if (hasPermission) {
                    item.lore(Translatable.of((String)"msg-click-to").append(Translatable.of((String)"rank-remove")).append(nationRank).append(Translatable.of((String)"rank-from")).append(resident.getName()).append((Component)Component.text((String)".")).component(locale).color((TextColor)NamedTextColor.GRAY));
                    item.action(ClickAction.confirmation(Translatable.of((String)"rank-remove-confirmation").append(nationRank).append(Translatable.of((String)"from").append(resident.getName()).append("?")).component(locale).color((TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
                        if (!resident.hasNationRank(nationRank) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(nationRank.toLowerCase(Locale.ROOT)))) {
                            MenuHistory.reOpen(player, () -> NationMenu.formatRankManagementMenu(player, nation, resident));
                            return;
                        }
                        Resident playerResident = TownyAPI.getInstance().getResident(player);
                        if (nation == null || resident.getNationOrNull() != nation || playerResident == null || playerResident.getNationOrNull() != nation) {
                            return;
                        }
                        NationRankRemoveEvent event = new NationRankRemoveEvent(nation, nationRank, resident);
                        Bukkit.getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            TownyMessaging.sendErrorMsg((Object)player, (String)event.getCancelMessage());
                            MenuHistory.reOpen(player, () -> NationMenu.formatRankManagementMenu(player, nation, resident));
                            return;
                        }
                        resident.removeNationRank(nationRank);
                        if (resident.isOnline()) {
                            TownyMessaging.sendMsg((Resident)resident, (Translatable)Translatable.of((String)"msg_you_have_had_rank_taken", (Object[])new Object[]{Translatable.of((String)"nation_sing"), nationRank}));
                            Towny.getPlugin().deleteCache(resident);
                        }
                        TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_you_have_taken_rank_from", (Object[])new Object[]{Translatable.of((String)"nation_sing"), nationRank, resident.getName()}));
                        MenuHistory.reOpen(player, () -> NationMenu.formatRankManagementMenu(player, nation, resident));
                    })));
                }
            } else if (hasPermission) {
                item.lore(Translatable.of((String)"msg-click-to-grant-the").append(nationRank).append(Translatable.of((String)"rank-to")).append(resident.getName()).append(".").component(locale).color((TextColor)NamedTextColor.GRAY));
                item.action(ClickAction.confirmation(Translatable.of((String)"rank-give-confirmation").append(nationRank).append(Translatable.of((String)"to").append(resident.getName()).append("?")).component(locale).color((TextColor)NamedTextColor.GRAY), (ClickAction)ClickAction.run(() -> {
                    if (resident.hasNationRank(nationRank) || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(nationRank.toLowerCase(Locale.ROOT)))) {
                        MenuHistory.reOpen(player, () -> NationMenu.formatRankManagementMenu(player, nation, resident));
                        return;
                    }
                    Resident playerResident = TownyAPI.getInstance().getResident(player);
                    if (nation == null || resident.getNationOrNull() != nation || playerResident == null || playerResident.getNationOrNull() != nation) {
                        return;
                    }
                    NationRankAddEvent event = new NationRankAddEvent(nation, nationRank, resident);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        TownyMessaging.sendErrorMsg((Object)player, (String)event.getCancelMessage());
                        MenuHistory.reOpen(player, () -> NationMenu.formatRankManagementMenu(player, nation, resident));
                        return;
                    }
                    resident.addNationRank(nationRank);
                    if (resident.isOnline()) {
                        TownyMessaging.sendMsg((Resident)resident, (Translatable)Translatable.of((String)"msg_you_have_been_given_rank", (Object[])new Object[]{Translatable.of((String)"nation_sing"), nationRank}));
                        Towny.getPlugin().deleteCache(resident);
                    }
                    TownyMessaging.sendMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_you_have_given_rank", (Object[])new Object[]{Translatable.of((String)"nation_sing"), nationRank, resident.getName()}));
                    MenuHistory.reOpen(player, () -> NationMenu.formatRankManagementMenu(player, nation, resident));
                })));
            }
            paginator.addItem(item.build());
        }
        return paginator.build();
    }

    public static MenuInventory formatNationBankMenu(Player player) {
        Nation nation = TownyAPI.getInstance().getNation(player);
        Locale locale = Localization.localeOrDefault(player);
        MenuInventory.Builder builder = MenuInventory.builder().title(Translatable.of((String)"nation-menu-bank-title").component(locale)).rows(3).addItem(MenuHelper.backButton().build()).addItem(MenuItem.builder(Material.EMERALD_BLOCK).name(Translatable.of((String)"nation-menu-bank-deposit-or-withdraw-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromLeft(2))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-err-not-part-of-nation").component(locale);
            }
            if (!TownyEconomyHandler.isActive()) {
                return Translatable.of((String)"msg_err_no_economy").component(locale).color((TextColor)NamedTextColor.GRAY);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-bank-deposit-or-withdraw")).component(locale).color((TextColor)NamedTextColor.GRAY);
        }).action(nation == null || !TownyEconomyHandler.isActive() ? ClickAction.NONE : ClickAction.openInventory(() -> GovernmentMenus.createDepositWithdrawMenu(player, (Government)nation))).build()).addItem(MenuItem.builder(Material.WRITABLE_BOOK).name(Translatable.of((String)"nation-menu-bank-transaction-history-title").component(locale)).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(1), HorizontalAnchor.fromRight(2))).lore(() -> {
            if (nation == null) {
                return Translatable.of((String)"msg-err-not-part-of-nation").component(locale);
            }
            if (!player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_BANKHISTORY.getNode())) {
                return Translatable.of((String)"msg-no-permission-to").append(Translatable.of((String)"nation-menu-bank-transaction-history")).component(locale);
            }
            return Translatable.of((String)"msg-click-to").append(Translatable.of((String)"nation-menu-bank-transaction-history")).component(locale);
        }).action(nation == null || !player.hasPermission(PermissionNodes.TOWNY_COMMAND_NATION_BANKHISTORY.getNode()) ? ClickAction.NONE : ClickAction.openInventory(() -> TownMenu.createBankHistoryMenu(player, (Government)nation))).build());
        if (nation != null && TownyEconomyHandler.isActive()) {
            builder.addItem(TownMenu.formatBankStatus(player, (Account)nation.getAccount(), false).slot(SlotAnchor.anchor(VerticalAnchor.fromTop(0), HorizontalAnchor.fromLeft(4))).build());
        }
        return builder.build();
    }
}

