/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.listeners;

import io.github.townyadvanced.townymenus.TownyMenus;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import java.util.List;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class InventoryListener
implements Listener {
    private final TownyMenus plugin;

    public InventoryListener(TownyMenus plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof MenuInventory)) {
            return;
        }
        MenuInventory menu = (MenuInventory)inventoryHolder;
        event.setCancelled(true);
        List<ClickAction> actions = menu.actions(event.getSlot());
        if (actions != null) {
            actions.forEach(action -> action.onClick(menu, event));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getView().getTopInventory().getHolder(false) instanceof MenuInventory)) {
            return;
        }
        for (ItemStack item : event.getView().getBottomInventory()) {
            ItemMeta meta;
            if (item == null || (meta = item.getItemMeta()) == null || !meta.getPersistentDataContainer().has(MenuItem.PDC_KEY, PersistentDataType.BYTE)) continue;
            item.setAmount(0);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onItemDrop(PlayerDropItemEvent event) {
        ItemMeta meta = event.getItemDrop().getItemStack().getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(MenuItem.PDC_KEY, PersistentDataType.BYTE)) {
            event.getItemDrop().remove();
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder(false);
        if (!(inventoryHolder instanceof MenuInventory)) {
            return;
        }
        MenuInventory menu = (MenuInventory)inventoryHolder;
        event.setCancelled(true);
    }
}

