/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui.slot.anchor;

import io.github.townyadvanced.townymenus.gui.slot.Slot;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;

public class SlotAnchor
implements Slot {
    private final VerticalAnchor verticalAnchor;
    private final HorizontalAnchor horizontalAnchor;

    public SlotAnchor(VerticalAnchor verticalAnchor, HorizontalAnchor horizontalAnchor) {
        this.verticalAnchor = verticalAnchor;
        this.horizontalAnchor = horizontalAnchor;
    }

    public static SlotAnchor anchor(VerticalAnchor verticalAnchor, HorizontalAnchor horizontalAnchor) {
        return new SlotAnchor(verticalAnchor, horizontalAnchor);
    }

    public static SlotAnchor ofSlot(int slot) {
        return SlotAnchor.anchor(VerticalAnchor.fromTop(slot / 9), HorizontalAnchor.fromLeft(slot % 9));
    }

    public static SlotAnchor bottomRight() {
        return SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromRight(0));
    }

    @Override
    public int resolve(int inventorySize) {
        return this.verticalAnchor.resolveY(inventorySize) + this.horizontalAnchor.offset();
    }
}

