/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui.input.response;

import com.palmergames.bukkit.towny.utils.TownyComponents;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.input.response.ErrorMessage;
import io.github.townyadvanced.townymenus.gui.input.response.Finish;
import io.github.townyadvanced.townymenus.gui.input.response.Nothing;
import io.github.townyadvanced.townymenus.gui.input.response.OpenPreviousMenu;
import io.github.townyadvanced.townymenus.gui.input.response.ReOpen;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.ApiStatus;

public interface InputResponse {
    public static InputResponse reOpen(Supplier<MenuInventory> supplier) {
        return new ReOpen(supplier);
    }

    @Deprecated
    @ApiStatus.Internal
    public static InputResponse errorMessage(String errorText) {
        return InputResponse.errorMessage(TownyComponents.miniMessage((String)errorText));
    }

    public static InputResponse errorMessage(Component error) {
        return new ErrorMessage(error.colorIfAbsent((TextColor)NamedTextColor.DARK_RED));
    }

    @Deprecated(since="0.0.14")
    public static InputResponse replaceText(String text) {
        return InputResponse.errorMessage(text);
    }

    public static InputResponse doNothing() {
        return Nothing.INSTANCE;
    }

    public static InputResponse finish() {
        return Finish.INSTANCE;
    }

    public static InputResponse openPreviousMenu() {
        return OpenPreviousMenu.INSTANCE;
    }
}

