/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui.input.impl.text;

import com.palmergames.bukkit.towny.object.Translatable;
import io.github.townyadvanced.townymenus.TownyMenus;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.input.PlayerInput;
import io.github.townyadvanced.townymenus.gui.input.UserInputBackend;
import io.github.townyadvanced.townymenus.gui.input.impl.text.TextInputSession;
import io.github.townyadvanced.townymenus.gui.input.response.ErrorMessage;
import io.github.townyadvanced.townymenus.gui.input.response.Finish;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.input.response.Nothing;
import io.github.townyadvanced.townymenus.gui.input.response.OpenPreviousMenu;
import io.github.townyadvanced.townymenus.gui.input.response.ReOpen;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class TextInputBackend
implements UserInputBackend,
Listener {
    private static final Duration INPUT_TIMEOUT = Duration.ofSeconds(60L);
    private static final Collection<String> CANCEL_PHRASES = Set.of("q", "quit", "cancel", "stop");
    private final TownyMenus plugin;
    private final Map<UUID, TextInputSession> sessions = new ConcurrentHashMap<UUID, TextInputSession>();

    public TextInputBackend(TownyMenus plugin) {
        this.plugin = plugin;
    }

    @Override
    public void startAwaitingInput(Player player, MenuInventory currentInventory, Component title, Function<PlayerInput, List<InputResponse>> inputFunction) {
        TextInputSession session = new TextInputSession(currentInventory, inputFunction);
        UUID uuid = player.getUniqueId();
        this.cancelSession(uuid);
        this.sessions.put(uuid, session);
        player.closeInventory();
        player.sendRichMessage(Translatable.of((String)"townymenus:plugin-prefix").append(Translatable.of((String)"chat-input-header")).forLocale((CommandSender)player));
        player.sendMessage(title);
        player.sendRichMessage(Translatable.of((String)"townymenus:plugin-prefix").append(Translatable.of((String)"chat-input-timeout-warning", (Object[])new Object[]{String.valueOf(INPUT_TIMEOUT.getSeconds())})).forLocale((CommandSender)player));
        session.timeoutTask(this.plugin.getServer().getAsyncScheduler().runDelayed((Plugin)this.plugin, task -> {
            this.cancelSession(uuid);
            Player p = this.plugin.getServer().getPlayer(uuid);
            if (p != null) {
                p.sendRichMessage(Translatable.of((String)"townymenus:plugin-prefix").append(Translatable.of((String)"chat-input-timed-out")).forLocale((CommandSender)p));
            }
        }, INPUT_TIMEOUT.getSeconds(), TimeUnit.SECONDS));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void listenForInput(AsyncChatEvent event) {
        Player player = event.getPlayer();
        TextInputSession session = this.sessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        event.setCancelled(true);
        String plain = PlainTextComponentSerializer.plainText().serialize(event.originalMessage());
        if (CANCEL_PHRASES.contains(plain)) {
            this.cancelSession(player.getUniqueId());
            player.sendRichMessage(Translatable.of((String)"townymenus:plugin-prefix").append(Translatable.of((String)"chat-input-cancelled")).forLocale((CommandSender)player));
            return;
        }
        List<InputResponse> responses = session.inputFunction().apply(new PlayerInput(plain));
        block7: for (InputResponse response : responses) {
            InputResponse inputResponse;
            Objects.requireNonNull(response);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Finish.class, Nothing.class, ReOpen.class, ErrorMessage.class, OpenPreviousMenu.class}, (Object)inputResponse, n)) {
                case 0: {
                    Finish finish = (Finish)inputResponse;
                    this.cancelSession(player.getUniqueId());
                    continue block7;
                }
                case 1: {
                    Nothing nothing = (Nothing)inputResponse;
                    continue block7;
                }
                case 2: {
                    ReOpen reOpen = (ReOpen)inputResponse;
                    MenuHistory.reOpen(player, reOpen.supplier());
                    this.cancelSession(player.getUniqueId());
                    continue block7;
                }
                case 3: {
                    ErrorMessage errorMessage = (ErrorMessage)inputResponse;
                    player.sendMessage(errorMessage.error());
                    continue block7;
                }
                case 4: {
                    OpenPreviousMenu ignored = (OpenPreviousMenu)inputResponse;
                    this.cancelSession(player.getUniqueId());
                    MenuHistory.last(player);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Unimplemented input response type " + String.valueOf(response.getClass()));
        }
    }

    @EventHandler
    public void invalidateSession(PlayerQuitEvent event) {
        this.cancelSession(event.getPlayer().getUniqueId());
    }

    private void cancelSession(UUID uuid) {
        TextInputSession session = this.sessions.remove(uuid);
        if (session != null && session.timeoutTask() != null) {
            session.timeoutTask().cancel();
        }
    }
}

