/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui.input.impl.anvil;

import io.github.townyadvanced.townymenus.TownyMenus;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.input.PlayerInput;
import io.github.townyadvanced.townymenus.gui.input.UserInputBackend;
import io.github.townyadvanced.townymenus.gui.input.response.ErrorMessage;
import io.github.townyadvanced.townymenus.gui.input.response.Finish;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import io.github.townyadvanced.townymenus.gui.input.response.Nothing;
import io.github.townyadvanced.townymenus.gui.input.response.OpenPreviousMenu;
import io.github.townyadvanced.townymenus.gui.input.response.ReOpen;
import io.github.townyadvanced.townymenus.libs.anvilgui.AnvilGUI;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AnvilInputBackend
implements UserInputBackend {
    private final TownyMenus plugin;

    public AnvilInputBackend(TownyMenus plugin) {
        this.plugin = plugin;
    }

    @Override
    public void startAwaitingInput(Player player, MenuInventory currentInventory, Component title, Function<PlayerInput, List<InputResponse>> inputFunction) {
        new AnvilGUI.Builder().jsonTitle((String)GsonComponentSerializer.gson().serialize(title)).onClose(snapshot -> this.plugin.getScheduler().run((Entity)snapshot.getPlayer(), () -> currentInventory.openSilent((HumanEntity)snapshot.getPlayer()))).onClick((slot, snapshot) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            return this.toAnvil((List)inputFunction.apply(new PlayerInput(snapshot.getText())));
        }).itemLeft(MenuItem.builder(Material.PAPER).name((Component)Component.empty()).build().itemStack()).plugin((Plugin)this.plugin).mainThreadExecutor(run -> player.getScheduler().run((Plugin)this.plugin, task -> run.run(), null)).open(player);
    }

    private List<AnvilGUI.ResponseAction> toAnvil(List<InputResponse> responses) {
        ArrayList<AnvilGUI.ResponseAction> anvilResponses = new ArrayList<AnvilGUI.ResponseAction>();
        for (InputResponse response : responses) {
            AnvilGUI.ResponseAction action;
            InputResponse inputResponse;
            Objects.requireNonNull(response);
            int n = 0;
            if ((action = (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Finish.class, Nothing.class, ReOpen.class, ErrorMessage.class, OpenPreviousMenu.class}, (Object)inputResponse, n)) {
                case 0 -> {
                    Finish ignored = (Finish)inputResponse;
                    yield AnvilGUI.ResponseAction.close();
                }
                case 1 -> {
                    Nothing ignored = (Nothing)inputResponse;
                    yield null;
                }
                case 2 -> {
                    ReOpen reOpen = (ReOpen)inputResponse;
                    yield (anvilGUI, player) -> MenuHistory.reOpen(player, reOpen.supplier());
                }
                case 3 -> {
                    ErrorMessage errorMessage = (ErrorMessage)inputResponse;
                    yield (anvilGUI, player) -> player.sendMessage(errorMessage.error());
                }
                case 4 -> {
                    OpenPreviousMenu ignored = (OpenPreviousMenu)inputResponse;
                    yield (anvilGUI, player) -> MenuHistory.last(player);
                }
                default -> throw new IllegalArgumentException("Unimplemented input response type " + String.valueOf(response.getClass()));
            })) == null) continue;
            anvilResponses.add(action);
        }
        return anvilResponses;
    }
}

