/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui.action;

import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.action.BackAction;
import io.github.townyadvanced.townymenus.gui.action.ClickTypeAction;
import io.github.townyadvanced.townymenus.gui.action.ConfirmationAction;
import io.github.townyadvanced.townymenus.gui.action.OpenInventoryAction;
import io.github.townyadvanced.townymenus.gui.action.RunnableAction;
import io.github.townyadvanced.townymenus.gui.action.SoundAction;
import io.github.townyadvanced.townymenus.gui.action.UserInputAction;
import io.github.townyadvanced.townymenus.gui.input.PlayerInput;
import io.github.townyadvanced.townymenus.gui.input.response.InputResponse;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public interface ClickAction {
    public static final ClickAction NONE = (inventory, event) -> {};
    public static final ClickAction CLOSE = (inventory, event) -> event.getWhoClicked().closeInventory();
    public static final BackAction BACK = new BackAction();

    public void onClick(MenuInventory var1, InventoryClickEvent var2);

    public static OpenInventoryAction openInventory(@NotNull Supplier<MenuInventory> supplier) {
        return new OpenInventoryAction(supplier, false);
    }

    public static OpenInventoryAction openSilent(@NotNull Supplier<MenuInventory> supplier) {
        return new OpenInventoryAction(supplier, true);
    }

    public static RunnableAction run(@NotNull Runnable runnable) {
        return new RunnableAction(runnable);
    }

    public static ClickAction close() {
        return CLOSE;
    }

    public static ConfirmationAction confirmation(@NotNull ClickAction confirmAction) {
        return new ConfirmationAction(confirmAction);
    }

    public static ConfirmationAction confirmation(@NotNull Supplier<Component> supplier, @NotNull ClickAction confirmAction) {
        return new ConfirmationAction(supplier, confirmAction);
    }

    public static ConfirmationAction confirmation(@NotNull Component component, @NotNull ClickAction confirmAction) {
        return new ConfirmationAction(component, confirmAction);
    }

    public static SoundAction sound(@NotNull Sound sound) {
        return new SoundAction(sound);
    }

    public static BackAction back() {
        return BACK;
    }

    public static ClickTypeAction rightClick(@NotNull ClickAction rightClickAction) {
        return new ClickTypeAction(ClickType.RIGHT, rightClickAction);
    }

    public static ClickTypeAction leftClick(@NotNull ClickAction rightClickAction) {
        return new ClickTypeAction(ClickType.LEFT, rightClickAction);
    }

    public static ClickTypeAction clickType(@NotNull ClickType type, @NotNull ClickAction rightClickAction) {
        return new ClickTypeAction(type, rightClickAction);
    }

    public static UserInputAction userInput(String title, Function<PlayerInput, InputResponse> inputFunction) {
        return new UserInputAction(title, completion -> Collections.singletonList((InputResponse)inputFunction.apply((PlayerInput)completion)));
    }
}

