/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui;

import com.palmergames.bukkit.towny.scheduling.TaskScheduler;
import io.github.townyadvanced.townymenus.TownyMenus;
import io.github.townyadvanced.townymenus.gui.MenuHelper;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuItem;
import io.github.townyadvanced.townymenus.gui.action.ClickAction;
import io.github.townyadvanced.townymenus.gui.slot.anchor.HorizontalAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.SlotAnchor;
import io.github.townyadvanced.townymenus.gui.slot.anchor.VerticalAnchor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuInventory
implements InventoryHolder,
Iterable<ItemStack>,
Supplier<MenuInventory> {
    private static final ItemStack backgroundGlass = MenuItem.builder(Material.GRAY_STAINED_GLASS_PANE).name((Component)Component.empty()).build().itemStack();
    private final Inventory inventory;
    private final int size;
    private final Map<Integer, List<ClickAction>> clickActions = new HashMap<Integer, List<ClickAction>>();

    public MenuInventory(@NotNull Inventory inventory, @NotNull Component title) {
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)inventory.getSize(), (String)PlainTextComponentSerializer.plainText().serialize(title));
        this.inventory.setContents(inventory.getContents());
        this.size = this.inventory.getSize();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public boolean hasActions(int slot) {
        return this.clickActions.containsKey(slot);
    }

    @Nullable
    public List<ClickAction> actions(int slot) {
        return this.clickActions.get(slot);
    }

    public void addAction(int slot, @NotNull ClickAction action) {
        this.clickActions.putIfAbsent(slot, new ArrayList());
        this.clickActions.get(slot).add(action);
    }

    public void addActions(Map<Integer, List<ClickAction>> actions) {
        if (!actions.isEmpty()) {
            this.clickActions.putAll(actions);
        }
    }

    public void addItem(@NotNull MenuItem item) {
        int slot = item.slot().resolve(this.size);
        if (slot > this.inventory.getSize() - 1) {
            return;
        }
        this.inventory.setItem(slot, item.itemStack());
        if (!item.actions().isEmpty()) {
            this.clickActions.put(slot, item.actions());
        }
    }

    public void open(@NotNull HumanEntity player) {
        this.openSilent(player);
        MenuHistory.addHistory(player.getUniqueId(), this);
    }

    public void openSilent(@NotNull HumanEntity player) {
        TaskScheduler scheduler = TownyMenus.getPlugin().getScheduler();
        if (!scheduler.isEntityThread((Entity)player)) {
            scheduler.run((Entity)player, () -> this.openSilent(player));
            return;
        }
        player.openInventory(this.inventory);
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        return this.inventory.iterator();
    }

    public int size() {
        return this.size;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PaginatorBuilder paginator() {
        return new PaginatorBuilder();
    }

    @Override
    @NotNull
    public MenuInventory get() {
        return this;
    }

    public static class Builder {
        private final List<MenuItem> items = new ArrayList<MenuItem>();
        private int size = 54;
        private Component title = Component.empty();

        private Builder() {
        }

        public Builder addItem(@NotNull MenuItem item) {
            this.items.add(item);
            return this;
        }

        public Builder size(int size) {
            this.size = MenuHelper.normalizeSize(size);
            return this;
        }

        public int size() {
            return this.size;
        }

        public Builder rows(int rows) {
            this.size = Math.min(rows, 6) * 9;
            return this;
        }

        public Builder title(@NotNull Component title) {
            this.title = title;
            return this;
        }

        public MenuInventory build() {
            Inventory inventory = Bukkit.createInventory(null, (int)this.size, (String)PlainTextComponentSerializer.plainText().serialize(this.title));
            HashMap<Integer, List<ClickAction>> actions = new HashMap<Integer, List<ClickAction>>();
            for (MenuItem item : this.items) {
                int slot = item.slot().resolve(this.size);
                if (slot > this.size - 1 || inventory.getItem(slot) != null) continue;
                inventory.setItem(slot, item.itemStack());
                if (item.actions().isEmpty()) continue;
                actions.put(slot, item.actions());
            }
            for (int i = 0; i < this.size; ++i) {
                if (inventory.getItem(i) != null) continue;
                inventory.setItem(i, backgroundGlass);
            }
            MenuInventory menuInventory = new MenuInventory(inventory, this.title);
            menuInventory.addActions(actions);
            return menuInventory;
        }
    }

    public static class PaginatorBuilder {
        private final List<MenuItem> items = new ArrayList<MenuItem>();
        private final List<MenuItem> extraItems = new ArrayList<MenuItem>(0);
        private Component title = Component.empty();
        private boolean showPageCount = true;

        public PaginatorBuilder addItem(MenuItem item) {
            this.items.add(item);
            return this;
        }

        public PaginatorBuilder addItems(Collection<MenuItem> items) {
            this.items.addAll(items);
            return this;
        }

        public PaginatorBuilder addExtraItem(MenuItem extraItem) {
            this.extraItems.add(extraItem);
            return this;
        }

        public PaginatorBuilder title(Component title) {
            this.title = title;
            return this;
        }

        public PaginatorBuilder showPageCount() {
            this.showPageCount = true;
            return this;
        }

        public PaginatorBuilder showPageCount(boolean showPageCount) {
            this.showPageCount = showPageCount;
            return this;
        }

        public PaginatorBuilder hidePageCount() {
            this.showPageCount = false;
            return this;
        }

        public MenuInventory build() {
            int i;
            if (this.items.isEmpty()) {
                this.items.add(MenuItem.builder(Material.BARRIER).name((Component)Component.text((String)"No entries to list.", (TextColor)NamedTextColor.RED)).build());
            }
            int pageCount = (int)Math.ceil((double)this.items.size() / 45.0);
            MenuInventory[] inventories = new MenuInventory[pageCount];
            for (i = 0; i < pageCount; ++i) {
                List<MenuItem> pageItems = this.items.subList(i * 45, Math.min((i + 1) * 45, this.items.size()));
                Builder builder = MenuInventory.builder().size(pageItems.size() + 9).title(this.title.append((Component)(this.showPageCount ? Component.text((String)(" (Page " + (i + 1) + "/" + pageCount + ")")) : Component.empty())));
                for (int j = 0; j < pageItems.size(); ++j) {
                    MenuItem item = pageItems.get(j);
                    item.slot(j);
                    builder.addItem(item);
                }
                for (MenuItem extraItem : this.extraItems) {
                    builder.addItem(extraItem);
                }
                if (i != 0) {
                    builder.addItem(MenuItem.builder(Material.ARROW).name((Component)Component.text((String)"Back", (TextColor)NamedTextColor.GREEN, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD})).lore((Component)Component.text((String)"Click to go back to the previous page.", (TextColor)NamedTextColor.GOLD)).action(ClickAction.sound(Sound.sound((Key)Key.key((String)"minecraft", (String)"block.stone_button.click_on"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f))).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromLeft(0))).build());
                }
                builder.addItem(MenuHelper.backButton().slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromRight(4))).build());
                if (i + 1 != pageCount) {
                    builder.addItem(MenuItem.builder(Material.ARROW).name(Component.text((String)"Next", (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.BOLD)).lore((Component)Component.text((String)"Click to go to the next page.", (TextColor)NamedTextColor.GOLD)).action(ClickAction.sound(Sound.sound((Key)Key.key((String)"minecraft", (String)"block.stone_button.click_on"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.0f))).slot(SlotAnchor.anchor(VerticalAnchor.fromBottom(0), HorizontalAnchor.fromRight(0))).build());
                }
                inventories[i] = builder.build();
            }
            if (pageCount > 1) {
                for (i = 0; i < inventories.length; ++i) {
                    MenuInventory menuInventory = inventories[i];
                    if (i != 0) {
                        menuInventory.addAction(menuInventory.size() - 9, ClickAction.openSilent(inventories[i - 1]));
                    }
                    if (i + 1 == inventories.length) continue;
                    menuInventory.addAction(menuInventory.size() - 1, ClickAction.openSilent(inventories[i + 1]));
                }
            }
            return inventories[0];
        }
    }
}

