/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.gui;

import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.utils.MenuScheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class MenuHistory {
    private static final Map<UUID, List<MenuInventory>> historyMap = new ConcurrentHashMap<UUID, List<MenuInventory>>();

    @Nullable
    public static List<MenuInventory> getHistory(UUID uuid) {
        return historyMap.get(uuid);
    }

    public static void clearHistory(UUID uuid) {
        historyMap.remove(uuid);
    }

    public static void addHistory(UUID uuid, MenuInventory menuInventory) {
        historyMap.computeIfAbsent(uuid, k -> new ArrayList()).add(menuInventory);
    }

    public static void back(Player player) {
        List<MenuInventory> history = historyMap.get(player.getUniqueId());
        if (history == null || history.size() < 2) {
            return;
        }
        history.remove(history.size() - 1);
        history.get(history.size() - 1).openSilent((HumanEntity)player);
    }

    public static void last(Player player) {
        List<MenuInventory> history = historyMap.get(player.getUniqueId());
        if (history == null || history.isEmpty()) {
            return;
        }
        history.get(history.size() - 1).openSilent((HumanEntity)player);
    }

    public static void pop(UUID uuid) {
        List<MenuInventory> history = historyMap.get(uuid);
        if (history == null || history.isEmpty()) {
            return;
        }
        history.remove(history.size() - 1);
    }

    public static void reOpen(Player player, Supplier<MenuInventory> supplier) {
        MenuScheduler.scheduleAsync(player.getUniqueId(), () -> {
            MenuHistory.pop(player.getUniqueId());
            ((MenuInventory)supplier.get()).open((HumanEntity)player);
        });
    }
}

