/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus.commands;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.object.Translatable;
import io.github.townyadvanced.townymenus.commands.TownyMenuCommand;
import io.github.townyadvanced.townymenus.gui.MenuHistory;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.utils.MenuScheduler;
import java.util.function.Function;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MenuExtensionCommand
implements CommandExecutor {
    private final Function<Player, MenuInventory> menuInventoryFunction;

    public MenuExtensionCommand(Function<Player, MenuInventory> menuInventoryFunction) {
        this.menuInventoryFunction = menuInventoryFunction;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            TownyMessaging.sendErrorMsg((Object)sender, (String)"This command cannot be used by console!");
            return true;
        }
        Player player = (Player)sender;
        if (Towny.getPlugin().isError()) {
            TownyMessaging.sendErrorMsg((Object)player, (String)"You cannot use this command while Towny is locked in safe mode.");
            return true;
        }
        if (!player.hasPermission("townymenus.command.townymenu")) {
            TownyMessaging.sendErrorMsg((CommandSender)player, (Translatable)Translatable.of((String)"msg_err_command_disable"));
            return true;
        }
        MenuScheduler.scheduleAsync(player.getUniqueId(), () -> {
            MenuHistory.clearHistory(player.getUniqueId());
            MenuHistory.addHistory(player.getUniqueId(), TownyMenuCommand.createRootMenu(player));
            this.menuInventoryFunction.apply(player).open((HumanEntity)player);
        });
        return true;
    }
}

