/*
 * Decompiled with CFR 0.152.
 */
package io.github.townyadvanced.townymenus;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyCommandAddonAPI;
import com.palmergames.bukkit.towny.event.TranslationLoadEvent;
import com.palmergames.bukkit.towny.object.TranslationLoader;
import com.palmergames.bukkit.towny.scheduling.TaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.FoliaTaskScheduler;
import com.palmergames.bukkit.towny.scheduling.impl.PaperTaskScheduler;
import com.palmergames.bukkit.util.Version;
import io.github.townyadvanced.townymenus.commands.MenuExtensionCommand;
import io.github.townyadvanced.townymenus.commands.TownyMenuCommand;
import io.github.townyadvanced.townymenus.gui.MenuInventory;
import io.github.townyadvanced.townymenus.gui.input.UserInputBackend;
import io.github.townyadvanced.townymenus.listeners.AwaitingConfirmation;
import io.github.townyadvanced.townymenus.listeners.InventoryListener;
import io.github.townyadvanced.townymenus.listeners.PlayerListener;
import io.github.townyadvanced.townymenus.menu.NationMenu;
import io.github.townyadvanced.townymenus.menu.PlotMenu;
import io.github.townyadvanced.townymenus.menu.ResidentMenu;
import io.github.townyadvanced.townymenus.menu.TownMenu;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TownyMenus
extends JavaPlugin
implements Listener {
    private static final Version requiredTownyVersion = Version.fromString((String)"0.101.2.5");
    private static TownyMenus plugin;
    private final TaskScheduler scheduler;
    private UserInputBackend userInputBackend;

    public TownyMenus() {
        plugin = this;
        this.scheduler = TownyMenus.isFoliaClassPresent() ? new FoliaTaskScheduler((Plugin)this) : new PaperTaskScheduler((Plugin)this);
    }

    public void onEnable() {
        if (!this.townyVersionCheck()) {
            this.getLogger().severe("Towny version does not meet required minimum version: " + String.valueOf(requiredTownyVersion));
            this.getLogger().severe("Download the latest version here: https://github.com/TownyAdvanced/Towny/releases");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.userInputBackend = UserInputBackend.selectBackend(this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AwaitingConfirmation(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        UserInputBackend userInputBackend = this.userInputBackend;
        if (userInputBackend instanceof Listener) {
            Listener listener = (Listener)userInputBackend;
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
        TownyMenuCommand townyMenuCommand = new TownyMenuCommand(this);
        this.getCommand("townymenu").setExecutor((CommandExecutor)townyMenuCommand);
        TownyCommandAddonAPI.addSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.TOWNY, (String)"menu", (CommandExecutor)townyMenuCommand);
        TownyCommandAddonAPI.addSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.NATION, (String)"menu", (CommandExecutor)new MenuExtensionCommand(NationMenu::createNationMenu));
        TownyCommandAddonAPI.addSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.PLOT, (String)"menu", (CommandExecutor)new MenuExtensionCommand(PlotMenu::createPlotMenu));
        TownyCommandAddonAPI.addSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.RESIDENT, (String)"menu", (CommandExecutor)new MenuExtensionCommand(ResidentMenu::createResidentMenu));
        TownyCommandAddonAPI.addSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.TOWN, (String)"menu", (CommandExecutor)new MenuExtensionCommand(TownMenu::createTownMenu));
        TownyAPI.getInstance().addTranslations((Plugin)this, this.loadTranslations().getTranslations());
    }

    public void onDisable() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (!(player.getOpenInventory().getTopInventory().getHolder(false) instanceof MenuInventory)) continue;
            player.closeInventory();
        }
        TownyCommandAddonAPI.removeSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.NATION, (String)"menu");
        TownyCommandAddonAPI.removeSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.PLOT, (String)"menu");
        TownyCommandAddonAPI.removeSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.RESIDENT, (String)"menu");
        TownyCommandAddonAPI.removeSubCommand((TownyCommandAddonAPI.CommandType)TownyCommandAddonAPI.CommandType.TOWN, (String)"menu");
    }

    public static TownyMenus getPlugin() {
        return plugin;
    }

    public static Logger logger() {
        return plugin.getLogger();
    }

    public String getVersion() {
        return this.getDescription().getVersion();
    }

    private boolean townyVersionCheck() {
        return Version.fromString((String)Towny.getPlugin().getVersion()).compareTo(requiredTownyVersion) >= 0;
    }

    public TaskScheduler getScheduler() {
        return this.scheduler;
    }

    public UserInputBackend getUserInputBackend() {
        return this.userInputBackend;
    }

    private static boolean isFoliaClassPresent() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private TranslationLoader loadTranslations() {
        TranslationLoader loader = new TranslationLoader(this.getDataFolder().toPath().resolve("lang"), (Plugin)this, TownyMenus.class);
        loader.load();
        return loader;
    }

    @EventHandler
    public void onTranslationLoad(TranslationLoadEvent event) {
        event.getAddedTranslations().putAll(this.loadTranslations().getTranslations());
    }
}

