/*
 * Decompiled with CFR 0.152.
 */
package vxrp.me.itemcustomizer.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ItemBuilder {
    private static final List<ItemBuilder> ITEM_BUILDER_LIST = new LinkedList<ItemBuilder>();
    private final ItemStack item;
    private final ItemMeta meta;
    private final Damageable damageable;
    private final List<Component> lore = new ArrayList<Component>();
    private final Set<ItemFlag> flags = new HashSet<ItemFlag>();
    private final Map<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
    private Material material;
    private Component displayName;
    private int amount;
    private short durability;
    private boolean unbreakable;
    private boolean save = false;

    public ItemBuilder(ItemStack item) {
        this.item = new ItemStack(item);
        this.material = item.getType();
        this.amount = item.getAmount();
        this.enchantments.putAll(item.getEnchantments());
        this.meta = item.getItemMeta();
        this.damageable = (Damageable)this.meta;
        if (item.hasItemMeta()) {
            if (this.meta.hasDisplayName()) {
                this.displayName = this.meta.displayName();
            }
            if (this.meta.hasLore()) {
                this.lore.addAll(Objects.requireNonNull(this.meta.lore()));
            }
            this.flags.addAll(this.meta.getItemFlags());
            this.durability = (short)((Damageable)this.meta).getDamage();
        }
    }

    public ItemBuilder(Material material, int amount) {
        this.item = new ItemStack(material, amount);
        this.meta = this.item.getItemMeta();
        this.damageable = (Damageable)this.meta;
        this.material = material;
        this.amount = amount;
        this.durability = material.getMaxDurability();
        this.unbreakable = false;
    }

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(@NotNull ItemBuilder builder) {
        this.item = new ItemStack(builder.item);
        this.meta = this.item.getItemMeta();
        this.damageable = (Damageable)this.meta;
        this.material = builder.material;
        this.displayName = builder.displayName;
        this.amount = builder.amount;
        this.durability = builder.durability;
        this.unbreakable = builder.unbreakable;
        this.lore.addAll(builder.lore);
        this.flags.addAll(builder.flags);
        this.enchantments.putAll(builder.enchantments);
        this.save = builder.save;
        this.item.setItemMeta(this.meta);
    }

    public static ItemBuilder from(@NotNull ItemStack item) {
        return ITEM_BUILDER_LIST.stream().filter(ib -> ib.item == item).findFirst().orElse(null);
    }

    public ItemBuilder save() {
        ITEM_BUILDER_LIST.add(this);
        this.save = true;
        return this;
    }

    public ItemBuilder material(Material material) {
        this.material = material;
        this.item.setType(material);
        return this;
    }

    public ItemBuilder displayName(String displayName) {
        this.displayName = Component.text((String)displayName);
        this.meta.displayName((Component)Component.text((String)displayName));
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder colorName(ChatColor color) {
        return this.displayName(color + this.displayName.insertion());
    }

    public ItemBuilder colorName(String code) {
        return this.colorName(ChatColor.getByChar(code));
    }

    public ItemBuilder lore(@NotNull List<String> lore) {
        this.clearLore();
        lore.forEach(l -> this.lore.add((Component)Component.text((String)l)));
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder lore(String ... lines) {
        return this.lore(List.of(lines));
    }

    public ItemBuilder appendLoreLine(String line) {
        this.lore.add((Component)Component.text((String)line));
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder setLoreLine(int index, String line, boolean override) {
        TextComponent component = Component.text((String)line);
        if (override) {
            this.lore.set(index, (Component)component);
        } else {
            this.lore.add(index, (Component)component);
        }
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder setLoreLine(int index, String line) {
        return this.setLoreLine(index, line, true);
    }

    public ItemBuilder removeLoreLine(int index) {
        this.lore.remove(index);
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder removeLoreLine(String line) {
        this.lore.removeAll(Collections.singleton(Component.text((String)line)));
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder clearLore() {
        this.lore.clear();
        this.meta.lore(this.lore);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder hideFlag(ItemFlag ... flags) {
        this.flags.addAll(List.of(flags));
        this.meta.addItemFlags(flags);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder hideFlags() {
        return this.hideFlag(ItemFlag.values());
    }

    public ItemBuilder showFlag(ItemFlag ... flags) {
        List.of(flags).forEach(this.flags::remove);
        this.meta.removeItemFlags(flags);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder showFlags() {
        return this.showFlag(ItemFlag.values());
    }

    public ItemBuilder enchantment(Map<Enchantment, Integer> enchantments) {
        this.enchantments.putAll(enchantments);
        enchantments.forEach((e, i) -> this.meta.addEnchant((Enchantment)e, (int)i, true));
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder addEnchantment(Enchantment enchantment, int level) {
        this.enchantments.put(enchantment, level);
        this.meta.addEnchant(enchantment, level, true);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment, int level) {
        this.enchantments.entrySet().stream().filter(e -> (Integer)e.getValue() == level).forEach(e -> {
            this.enchantments.remove(enchantment, level);
            this.meta.removeEnchant((Enchantment)e.getKey());
        });
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder removeEnchantments(Enchantment ... enchantments) {
        List.of(enchantments).forEach(e -> {
            this.enchantments.remove(e);
            this.meta.removeEnchant((Enchantment)e);
        });
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder removeEnchantments(int ... levels) {
        this.enchantments.forEach((key, value) -> Arrays.stream(levels).filter(l -> value == l).forEach(l -> {
            this.enchantments.remove(key);
            this.meta.removeEnchant((Enchantment)key);
        }));
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.amount = amount;
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder damage(short durability) {
        this.durability = durability;
        this.damageable.setDamage((int)durability);
        this.item.setItemMeta((ItemMeta)this.damageable);
        return this;
    }

    public ItemBuilder durability(short damage) {
        return this.damage((short)(this.item.getMaxItemUseDuration() - damage));
    }

    public ItemBuilder dye(Color color) {
        LeatherArmorMeta armor = (LeatherArmorMeta)this.meta;
        armor.setColor(color);
        this.item.setItemMeta(armor);
        return this;
    }

    public ItemBuilder potionColor(Color color) {
        PotionMeta potion = (PotionMeta)this.meta;
        potion.setColor(color);
        this.item.setItemMeta(potion);
        return this;
    }

    public ItemBuilder customEffect(PotionEffectType effectType, int duration, int amplifier, boolean overwrite) {
        PotionMeta potion = (PotionMeta)this.meta;
        potion.addCustomEffect(new PotionEffect(effectType, duration, amplifier), overwrite);
        this.item.setItemMeta(potion);
        return this;
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        this.meta.setUnbreakable(true);
        this.item.setItemMeta(this.meta);
        return this;
    }

    public ItemStack build() {
        return this.item;
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public ItemMeta getMeta() {
        return this.meta;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public short getDurability() {
        return this.durability;
    }

    public List<Component> getLore() {
        return this.lore;
    }

    public Set<ItemFlag> getFlags() {
        return this.flags;
    }

    public boolean hasFlags() {
        return !this.flags.isEmpty();
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }
}

