/*
 * Decompiled with CFR 0.152.
 */
package vxrp.me.itemcustomizer.menus;

import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.util.ArrayList;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import vxrp.me.itemcustomizer.CreateItem;
import vxrp.me.itemcustomizer.Itemcustomizer;
import vxrp.me.itemcustomizer.Storage.EditingStorage;
import vxrp.me.itemcustomizer.Storage.ResetStorage;
import vxrp.me.itemcustomizer.menus.ConfirmMenu;
import vxrp.me.itemcustomizer.menus.attributemodifier.AttributeModifierMenu;
import vxrp.me.itemcustomizer.menus.color.ColorMenu;
import vxrp.me.itemcustomizer.menus.effects.effectstypeonetwo.EffectsTypeMenuOne;
import vxrp.me.itemcustomizer.menus.enchants.EnchantsOne;
import vxrp.me.itemcustomizer.menus.itemflags.ItemFlagMenu;
import vxrp.me.itemcustomizer.menus.items.GeneralItems;
import vxrp.me.itemcustomizer.menus.setValues.SetDisplayNameMenu;
import vxrp.me.itemcustomizer.util.ItemBuilder;

public class EditMenu
implements InventoryProvider {
    private final Itemcustomizer plugin;

    public EditMenu(Itemcustomizer itemcustomizer) {
        this.plugin = itemcustomizer;
    }

    public static void openMenu(Player player, Itemcustomizer itemcustomizer) {
        SmartInventory.builder().id("editMenu").provider(new EditMenu(itemcustomizer)).size(6, 9).title(ChatColor.AQUA + "EditMenu").manager(Itemcustomizer.getInvManager()).build().open(player);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        EditingStorage.setStorage(player.getUniqueId());
        String permissionMessage = this.plugin.getConfig().getString("missing_permission");
        String featureDisabled = this.plugin.getConfig().getString("feature_disabled");
        ItemMeta itemMeta = EditingStorage.getItemMeta(player.getUniqueId());
        Material type = EditingStorage.getItem(player.getUniqueId()).getType();
        if (EditingStorage.getConfirmed(player.getUniqueId()).booleanValue()) {
            ResetStorage.reset(player);
            itemMeta.setUnbreakable(false);
            EditMenu.openMenu(player, this.plugin);
        }
        if (EditingStorage.getItem(player.getUniqueId()) != null) {
            contents.set(1, 4, ClickableItem.empty(CreateItem.create(player)));
        } else if (EditingStorage.getItem(player.getUniqueId()) == null) {
            contents.set(1, 4, ClickableItem.empty(new ItemStack(Material.LIGHT)));
        }
        ItemStack itemFlags = new ItemBuilder(Material.GLASS).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "ItemFlags").lore(ChatColor.GRAY + "With ItemFlags you can hide certain", ChatColor.GRAY + "Attributes on an Item").build();
        contents.set(2, 2, ClickableItem.of(itemFlags, e -> {
            if (e.isLeftClick()) {
                if (this.plugin.getConfig().getBoolean("customize_edit.set_itemFlags")) {
                    player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                    ItemFlagMenu.openMenu(player, this.plugin);
                } else {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (permissionMessage != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                }
            }
        }));
        ItemStack displayName = new ItemBuilder(Material.NAME_TAG).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "DisplayName").lore(ChatColor.GRAY + "Sets the display name,", ChatColor.GRAY + "'you can use color codes too'").build();
        contents.set(2, 4, ClickableItem.of(displayName, e -> {
            if (e.isLeftClick()) {
                if (this.plugin.getConfig().getBoolean("customize_edit.set_displayName")) {
                    player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                    SetDisplayNameMenu.openMenu(player, this.plugin);
                } else {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (permissionMessage != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                }
            }
        }));
        ItemStack enchants = new ItemBuilder(Material.ENCHANTED_BOOK).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "Enchants").lore(ChatColor.GRAY + "Adds the specified enchantment to this item").build();
        contents.set(2, 6, ClickableItem.of(enchants, e -> {
            if (e.isLeftClick()) {
                if (this.plugin.getConfig().getBoolean("customize_edit.set_enchants")) {
                    player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                    EnchantsOne.openMenu(player, this.plugin);
                } else {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (permissionMessage != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                }
            }
        }));
        if (type == Material.LEATHER_HELMET || type == Material.LEATHER_CHESTPLATE || type == Material.LEATHER_LEGGINGS || type == Material.LEATHER_BOOTS) {
            ItemStack color = new ItemBuilder(Material.CAULDRON).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "Color").lore(ChatColor.GRAY + "Sets the color of the armor").build();
            contents.set(3, 1, ClickableItem.of(color, e -> {
                if (e.isLeftClick()) {
                    if (this.plugin.getConfig().getBoolean("customize_edit.set_color")) {
                        player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                        ColorMenu.openMenu(player, this.plugin);
                    } else {
                        player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                        assert (permissionMessage != null);
                        player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                    }
                }
            }));
        } else {
            contents.set(3, 1, ClickableItem.of(GeneralItems.featureDisabled(), e -> {
                if (e.isLeftClick()) {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (featureDisabled != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', featureDisabled));
                }
            }));
        }
        ItemStack unbreakable = new ItemStack(Material.NETHERITE_INGOT);
        ItemMeta unbreakableMeta = unbreakable.getItemMeta();
        if (itemMeta.isUnbreakable()) {
            unbreakableMeta.addEnchant(Enchantment.LUCK, 1, false);
        }
        unbreakableMeta.addItemFlags(ItemFlag.HIDE_ENCHANTS);
        unbreakableMeta.displayName((Component)Component.text((String)(ChatColor.AQUA + "Unbreakable")));
        ArrayList<TextComponent> unbreakableLore = new ArrayList<TextComponent>();
        unbreakableLore.add(Component.text((String)(ChatColor.GRAY + "Sets the unbreakable tag. An unbreakable item will")));
        unbreakableLore.add(Component.text((String)(ChatColor.GRAY + "not lose durability")));
        unbreakableMeta.lore(unbreakableLore);
        unbreakable.setItemMeta(unbreakableMeta);
        contents.set(3, 3, ClickableItem.of(unbreakable, e -> {
            if (e.isLeftClick()) {
                if (this.plugin.getConfig().getBoolean("customize_edit.set_unbreakable")) {
                    player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                    itemMeta.setUnbreakable(!itemMeta.isUnbreakable());
                    EditMenu.openMenu(player, this.plugin);
                } else {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (permissionMessage != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                }
            }
        }));
        ItemStack attributeModifier = new ItemBuilder(Material.COMMAND_BLOCK).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "Attribute Modifiers").lore(ChatColor.GRAY + "Set all Attributes and their AttributeModifiers").build();
        contents.set(3, 5, ClickableItem.of(attributeModifier, e -> {
            if (e.isLeftClick()) {
                if (this.plugin.getConfig().getBoolean("customize_edit.set_attributeModifier")) {
                    player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                    EditingStorage.setNumber(player.getUniqueId(), 0.0);
                    EditingStorage.setEquipmentSlot(player.getUniqueId(), null);
                    AttributeModifierMenu.openMenu(player, this.plugin);
                } else {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (permissionMessage != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                }
            }
        }));
        if (type == Material.POTION || type == Material.LINGERING_POTION || type == Material.SPLASH_POTION) {
            ItemStack effects = new ItemBuilder(Material.POTION).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "Effects").lore(ChatColor.GRAY + "Sets the effect of a potion").build();
            contents.set(3, 7, ClickableItem.of(effects, e -> {
                if (e.isLeftClick()) {
                    if (this.plugin.getConfig().getBoolean("customize_edit.set_effects")) {
                        player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                        EditingStorage.setTimeIn(player.getUniqueId(), 0);
                        EditingStorage.setColor(player.getUniqueId(), null);
                        EditingStorage.setTime(player.getUniqueId(), 0);
                        EditingStorage.setAmplifier(player.getUniqueId(), 0);
                        EditingStorage.setPotionMeta(player.getUniqueId(), null);
                        EffectsTypeMenuOne.openMenu(player, this.plugin);
                    } else {
                        player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                        assert (permissionMessage != null);
                        player.sendMessage(ChatColor.translateAlternateColorCodes('&', permissionMessage));
                    }
                }
            }));
        } else {
            contents.set(3, 7, ClickableItem.of(GeneralItems.featureDisabled(), e -> {
                if (e.isLeftClick()) {
                    player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                    assert (featureDisabled != null);
                    player.sendMessage(ChatColor.translateAlternateColorCodes('&', featureDisabled));
                }
            }));
        }
        ItemStack reset = new ItemBuilder(Material.BARRIER).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.AQUA + "Reset").lore(ChatColor.GRAY + "This will reset all changes that", ChatColor.GRAY + "have been made in this configuration").build();
        contents.set(5, 8, ClickableItem.of(reset, e -> {
            if (e.isLeftClick()) {
                player.playSound(player, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 10.0f, 1.0f);
                ConfirmMenu.openMenu(player, this.plugin);
            }
        }));
        ItemStack finish = new ItemBuilder(Material.ANVIL).hideFlag(ItemFlag.HIDE_ATTRIBUTES).displayName(ChatColor.GREEN + "Finish").lore(ChatColor.GRAY + "This finishes the item creation", ChatColor.GRAY + "all the attributes and effects you chose", ChatColor.GRAY + "will be added to your item of choice").build();
        contents.set(5, 4, ClickableItem.of(finish, e -> {
            if (e.isLeftClick()) {
                if (EditingStorage.getItem(player.getUniqueId()) == null) {
                    EditingStorage.setItem(player.getUniqueId(), new ItemStack(player.getInventory().getItemInMainHand().getType()));
                }
                player.playSound(player, Sound.BLOCK_ANVIL_USE, 10.0f, 1.0f);
                player.getInventory().addItem(CreateItem.create(player));
                player.closeInventory();
            }
        }));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

