/*
 * Decompiled with CFR 0.152.
 */
package vxrp.me.itemcustomizer.commands;

import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import vxrp.me.itemcustomizer.Itemcustomizer;
import vxrp.me.itemcustomizer.Storage.EditingStorage;
import vxrp.me.itemcustomizer.Storage.ResetStorage;
import vxrp.me.itemcustomizer.menus.EditMenu;

public class EditCommand
implements CommandExecutor {
    private final Itemcustomizer plugin;

    public EditCommand(Itemcustomizer itemcustomizer) {
        this.plugin = itemcustomizer;
    }

    @Override
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            EditingStorage.setStorage(player.getUniqueId());
            if (args.length != 0) {
                return false;
            }
            if (Objects.requireNonNull(this.plugin.getConfig().getString("blocked_items")).contains(player.getInventory().getItemInMainHand().getType().toString())) {
                player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                player.sendMessage(ChatColor.translateAlternateColorCodes('&', Objects.requireNonNull(this.plugin.getConfig().getString("item_blocked"))));
                return false;
            }
            if (player.getInventory().getItemInMainHand().getType() != Material.AIR) {
                ItemStack itemstack = new ItemStack(player.getInventory().getItemInMainHand().getType());
                ItemMeta itemmeta = itemstack.getItemMeta();
                itemmeta.removeAttributeModifier(Attribute.GENERIC_ARMOR);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_ARMOR_TOUGHNESS);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_ATTACK_KNOCKBACK);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_ATTACK_SPEED);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_FLYING_SPEED);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_FOLLOW_RANGE);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_KNOCKBACK_RESISTANCE);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_LUCK);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_MAX_HEALTH);
                itemmeta.removeAttributeModifier(Attribute.GENERIC_MOVEMENT_SPEED);
                itemstack.setItemMeta(itemmeta);
                if (EditingStorage.getItem(player.getUniqueId()) != null) {
                    if (EditingStorage.getItem(player.getUniqueId()).getType() != player.getInventory().getItemInMainHand().getType()) {
                        ResetStorage.reset(player);
                        EditingStorage.setItem(player.getUniqueId(), itemstack);
                        EditingStorage.setItemMeta(player.getUniqueId(), itemmeta);
                        EditingStorage.getItemMeta(player.getUniqueId());
                    }
                } else {
                    EditingStorage.setItem(player.getUniqueId(), itemstack);
                    EditingStorage.setItemMeta(player.getUniqueId(), itemmeta);
                }
                EditMenu.openMenu(player, this.plugin);
            } else {
                player.playSound(player, Sound.ENTITY_VILLAGER_NO, 10.0f, 1.0f);
                player.sendMessage(ChatColor.RED + "You need to hold an item in your hand while using this command");
            }
        }
        return false;
    }
}

