/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.text.json.WriteJsonBuffer;
import java.io.IOException;

public class EscapeJson {
    public static String escapeQuote(String value) {
        if (value == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(value.length() + 2);
        sb.append("\"");
        EscapeJson.escapeAppend(value, sb);
        sb.append("\"");
        return sb.toString();
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        EscapeJson.escapeAppend(s2, sb);
        return sb.toString();
    }

    public static void escape(String value, WriteJsonBuffer sb) {
        if (value == null) {
            sb.append("null");
        } else {
            EscapeJson.escapeAppend(value, sb);
        }
    }

    public static void escapeQuote(String value, WriteJsonBuffer sb) {
        if (value == null) {
            sb.append("null");
        } else {
            sb.append("\"");
            EscapeJson.escapeAppend(value, sb);
            sb.append("\"");
        }
    }

    public static void escapeAppend(String s2, Appendable sb) {
        try {
            block12: for (int i = 0; i < s2.length(); ++i) {
                char ch = s2.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block12;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block12;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block12;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block12;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block12;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block12;
                    }
                    case '/': {
                        sb.append("\\/");
                        continue block12;
                    }
                    default: {
                        if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            String hs = Integer.toHexString(ch);
                            sb.append("\\u");
                            for (int j = 0; j < 4 - hs.length(); ++j) {
                                sb.append('0');
                            }
                            sb.append(hs.toUpperCase());
                            continue block12;
                        }
                        sb.append(ch);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new TextException(e);
        }
    }
}

