/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.json;

import com.avaje.ebean.text.json.JsonElement;
import com.avaje.ebean.text.json.JsonElementArray;
import com.avaje.ebean.text.json.JsonElementBoolean;
import com.avaje.ebean.text.json.JsonElementNull;
import com.avaje.ebean.text.json.JsonElementNumber;
import com.avaje.ebean.text.json.JsonElementObject;
import com.avaje.ebean.text.json.JsonElementString;
import com.avaje.ebeaninternal.server.text.json.ReadJsonInterface;

public class ReadJsonRawReader {
    private final ReadJsonInterface ctx;

    public static JsonElement readJsonElement(ReadJsonInterface ctx) {
        return new ReadJsonRawReader(ctx).readJsonElement();
    }

    private ReadJsonRawReader(ReadJsonInterface ctx) {
        this.ctx = ctx;
    }

    private JsonElement readJsonElement() {
        return this.readValue();
    }

    private JsonElement readValue() {
        this.ctx.ignoreWhiteSpace();
        char c = this.ctx.nextChar();
        switch (c) {
            case '{': {
                return this.readObject();
            }
            case '[': {
                return this.readArray();
            }
            case '\"': {
                return this.readString();
            }
        }
        return this.readUnquoted(c);
    }

    private JsonElement readArray() {
        JsonElementArray a = new JsonElementArray();
        do {
            JsonElement value = this.readValue();
            a.add(value);
        } while (this.ctx.readArrayNext());
        return a;
    }

    private JsonElement readObject() {
        JsonElementObject o = new JsonElementObject();
        while (this.ctx.readKeyNext()) {
            String key = this.ctx.getTokenKey();
            JsonElement value = this.readValue();
            o.put(key, value);
            if (this.ctx.readValueNext()) continue;
            break;
        }
        return o;
    }

    private JsonElement readString() {
        String s2 = this.ctx.readQuotedValue();
        return new JsonElementString(s2);
    }

    private JsonElement readUnquoted(char c) {
        String s2 = this.ctx.readUnquotedValue(c);
        if ("null".equals(s2)) {
            return JsonElementNull.NULL;
        }
        if ("true".equals(s2)) {
            return JsonElementBoolean.TRUE;
        }
        if ("false".equals(s2)) {
            return JsonElementBoolean.FALSE;
        }
        return new JsonElementNumber(s2);
    }
}

