/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.csv;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.StringParser;
import com.avaje.ebean.text.TextException;
import com.avaje.ebean.text.TimeStringParser;
import com.avaje.ebean.text.csv.CsvCallback;
import com.avaje.ebean.text.csv.CsvReader;
import com.avaje.ebean.text.csv.DefaultCsvCallback;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.text.csv.CsvUtilReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCsvReader<T>
implements CsvReader<T> {
    private static final TimeStringParser TIME_PARSER = new TimeStringParser();
    private final EbeanServer server;
    private final BeanDescriptor<T> descriptor;
    private final List<CsvColumn> columnList = new ArrayList<CsvColumn>();
    private final CsvColumn ignoreColumn = new CsvColumn();
    private boolean treatEmptyStringAsNull = true;
    private boolean hasHeader;
    private int logInfoFrequency = 1000;
    private String defaultTimeFormat = "HH:mm:ss";
    private String defaultDateFormat = "yyyy-MM-dd";
    private String defaultTimestampFormat = "yyyy-MM-dd hh:mm:ss.fffffffff";
    private Locale defaultLocale = Locale.getDefault();
    protected int persistBatchSize = 30;
    private boolean addPropertiesFromHeader;

    public TCsvReader(EbeanServer server, BeanDescriptor<T> descriptor) {
        this.server = server;
        this.descriptor = descriptor;
    }

    @Override
    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Override
    public void setDefaultTimeFormat(String defaultTimeFormat) {
        this.defaultTimeFormat = defaultTimeFormat;
    }

    @Override
    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    @Override
    public void setDefaultTimestampFormat(String defaultTimestampFormat) {
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    @Override
    public void setPersistBatchSize(int persistBatchSize) {
        this.persistBatchSize = persistBatchSize;
    }

    @Override
    public void setIgnoreHeader() {
        this.setHasHeader(true, false);
    }

    @Override
    public void setAddPropertiesFromHeader() {
        this.setHasHeader(true, true);
    }

    @Override
    public void setHasHeader(boolean hasHeader, boolean addPropertiesFromHeader) {
        this.hasHeader = hasHeader;
        this.addPropertiesFromHeader = addPropertiesFromHeader;
    }

    @Override
    public void setLogInfoFrequency(int logInfoFrequency) {
        this.logInfoFrequency = logInfoFrequency;
    }

    @Override
    public void addIgnore() {
        this.columnList.add(this.ignoreColumn);
    }

    @Override
    public void addProperty(String propertyName) {
        this.addProperty(propertyName, null);
    }

    @Override
    public void addReference(String propertyName) {
        this.addProperty(propertyName, null, true);
    }

    @Override
    public void addProperty(String propertyName, StringParser parser) {
        this.addProperty(propertyName, parser, false);
    }

    @Override
    public void addDateTime(String propertyName, String dateTimeFormat) {
        this.addDateTime(propertyName, dateTimeFormat, Locale.getDefault());
    }

    @Override
    public void addDateTime(String propertyName, String dateTimeFormat, Locale locale) {
        ElPropertyValue elProp = this.descriptor.getElGetValue(propertyName);
        if (!elProp.isDateTimeCapable()) {
            throw new TextException("Property " + propertyName + " is not DateTime capable");
        }
        if (dateTimeFormat == null) {
            dateTimeFormat = this.getDefaultDateTimeFormat(elProp.getJdbcType());
        }
        if (locale == null) {
            locale = this.defaultLocale;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat, locale);
        DateTimeParser parser = new DateTimeParser(sdf, dateTimeFormat, elProp);
        CsvColumn column = new CsvColumn(elProp, parser, false);
        this.columnList.add(column);
    }

    private String getDefaultDateTimeFormat(int jdbcType) {
        switch (jdbcType) {
            case 92: {
                return this.defaultTimeFormat;
            }
            case 91: {
                return this.defaultDateFormat;
            }
            case 93: {
                return this.defaultTimestampFormat;
            }
        }
        throw new RuntimeException("Expected java.sql.Types TIME,DATE or TIMESTAMP but got [" + jdbcType + "]");
    }

    public void addProperty(String propertyName, StringParser parser, boolean reference) {
        ElPropertyValue elProp = this.descriptor.getElGetValue(propertyName);
        if (parser == null) {
            parser = elProp.getStringParser();
        }
        CsvColumn column = new CsvColumn(elProp, parser, reference);
        this.columnList.add(column);
    }

    @Override
    public void process(Reader reader) throws Exception {
        DefaultCsvCallback callback = new DefaultCsvCallback(this.persistBatchSize, this.logInfoFrequency);
        this.process(reader, callback);
    }

    @Override
    public void process(Reader reader, CsvCallback<T> callback) throws Exception {
        Object[] line;
        if (reader == null) {
            throw new NullPointerException("reader is null?");
        }
        if (callback == null) {
            throw new NullPointerException("callback is null?");
        }
        CsvUtilReader utilReader = new CsvUtilReader(reader);
        callback.begin(this.server);
        int row = 0;
        if (this.hasHeader) {
            line = utilReader.readNext();
            if (this.addPropertiesFromHeader) {
                this.addPropertiesFromHeader((String[])line);
            }
            callback.readHeader((String[])line);
        }
        try {
            while (true) {
                ++row;
                line = utilReader.readNext();
                if (line == null) break;
                if (!callback.processLine(row, (String[])line)) continue;
                if (line.length != this.columnList.size()) {
                    String msg = "Error at line " + row + ". Expected [" + this.columnList.size() + "] columns " + "but instead we have [" + line.length + "].  Line[" + Arrays.toString(line) + "]";
                    throw new TextException(msg);
                }
                T bean = this.buildBeanFromLineContent(row, (String[])line);
                callback.processBean(row, (String[])line, bean);
            }
            callback.end(--row);
        }
        catch (Exception e) {
            callback.endWithError(row, e);
            throw e;
        }
    }

    private void addPropertiesFromHeader(String[] line) {
        for (int i = 0; i < line.length; ++i) {
            ElPropertyValue elProp = this.descriptor.getElGetValue(line[i]);
            if (elProp == null) {
                throw new TextException("Property [" + line[i] + "] not found");
            }
            if (92 == elProp.getJdbcType()) {
                this.addProperty(line[i], TIME_PARSER);
                continue;
            }
            if (this.isDateTimeType(elProp.getJdbcType())) {
                this.addDateTime(line[i], null, null);
                continue;
            }
            if (elProp.isAssocProperty()) {
                BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)elProp.getBeanProperty();
                String idProp = assocOne.getBeanDescriptor().getIdBinder().getIdProperty();
                this.addReference(line[i] + "." + idProp);
                continue;
            }
            this.addProperty(line[i]);
        }
    }

    private boolean isDateTimeType(int t2) {
        return t2 == 93 || t2 == 91 || t2 == 92;
    }

    protected T buildBeanFromLineContent(int row, String[] line) {
        try {
            EntityBean entityBean;
            EntityBean bean = entityBean = this.descriptor.createEntityBean();
            for (int columnPos = 0; columnPos < line.length; ++columnPos) {
                this.convertAndSetColumn(columnPos, line[columnPos], entityBean);
            }
            return (T)bean;
        }
        catch (RuntimeException e) {
            String msg = "Error at line: " + row + " line[" + Arrays.toString(line) + "]";
            throw new RuntimeException(msg, e);
        }
    }

    protected void convertAndSetColumn(int columnPos, String strValue, Object bean) {
        if ((strValue = strValue.trim()).length() == 0 && this.treatEmptyStringAsNull) {
            return;
        }
        CsvColumn c = this.columnList.get(columnPos);
        c.convertAndSet(strValue, bean);
    }

    private static class DateTimeParser
    implements StringParser {
        private final DateFormat dateFormat;
        private final ElPropertyValue elProp;
        private final String format;

        DateTimeParser(DateFormat dateFormat, String format, ElPropertyValue elProp) {
            this.dateFormat = dateFormat;
            this.elProp = elProp;
            this.format = format;
        }

        public Object parse(String value) {
            try {
                Date dt = this.dateFormat.parse(value);
                return this.elProp.parseDateTime(dt.getTime());
            }
            catch (ParseException e) {
                throw new TextException("Error parsing [" + value + "] using format[" + this.format + "]", e);
            }
        }
    }

    public static class CsvColumn {
        private final ElPropertyValue elProp;
        private final StringParser parser;
        private final boolean ignore;
        private final boolean reference;

        private CsvColumn() {
            this.elProp = null;
            this.parser = null;
            this.reference = false;
            this.ignore = true;
        }

        public CsvColumn(ElPropertyValue elProp, StringParser parser, boolean reference) {
            this.elProp = elProp;
            this.parser = parser;
            this.reference = reference;
            this.ignore = false;
        }

        public void convertAndSet(String strValue, Object bean) {
            if (!this.ignore) {
                Object value = this.parser.parse(strValue);
                this.elProp.elSetValue(bean, value, true, this.reference);
            }
        }
    }
}

