/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Query;
import com.avaje.ebean.QueryIterator;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.event.BeanFinder;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorManager;
import com.avaje.ebeaninternal.server.query.CQueryEngine;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOrmQueryEngine
implements OrmQueryEngine {
    private final CQueryEngine queryEngine;

    public DefaultOrmQueryEngine(BeanDescriptorManager descMgr, CQueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    @Override
    public <T> int findRowCount(OrmQueryRequest<T> request) {
        return this.queryEngine.findRowCount(request);
    }

    @Override
    public <T> BeanIdList findIds(OrmQueryRequest<T> request) {
        return this.queryEngine.findIds(request);
    }

    @Override
    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        Transaction t2 = request.getTransaction();
        t2.flushBatch();
        return this.queryEngine.findIterate(request);
    }

    @Override
    public <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        BeanCollection<T> result = null;
        Transaction t2 = request.getTransaction();
        t2.flushBatch();
        BeanFinder<T> finder = request.getBeanFinder();
        result = finder != null ? finder.findMany(request) : this.queryEngine.findMany(request);
        if (query.isLoadBeanCache()) {
            BeanDescriptor<T> descriptor = request.getBeanDescriptor();
            Collection<T> c = result.getActualDetails();
            for (T bean : c) {
                descriptor.cachePutBeanData(bean);
            }
        }
        if (!result.isEmpty() && query.isUseQueryCache()) {
            request.putToQueryCache(result);
        }
        return result;
    }

    @Override
    public <T> T findId(OrmQueryRequest<T> request) {
        BeanFinder<T> finder;
        T result = null;
        Transaction t2 = request.getTransaction();
        if (t2.isBatchFlushOnQuery()) {
            t2.flushBatch();
        }
        if ((result = (finder = request.getBeanFinder()) != null ? (T)finder.find(request) : (T)this.queryEngine.find(request)) != null && request.isUseBeanCache()) {
            request.getBeanDescriptor().cachePutBeanData(result);
        }
        return result;
    }
}

