/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PstmtBatch;
import com.avaje.ebeaninternal.server.persist.BatchPostExecute;
import com.avaje.ebeaninternal.server.persist.BatchedPstmt;
import com.avaje.ebeaninternal.server.persist.BatchedPstmtHolder;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PstmtFactory {
    private final PstmtBatch pstmtBatch;

    public PstmtFactory(PstmtBatch pstmtBatch) {
        this.pstmtBatch = pstmtBatch;
    }

    public CallableStatement getCstmt(SpiTransaction t2, String sql) throws SQLException {
        Connection conn = t2.getInternalConnection();
        return conn.prepareCall(sql);
    }

    public PreparedStatement getPstmt(SpiTransaction t2, String sql) throws SQLException {
        Connection conn = t2.getInternalConnection();
        return conn.prepareStatement(sql);
    }

    public PreparedStatement getPstmt(SpiTransaction t2, boolean logSql, String sql, BatchPostExecute batchExe) throws SQLException {
        BatchedPstmtHolder batch = t2.getBatchControl().getPstmtHolder();
        PreparedStatement stmt = batch.getStmt(sql, batchExe);
        if (stmt != null) {
            return stmt;
        }
        if (logSql) {
            t2.logInternal(sql);
        }
        Connection conn = t2.getInternalConnection();
        stmt = conn.prepareStatement(sql);
        if (this.pstmtBatch != null) {
            this.pstmtBatch.setBatchSize(stmt, t2.getBatchControl().getBatchSize());
        }
        BatchedPstmt bs = new BatchedPstmt(stmt, false, sql, this.pstmtBatch, false);
        batch.addStmt(bs, batchExe);
        return stmt;
    }

    public CallableStatement getCstmt(SpiTransaction t2, boolean logSql, String sql, BatchPostExecute batchExe) throws SQLException {
        BatchedPstmtHolder batch = t2.getBatchControl().getPstmtHolder();
        CallableStatement stmt = (CallableStatement)batch.getStmt(sql, batchExe);
        if (stmt != null) {
            return stmt;
        }
        if (logSql) {
            t2.logInternal(sql);
        }
        Connection conn = t2.getInternalConnection();
        stmt = conn.prepareCall(sql);
        BatchedPstmt bs = new BatchedPstmt(stmt, false, sql, this.pstmtBatch, false);
        batch.addStmt(bs, batchExe);
        return stmt;
    }
}

