/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebeaninternal.api.BindParams;
import com.avaje.ebeaninternal.api.SpiSqlUpdate;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PersistRequestUpdateSql;
import com.avaje.ebeaninternal.server.core.PstmtBatch;
import com.avaje.ebeaninternal.server.persist.Binder;
import com.avaje.ebeaninternal.server.persist.PstmtFactory;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.util.BindParamsParser;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.PersistenceException;

public class ExeUpdateSql {
    private static final Logger logger = Logger.getLogger(ExeUpdateSql.class.getName());
    private final Binder binder;
    private final PstmtFactory pstmtFactory;
    private final PstmtBatch pstmtBatch;
    private int defaultBatchSize = 20;

    public ExeUpdateSql(Binder binder, PstmtBatch pstmtBatch) {
        this.binder = binder;
        this.pstmtBatch = pstmtBatch;
        this.pstmtFactory = new PstmtFactory(pstmtBatch);
    }

    public int execute(PersistRequestUpdateSql request) {
        SpiTransaction t2 = request.getTransaction();
        boolean batchThisRequest = t2.isBatchThisRequest();
        PreparedStatement pstmt = null;
        try {
            pstmt = this.bindStmt(request, batchThisRequest);
            if (batchThisRequest) {
                if (this.pstmtBatch != null) {
                    this.pstmtBatch.addBatch(pstmt);
                } else {
                    pstmt.addBatch();
                }
                int n = -1;
                return n;
            }
            int rowCount = pstmt.executeUpdate();
            request.checkRowCount(rowCount);
            request.postExecute();
            int n = rowCount;
            return n;
        }
        catch (SQLException ex) {
            throw new PersistenceException(ex);
        }
        finally {
            if (!batchThisRequest && pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, null, e);
                }
            }
        }
    }

    private PreparedStatement bindStmt(PersistRequestUpdateSql request, boolean batchThisRequest) throws SQLException {
        PreparedStatement pstmt;
        SpiSqlUpdate updateSql = request.getUpdateSql();
        SpiTransaction t2 = request.getTransaction();
        String sql = updateSql.getSql();
        BindParams bindParams = updateSql.getBindParams();
        sql = BindParamsParser.parse(bindParams, sql);
        boolean logSql = request.isLogSql();
        if (batchThisRequest) {
            pstmt = this.pstmtFactory.getPstmt(t2, logSql, sql, request);
            if (this.pstmtBatch != null) {
                int batchSize = t2.getBatchSize();
                if (batchSize < 1) {
                    batchSize = this.defaultBatchSize;
                }
                this.pstmtBatch.setBatchSize(pstmt, batchSize);
            }
        } else {
            if (logSql) {
                t2.logInternal(sql);
            }
            pstmt = this.pstmtFactory.getPstmt(t2, sql);
        }
        if (updateSql.getTimeout() > 0) {
            pstmt.setQueryTimeout(updateSql.getTimeout());
        }
        String bindLog = null;
        if (!bindParams.isEmpty()) {
            bindLog = this.binder.bind(bindParams, new DataBind(pstmt));
        }
        request.setBindLog(bindLog);
        this.parseUpdate(sql, request);
        return pstmt;
    }

    private void determineType(String word1, String word2, String word3, PersistRequestUpdateSql request) {
        if (word1.equalsIgnoreCase("UPDATE")) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_UPDATE, word2, "UpdateSql");
        } else if (word1.equalsIgnoreCase("DELETE")) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_DELETE, word3, "DeleteSql");
        } else if (word1.equalsIgnoreCase("INSERT")) {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_INSERT, word3, "InsertSql");
        } else {
            request.setType(PersistRequestUpdateSql.SqlType.SQL_UNKNOWN, null, "UnknownSql");
        }
    }

    private void parseUpdate(String sql, PersistRequestUpdateSql request) {
        int start = this.ltrim(sql);
        int[] pos = new int[3];
        int spaceCount = 0;
        int len = sql.length();
        for (int i = start; i < len; ++i) {
            char c = sql.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            pos[spaceCount] = i;
            if (++spaceCount > 2) break;
        }
        String firstWord = sql.substring(0, pos[0]);
        String secWord = sql.substring(pos[0] + 1, pos[1]);
        String thirdWord = pos[2] == 0 ? sql.substring(pos[1] + 1) : sql.substring(pos[1] + 1, pos[2]);
        this.determineType(firstWord, secWord, thirdWord, request);
    }

    private int ltrim(String s2) {
        int len = s2.length();
        int i = 0;
        for (i = 0; i < len; ++i) {
            if (Character.isWhitespace(s2.charAt(i))) continue;
            return i;
        }
        return 0;
    }
}

