/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public DaemonThreadFactory(String namePrefix) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix != null ? namePrefix : "pool-" + poolNumber.getAndIncrement() + "-thread-";
    }

    public Thread newThread(Runnable r) {
        Thread t2 = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        t2.setDaemon(true);
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }
}

