/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.el;

import com.avaje.ebean.Filter;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.el.ElComparator;
import com.avaje.ebeaninternal.server.el.ElMatchBuilder;
import com.avaje.ebeaninternal.server.el.ElMatcher;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElFilter<T>
implements Filter<T> {
    private final BeanDescriptor<T> beanDescriptor;
    private ArrayList<ElMatcher<T>> matches = new ArrayList();
    private int maxRows;
    private String sortByClause;

    public ElFilter(BeanDescriptor<T> beanDescriptor) {
        this.beanDescriptor = beanDescriptor;
    }

    private Object convertValue(String propertyName, Object value) {
        ElPropertyValue elGetValue = this.beanDescriptor.getElGetValue(propertyName);
        return elGetValue.elConvertType(value);
    }

    private ElComparator<T> getElComparator(String propertyName) {
        return this.beanDescriptor.getElComparator(propertyName);
    }

    private ElPropertyValue getElGetValue(String propertyName) {
        return this.beanDescriptor.getElGetValue(propertyName);
    }

    @Override
    public Filter<T> sort(String sortByClause) {
        this.sortByClause = sortByClause;
        return this;
    }

    protected boolean isMatch(T bean) {
        for (int i = 0; i < this.matches.size(); ++i) {
            ElMatcher<T> matcher = this.matches.get(i);
            if (matcher.isMatch(bean)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Filter<T> in(String propertyName, Set<?> matchingValues) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.InSet(matchingValues, elGetValue));
        return this;
    }

    @Override
    public Filter<T> eq(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Eq<T>(value, comparator));
        return this;
    }

    @Override
    public Filter<T> ne(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Ne<T>(value, comparator));
        return this;
    }

    @Override
    public Filter<T> between(String propertyName, Object min2, Object max) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        min2 = elGetValue.elConvertType(min2);
        max = elGetValue.elConvertType(max);
        ElComparator<T> elComparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Between<T>(min2, max, elComparator));
        return this;
    }

    @Override
    public Filter<T> gt(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Gt<T>(value, comparator));
        return this;
    }

    @Override
    public Filter<T> ge(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Ge<T>(value, comparator));
        return this;
    }

    @Override
    public Filter<T> ieq(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.Ieq(elGetValue, value));
        return this;
    }

    @Override
    public Filter<T> isNotNull(String propertyName) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IsNotNull(elGetValue));
        return this;
    }

    @Override
    public Filter<T> isNull(String propertyName) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IsNull(elGetValue));
        return this;
    }

    @Override
    public Filter<T> le(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Le<T>(value, comparator));
        return this;
    }

    @Override
    public Filter<T> lt(String propertyName, Object value) {
        value = this.convertValue(propertyName, value);
        ElComparator<T> comparator = this.getElComparator(propertyName);
        this.matches.add(new ElMatchBuilder.Lt<T>(value, comparator));
        return this;
    }

    public Filter<T> regex(String propertyName, String regEx) {
        return this.regex(propertyName, regEx, 0);
    }

    public Filter<T> regex(String propertyName, String regEx, int options) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.RegularExpr(elGetValue, regEx, options));
        return this;
    }

    @Override
    public Filter<T> contains(String propertyName, String value) {
        String quote = ".*" + Pattern.quote(value) + ".*";
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.RegularExpr(elGetValue, quote, 0));
        return this;
    }

    @Override
    public Filter<T> icontains(String propertyName, String value) {
        String quote = ".*" + Pattern.quote(value) + ".*";
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.RegularExpr(elGetValue, quote, 2));
        return this;
    }

    @Override
    public Filter<T> endsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.EndsWith(elGetValue, value));
        return this;
    }

    @Override
    public Filter<T> startsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.StartsWith(elGetValue, value));
        return this;
    }

    @Override
    public Filter<T> iendsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IEndsWith(elGetValue, value));
        return this;
    }

    @Override
    public Filter<T> istartsWith(String propertyName, String value) {
        ElPropertyValue elGetValue = this.getElGetValue(propertyName);
        this.matches.add(new ElMatchBuilder.IStartsWith(elGetValue, value));
        return this;
    }

    @Override
    public Filter<T> maxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    @Override
    public List<T> filter(List<T> list) {
        if (this.sortByClause != null) {
            list = new ArrayList<T>(list);
            this.beanDescriptor.sort(list, this.sortByClause);
        }
        ArrayList<T> filterList = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            T t2 = list.get(i);
            if (!this.isMatch(t2)) continue;
            filterList.add(t2);
            if (this.maxRows > 0 && filterList.size() >= this.maxRows) break;
        }
        return filterList;
    }
}

