/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cluster;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.GlobalProperties;
import com.avaje.ebeaninternal.api.ClassUtil;
import com.avaje.ebeaninternal.server.cluster.ClusterBroadcast;
import com.avaje.ebeaninternal.server.cluster.mcast.McastClusterManager;
import com.avaje.ebeaninternal.server.cluster.socket.SocketClusterBroadcast;
import com.avaje.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterManager {
    private static final Logger logger = Logger.getLogger(ClusterManager.class.getName());
    private final ConcurrentHashMap<String, EbeanServer> serverMap = new ConcurrentHashMap();
    private final Object monitor = new Object();
    private final ClusterBroadcast broadcast;
    private boolean started;

    public ClusterManager() {
        String clusterType = GlobalProperties.get("ebean.cluster.type", null);
        if (clusterType == null || clusterType.trim().length() == 0) {
            this.broadcast = null;
        } else {
            try {
                if ("mcast".equalsIgnoreCase(clusterType)) {
                    this.broadcast = new McastClusterManager();
                } else if ("socket".equalsIgnoreCase(clusterType)) {
                    this.broadcast = new SocketClusterBroadcast();
                } else {
                    logger.info("Clustering using [" + clusterType + "]");
                    this.broadcast = (ClusterBroadcast)ClassUtil.newInstance(clusterType);
                }
            }
            catch (Exception e) {
                String msg = "Error initialising ClusterManager type [" + clusterType + "]";
                logger.log(Level.SEVERE, msg, e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServer(EbeanServer server) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.started) {
                this.startup();
            }
            this.serverMap.put(server.getName(), server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EbeanServer getServer(String name) {
        Object object = this.monitor;
        synchronized (object) {
            return this.serverMap.get(name);
        }
    }

    private void startup() {
        this.started = true;
        if (this.broadcast != null) {
            this.broadcast.startup(this);
        }
    }

    public boolean isClustering() {
        return this.broadcast != null;
    }

    public void broadcast(RemoteTransactionEvent remoteTransEvent) {
        if (this.broadcast != null) {
            this.broadcast.broadcast(remoteTransEvent);
        }
    }

    public void shutdown() {
        if (this.broadcast != null) {
            logger.info("ClusterManager shutdown ");
            this.broadcast.shutdown();
        }
    }
}

