/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.validation.factory;

import com.avaje.ebean.validation.Range;
import com.avaje.ebean.validation.factory.Validator;
import com.avaje.ebean.validation.factory.ValidatorFactory;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeValidatorFactory
implements ValidatorFactory {
    private static final Map<String, Validator> cache = new HashMap<String, Validator>();

    @Override
    public Validator create(Annotation annotation, Class<?> type) {
        Range range = (Range)annotation;
        return this.create(range.min(), range.max(), type);
    }

    public synchronized Validator create(long min2, long max, Class<?> type) {
        String key = type + ":" + min2 + ":" + max;
        Validator validator = cache.get(key);
        if (validator != null) {
            return validator;
        }
        if (type.equals(String.class)) {
            validator = new StringValidator(min2, max);
        } else if (RangeValidatorFactory.useDouble(type)) {
            validator = new DoubleValidator(min2, max);
        } else if (RangeValidatorFactory.useLong(type)) {
            validator = new LongValidator(min2, max);
        } else {
            String msg = "@Range annotation not assignable to type " + type;
            throw new RuntimeException(msg);
        }
        cache.put(key, validator);
        return validator;
    }

    private static boolean useLong(Class<?> type) {
        if (type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Short.TYPE)) {
            return true;
        }
        return Number.class.isAssignableFrom(type);
    }

    private static boolean useDouble(Class<?> type) {
        if (type.equals(Float.TYPE) || type.equals(Double.TYPE)) {
            return true;
        }
        if (type.equals(BigDecimal.class)) {
            return true;
        }
        if (Double.class.isAssignableFrom(type)) {
            return true;
        }
        return Float.class.isAssignableFrom(type);
    }

    private static class StringValidator
    extends DoubleValidator {
        private StringValidator(long min2, long max) {
            super(min2, max);
        }

        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            BigDecimal bd = new BigDecimal((String)value);
            double dv = bd.doubleValue();
            return dv >= (double)this.min && dv <= (double)this.max;
        }
    }

    private static class LongValidator
    extends DoubleValidator {
        private LongValidator(long min2, long max) {
            super(min2, max);
        }

        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            Number n = (Number)value;
            long lv = n.longValue();
            return lv >= this.min && lv <= this.max;
        }
    }

    private static class DoubleValidator
    implements Validator {
        final long min;
        final long max;
        final String key;
        final Object[] attributes;

        private DoubleValidator(long min2, long max) {
            this.min = min2;
            this.max = max;
            this.key = this.determineKey(min2, max);
            this.attributes = this.determineAttributes(min2, max);
        }

        private String determineKey(long min2, long max) {
            if (min2 > Long.MIN_VALUE && max < Long.MAX_VALUE) {
                return "range.minmax";
            }
            if (min2 > Long.MIN_VALUE) {
                return "range.min";
            }
            return "range.max";
        }

        private Object[] determineAttributes(long min2, long max) {
            if (min2 > Long.MIN_VALUE && max < Long.MAX_VALUE) {
                return new Object[]{min2, max};
            }
            if (min2 > Long.MIN_VALUE) {
                return new Object[]{min2};
            }
            return new Object[]{max};
        }

        public Object[] getAttributes() {
            return this.attributes;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isValid(Object value) {
            if (value == null) {
                return true;
            }
            Number n = (Number)value;
            double dv = n.doubleValue();
            return dv >= (double)this.min && dv <= (double)this.max;
        }

        public String toString() {
            return this.getClass().getName() + "key:" + this.key + " min:" + this.min + " max:" + this.max;
        }
    }
}

