/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.text;

import com.avaje.ebean.text.StringParser;
import java.sql.Time;

public final class TimeStringParser
implements StringParser {
    private static final TimeStringParser SHARED = new TimeStringParser();

    public static TimeStringParser get() {
        return SHARED;
    }

    public Object parse(String value) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        String s2 = value.trim();
        int firstColon = s2.indexOf(58);
        int secondColon = s2.indexOf(58, firstColon + 1);
        if (firstColon == -1) {
            throw new IllegalArgumentException("No ':' in value [" + s2 + "]");
        }
        try {
            int second;
            int minute;
            int hour = Integer.parseInt(s2.substring(0, firstColon));
            if (secondColon == -1) {
                minute = Integer.parseInt(s2.substring(firstColon + 1, s2.length()));
                second = 0;
            } else {
                minute = Integer.parseInt(s2.substring(firstColon + 1, secondColon));
                second = Integer.parseInt(s2.substring(secondColon + 1));
            }
            return new Time(hour, minute, second);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Number format Error parsing time [" + s2 + "] " + e.getMessage(), e);
        }
    }
}

