/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.managers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import voiidstudios.vct.VoiidCountdownTimer;

public class TranslationManager {
    private final VoiidCountdownTimer plugin;
    private FileConfiguration jarLangBase;
    private FileConfiguration langBase;
    private FileConfiguration langSelected;
    private FileConfiguration langSelectedCustom;
    private FileConfiguration langCustomOverrides;
    private String currentLang = "en_US";

    public TranslationManager(VoiidCountdownTimer plugin) {
        this.plugin = plugin;
    }

    public void loadLanguage(String langCode) {
        this.currentLang = langCode;
        this.jarLangBase = this.loadYamlFromResource("core/messages/origins/en_US.yml");
        this.ensureDataFileExists("core/messages/origins/en_US.yml");
        this.langBase = this.loadYaml("core/messages/origins/en_US.yml");
        this.langSelected = this.loadYaml("core/messages/origins/" + langCode + ".yml");
        this.langSelectedCustom = this.loadYaml("core/messages/custom/" + langCode + ".yml");
        this.langCustomOverrides = this.loadYaml("core/messages/custom/custom.yml");
        this.syncMissingKeys();
    }

    private void ensureDataFileExists(String resourcePath) {
        InputStream is;
        File dest = new File(this.plugin.getDataFolder(), resourcePath);
        if (!dest.exists() && (is = this.plugin.getResource(resourcePath)) != null) {
            dest.getParentFile().mkdirs();
            try (InputStream in = is;
                 FileOutputStream out = new FileOutputStream(dest);){
                int read;
                byte[] buffer = new byte[4096];
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Could not copy resource to data folder: " + resourcePath);
            }
        }
    }

    private FileConfiguration loadYaml(String path) {
        File file = new File(this.plugin.getDataFolder(), path);
        if (!file.exists()) {
            return new YamlConfiguration();
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    private FileConfiguration loadYamlFromResource(String resourcePath) {
        YamlConfiguration yamlConfiguration;
        InputStream is = this.plugin.getResource(resourcePath);
        if (is == null) {
            return new YamlConfiguration();
        }
        InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);
        try {
            yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to load resource language file: " + resourcePath);
                return new YamlConfiguration();
            }
        }
        reader.close();
        return yamlConfiguration;
    }

    public void syncMissingKeys() {
        Object value;
        if (this.jarLangBase == null) {
            return;
        }
        if (this.langSelected == null) {
            this.langSelected = new YamlConfiguration();
        }
        if (this.langBase == null) {
            this.langBase = new YamlConfiguration();
        }
        File selectedFile = new File(this.plugin.getDataFolder(), "core/messages/origins/" + this.currentLang + ".yml");
        File baseFile = new File(this.plugin.getDataFolder(), "core/messages/origins/en_US.yml");
        boolean changedSelected = false;
        boolean changedBase = false;
        for (String key : this.jarLangBase.getKeys(true)) {
            value = this.jarLangBase.get(key);
            if (!this.langSelected.contains(key)) {
                this.langSelected.set(key, value);
                changedSelected = true;
                this.plugin.getLogger().info("Added missing translation key to " + this.currentLang + ": " + key);
            }
            if (this.langBase.contains(key)) continue;
            this.langBase.set(key, value);
            changedBase = true;
            this.plugin.getLogger().info("Added missing base translation key: " + key);
        }
        for (String key : this.langSelected.getKeys(true)) {
            if (this.jarLangBase.contains(key) || this.langBase.contains(key)) continue;
            value = this.langSelected.get(key);
            this.langBase.set(key, value);
            changedBase = true;
            this.plugin.getLogger().info("Propagated custom key from " + this.currentLang + " to base: " + key);
        }
        try {
            if (changedSelected) {
                if (!selectedFile.getParentFile().exists()) {
                    selectedFile.getParentFile().mkdirs();
                }
                this.langSelected.save(selectedFile);
            }
            if (changedBase) {
                if (!baseFile.getParentFile().exists()) {
                    baseFile.getParentFile().mkdirs();
                }
                this.langBase.save(baseFile);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save language files during sync.");
            e.printStackTrace();
        }
    }

    public String get(String key) {
        return this.getFromConfigurations(key, this.getBaseSources());
    }

    public List<String> getStringList(String key) {
        return this.asStringList(key, this.getBaseSources());
    }

    public String formatKey(String key, Map<String, String> placeholders) {
        String raw = this.get(key);
        if (raw == null) {
            return null;
        }
        return this.formatRaw(raw, placeholders);
    }

    public String formatRaw(String raw, Map<String, String> placeholders) {
        if (raw == null) {
            return null;
        }
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace(e.getKey(), e.getValue());
            }
        }
        return raw;
    }

    public void ensureExists(String key, String defaultValue) {
        boolean changed = false;
        if (this.langBase != null && !this.langBase.contains(key)) {
            this.langBase.set(key, (Object)defaultValue);
            changed = true;
        }
        if (this.langSelected != null && !this.langSelected.contains(key)) {
            this.langSelected.set(key, (Object)defaultValue);
            changed = true;
        }
        if (changed && this.langSelected != null) {
            try {
                this.langSelected.save(new File(this.plugin.getDataFolder(), "core/messages/origins/" + this.currentLang + ".yml"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getCurrentLanguage() {
        return this.currentLang;
    }

    private List<FileConfiguration> getBaseSources() {
        ArrayList<FileConfiguration> sources = new ArrayList<FileConfiguration>();
        this.addIfNotEmpty(this.langCustomOverrides, sources);
        this.addIfNotEmpty(this.langSelectedCustom, sources);
        this.addIfNotEmpty(this.langSelected, sources);
        this.addIfNotEmpty(this.langBase, sources);
        return sources;
    }

    private void addIfNotEmpty(FileConfiguration config, List<FileConfiguration> list) {
        if (config == null || config.getKeys(true).isEmpty()) {
            return;
        }
        list.add(config);
    }

    private List<String> asStringList(String key, List<FileConfiguration> sources) {
        for (FileConfiguration source : sources) {
            if (!source.isList(key)) continue;
            return source.getStringList(key);
        }
        String raw = this.getFromConfigurations(key, sources);
        if (raw == null) {
            return Collections.emptyList();
        }
        if (!raw.contains("\n")) {
            return Collections.singletonList(raw);
        }
        return Arrays.asList(raw.split("\n"));
    }

    private String getFromConfigurations(String key, List<FileConfiguration> sources) {
        for (FileConfiguration config : sources) {
            if (!config.contains(key)) continue;
            return config.getString(key);
        }
        return null;
    }

    public TranslationBundle forCustomNamespace(String namespace) {
        return new TranslationBundle(namespace);
    }

    public class TranslationBundle {
        private final String namespace;
        private FileConfiguration namespacedSelected;
        private FileConfiguration namespacedDefault;
        private String lastLang;

        private TranslationBundle(String namespace) {
            this.namespace = namespace == null ? "" : namespace.trim();
            this.reload();
        }

        public void reload() {
            this.lastLang = TranslationManager.this.currentLang;
            if (this.namespace.isEmpty()) {
                this.namespacedSelected = new YamlConfiguration();
                this.namespacedDefault = new YamlConfiguration();
                return;
            }
            this.namespacedSelected = TranslationManager.this.loadYaml("core/messages/custom/" + this.namespace + "/" + TranslationManager.this.currentLang + ".yml");
            this.namespacedDefault = TranslationManager.this.loadYaml("core/messages/custom/" + this.namespace + "/en_US.yml");
        }

        public String get(String key) {
            List<FileConfiguration> sources = this.getNamespacedSources();
            return TranslationManager.this.getFromConfigurations(key, sources);
        }

        public List<String> getStringList(String key) {
            return TranslationManager.this.asStringList(key, this.getNamespacedSources());
        }

        public String formatKey(String key, Map<String, String> placeholders) {
            return this.formatRaw(this.get(key), placeholders);
        }

        public String formatRaw(String raw, Map<String, String> placeholders) {
            if (raw == null) {
                return null;
            }
            if (placeholders != null) {
                for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                    raw = raw.replace(entry.getKey(), entry.getValue());
                }
            }
            return raw;
        }

        private List<FileConfiguration> getNamespacedSources() {
            if (!Objects.equals(this.lastLang, TranslationManager.this.currentLang)) {
                this.reload();
            }
            ArrayList<FileConfiguration> sources = new ArrayList<FileConfiguration>();
            TranslationManager.this.addIfNotEmpty(TranslationManager.this.langCustomOverrides, sources);
            TranslationManager.this.addIfNotEmpty(this.namespacedSelected, sources);
            TranslationManager.this.addIfNotEmpty(this.namespacedDefault, sources);
            return sources;
        }
    }
}

