/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.managers;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.utils.ServerCompatibility;

public class DynamicsManager {
    public static final String DYNAMIC_KEY = "dynamic";
    public static final String DYNAMIC_GRAD_KEY = "dynamic-g";
    public static final String DYNAMIC_GRAD_L_KEY = "dynamic-g-l";
    public static final String NEG_DYNAMIC_KEY = "-dynamic";
    public static final String NEG_DYNAMIC_GRAD_KEY = "-dynamic-g";
    private static final int maxIndex = 10;
    private int mmIndex = 10;
    private BigDecimal miniGradientIndexBD = new BigDecimal("-1.0");
    private BigDecimal miniGradientIndexBDL = new BigDecimal("-1.0");
    private boolean miniGradientIncL = true;
    private final BigDecimal stepBD = new BigDecimal("0.1");
    private final BigDecimal one = new BigDecimal("1.0");
    private final BigDecimal minusOne = new BigDecimal("-1.0");
    private final Map<String, String> formattedDynamicsValues = new ConcurrentHashMap<String, String>();
    private final DecimalFormat decimalFormat;
    private final VoiidCountdownTimer plugin;
    private Object task;

    public DynamicsManager(VoiidCountdownTimer plugin) {
        this.plugin = plugin;
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        this.decimalFormat = new DecimalFormat("#.#", symbols);
        this.decimalFormat.setRoundingMode(RoundingMode.DOWN);
        this.startIndexTask();
    }

    private void startIndexTask() {
        Runnable runnable = () -> {
            --this.mmIndex;
            if (this.mmIndex == 1) {
                this.mmIndex = 10;
            }
            this.miniGradientIndexBD = this.miniGradientIndexBD.add(this.stepBD);
            if (this.miniGradientIndexBD.compareTo(this.one) > 0) {
                this.miniGradientIndexBD = new BigDecimal("-1.0");
            }
            if (this.miniGradientIncL) {
                this.miniGradientIndexBDL = this.miniGradientIndexBDL.add(this.stepBD);
                if (this.miniGradientIndexBDL.compareTo(this.one) >= 0) {
                    this.miniGradientIndexBDL = this.one;
                    this.miniGradientIncL = false;
                }
            } else {
                this.miniGradientIndexBDL = this.miniGradientIndexBDL.subtract(this.stepBD);
                if (this.miniGradientIndexBDL.compareTo(this.minusOne) <= 0) {
                    this.miniGradientIndexBDL = this.minusOne;
                    this.miniGradientIncL = true;
                }
            }
            this.updateFormattedDynamicsValues();
        };
        this.task = ServerCompatibility.isFolia() ? Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> runnable.run(), 1L, 1L) : this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, 0L, 1L);
    }

    private void updateFormattedDynamicsValues() {
        String mmIndexStr = Integer.toString(this.mmIndex);
        String phaseMmGStr = this.decimalFormat.format(this.miniGradientIndexBD);
        String phaseMmGLStr = this.decimalFormat.format(this.miniGradientIndexBDL);
        String negMmIndexStr = Integer.toString(10 - this.mmIndex);
        String negPhaseMmGStr = this.decimalFormat.format(this.miniGradientIndexBD.multiply(this.minusOne));
        this.formattedDynamicsValues.put(DYNAMIC_KEY, mmIndexStr);
        this.formattedDynamicsValues.put(DYNAMIC_GRAD_KEY, phaseMmGStr);
        this.formattedDynamicsValues.put(DYNAMIC_GRAD_L_KEY, phaseMmGLStr);
        this.formattedDynamicsValues.put(NEG_DYNAMIC_KEY, negMmIndexStr);
        this.formattedDynamicsValues.put(NEG_DYNAMIC_GRAD_KEY, negPhaseMmGStr);
    }

    public String formatPhases(String value) {
        return value.replace("#dynamic-g#", this.formattedDynamicsValues.getOrDefault(DYNAMIC_GRAD_KEY, "")).replace("#dynamic-g-l#", this.formattedDynamicsValues.getOrDefault(DYNAMIC_GRAD_L_KEY, "")).replace("#-dynamic-g#", this.formattedDynamicsValues.getOrDefault(NEG_DYNAMIC_GRAD_KEY, "")).replace("#dynamic#", this.formattedDynamicsValues.getOrDefault(DYNAMIC_KEY, "")).replace("#-dynamic#", this.formattedDynamicsValues.getOrDefault(NEG_DYNAMIC_KEY, ""));
    }
}

