/*
 * Decompiled with CFR 0.152.
 */
package voiidstudios.vct.api;

import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import voiidstudios.vct.VoiidCountdownTimer;
import voiidstudios.vct.api.VCTEvent;
import voiidstudios.vct.configs.model.TimerConfig;
import voiidstudios.vct.managers.TimerManager;
import voiidstudios.vct.utils.Formatter;

public class Timer
implements Runnable {
    private int seconds;
    private final BossBar bossbar;
    private BukkitTask task;
    private boolean hasSound;
    private String soundFinalName;
    public float soundVolume;
    public float soundPitch;
    private String timerText;
    private int initialSeconds;
    private int refreshInterval;
    private final int maxValue = 359999;
    private final int minValue = 0;
    private final String timerId;

    public Timer(int seconds, String timeText, String timeSound, BarColor barcolor, BarStyle barstyle, String timerId, boolean hasSoundd, float soundVolumee, float soundPitchh) {
        this.seconds = seconds;
        this.initialSeconds = seconds;
        this.timerId = timerId;
        this.refreshInterval = VoiidCountdownTimer.getConfigsManager().getMainConfigManager().getRefresh_ticks();
        this.hasSound = hasSoundd;
        this.timerText = timeText;
        this.soundFinalName = timeSound;
        this.soundVolume = soundVolumee;
        this.soundPitch = soundPitchh;
        this.bossbar = Bukkit.createBossBar((String)"", (BarColor)barcolor, (BarStyle)barstyle, (BarFlag[])new BarFlag[0]);
    }

    public int getInitialSeconds() {
        return this.initialSeconds;
    }

    public int getRemainingSeconds() {
        return this.seconds;
    }

    public String getTimertext() {
        return this.timerText;
    }

    public String getTimertextFormated() {
        return this.timerText.replace("%HH%", this.formatTimeHH(this.seconds)).replace("%MM%", this.formatTimeMM(this.seconds)).replace("%SS%", this.formatTimeSS(this.seconds)).replace("%H1%", this.getTimeLeftHHDigit1()).replace("%H2%", this.getTimeLeftHHDigit2()).replace("%M1%", this.getTimeLeftMMDigit1()).replace("%M2%", this.getTimeLeftMMDigit2()).replace("%S1%", this.getTimeLeftSSDigit1()).replace("%S2%", this.getTimeLeftSSDigit2());
    }

    public static void playSound(Player player, String actionLine) {
        String[] sep = actionLine.split(";");
        String soundName = sep[0];
        float volume = Float.parseFloat(sep[1]);
        float pitch = Float.parseFloat(sep[2]);
        boolean success = false;
        try {
            Sound sound = Sound.valueOf((String)soundName.toUpperCase());
            player.playSound(player.getLocation(), sound, volume, pitch);
            success = true;
        }
        catch (IllegalArgumentException ignored) {
            try {
                player.playSound(player.getLocation(), soundName, volume, pitch);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!success) {
            Bukkit.getLogger().warning("[TuPlugin] No se pudo reproducir el sonido: " + soundName);
        }
    }

    private void updateBossBarTitle(String phasesText) {
        Object formatted;
        block14: {
            Formatter formatter = VoiidCountdownTimer.getConfigsManager().getMainConfigManager().getFormatter();
            formatted = formatter.format(VoiidCountdownTimer.getInstance(), (CommandSender)Bukkit.getConsoleSender(), phasesText);
            try {
                Class<?> componentClass = null;
                try {
                    componentClass = Class.forName("net.kyori.adventure.text.Component");
                }
                catch (ClassNotFoundException ignored) {
                    componentClass = null;
                }
                if (componentClass == null || !componentClass.isInstance(formatted)) break block14;
                try {
                    this.bossbar.getClass().getMethod("setTitle", componentClass).invoke((Object)this.bossbar, formatted);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException ignored) {
                    try {
                        Object serializer;
                        Class<?> legacyCls = Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer");
                        try {
                            serializer = legacyCls.getMethod("legacySection", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (NoSuchMethodException nsme) {
                            Class<?> builderPublicClass = Class.forName("net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer$Builder");
                            Object builder = legacyCls.getMethod("builder", new Class[0]).invoke(null, new Object[0]);
                            builderPublicClass.getMethod("character", Character.TYPE).invoke(builder, Character.valueOf('&'));
                            try {
                                builderPublicClass.getMethod("hexColors", new Class[0]).invoke(builder, new Object[0]);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                            serializer = builderPublicClass.getMethod("build", new Class[0]).invoke(builder, new Object[0]);
                        }
                        String legacyTitle = (String)legacyCls.getMethod("serialize", componentClass).invoke(serializer, formatted);
                        this.bossbar.setTitle(legacyTitle);
                        return;
                    }
                    catch (Throwable throwable) {
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (formatted instanceof String) {
            this.bossbar.setTitle(((String)formatted).replace('&', '\u00a7'));
        } else {
            this.bossbar.setTitle(phasesText.replace('&', '\u00a7'));
        }
    }

    private void startTask(int seconds) {
        int increment = -1;
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)VoiidCountdownTimer.getInstance(), new Runnable(){
            private int tickCounter = 0;
            private int refreshCounter = 0;

            @Override
            public void run() {
                ++this.tickCounter;
                ++this.refreshCounter;
                if (this.tickCounter >= 20) {
                    this.tickCounter = 0;
                    Timer.this.seconds += -1;
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        Timer.this.bossbar.addPlayer(player);
                        if (!Timer.this.hasSound || Timer.this.soundFinalName == null) continue;
                        Timer.playSound(player, Timer.this.soundFinalName + ";" + Timer.this.soundVolume + ";" + Timer.this.soundPitch);
                    }
                    Bukkit.getPluginManager().callEvent((Event)new VCTEvent(Timer.this, VCTEvent.VCTEventType.CHANGE, null));
                }
                if (this.refreshCounter >= Timer.this.refreshInterval) {
                    this.refreshCounter = 0;
                    String rawText = Timer.this.getTimertextFormated();
                    String phasesText = VoiidCountdownTimer.getPhasesManager().formatPhases(rawText);
                    Timer.this.updateBossBarTitle(phasesText);
                    double progress = (double)Timer.this.seconds / (double)Timer.this.initialSeconds;
                    progress = Math.max(0.0, Math.min(1.0, progress));
                    Timer.this.bossbar.setProgress(progress);
                }
                if (Timer.this.seconds <= 0) {
                    if (Timer.this.task != null) {
                        Timer.this.task.cancel();
                    }
                    Bukkit.getPluginManager().callEvent((Event)new VCTEvent(Timer.this, VCTEvent.VCTEventType.FINISH, null));
                    Bukkit.getScheduler().runTaskLater((Plugin)VoiidCountdownTimer.getInstance(), () -> {
                        if (Timer.this.bossbar != null) {
                            Timer.this.bossbar.removeAll();
                        }
                    }, (long)VoiidCountdownTimer.getConfigsManager().getMainConfigManager().getTicks_hide_after_ending());
                }
            }
        }, 1L, 1L);
    }

    public static void refreshTimerText() {
        Timer current;
        block10: {
            current = TimerManager.getInstance().getTimer();
            if (current == null) {
                return;
            }
            current.refreshInterval = VoiidCountdownTimer.getConfigsManager().getMainConfigManager().getRefresh_ticks();
            if (current.timerId != null) {
                try {
                    TimerConfig cfg = VoiidCountdownTimer.getConfigsManager().getTimerConfig(current.timerId);
                    if (cfg == null || !cfg.isEnabled()) break block10;
                    current.timerText = cfg.getText();
                    current.hasSound = cfg.isSoundEnabled();
                    current.soundVolume = cfg.getSoundVolume();
                    current.soundPitch = cfg.getSoundPitch();
                    try {
                        current.soundFinalName = cfg.getSound();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        current.bossbar.setColor(cfg.getColor());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                catch (Throwable cfg) {
                    // empty catch block
                }
            }
        }
        current.timerText = "%HH%:%MM%:%SS%";
        current.soundFinalName = "UI_BUTTON_CLICK";
        current.hasSound = false;
        current.soundVolume = 1.0f;
        current.soundPitch = 1.0f;
        try {
            BarColor color = BarColor.WHITE;
            current.bossbar.setColor(color);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setBossBarColor(BarColor color) {
        this.bossbar.setColor(color);
    }

    public void setBossBarStyle(BarStyle style) {
        this.bossbar.setStyle(style);
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    private String[] splitDigits(String value) {
        if (value == null || value.length() < 2) {
            return new String[]{"0", "0"};
        }
        return new String[]{String.valueOf(value.charAt(0)), String.valueOf(value.charAt(1))};
    }

    private String formatTime(long time) {
        long hours = time / 3600L;
        long minutes = time % 3600L / 60L;
        long seconds = time % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    private String formatTimeHH(long time) {
        long hours = time / 3600L;
        return String.format("%02d", hours);
    }

    private String formatTimeMM(long time) {
        long minutes = time % 3600L / 60L;
        return String.format("%02d", minutes);
    }

    private String formatTimeSS(long time) {
        long seconds = time % 60L;
        return String.format("%02d", seconds);
    }

    public String getTimerId() {
        return this.timerId;
    }

    public String getInitialTime() {
        return this.formatTime(this.initialSeconds);
    }

    public String getTimeLeft() {
        return this.formatTime(this.seconds);
    }

    public String getTimeLeftHH() {
        return this.formatTimeHH(this.seconds);
    }

    public String getTimeLeftHHDigit1() {
        return this.splitDigits(this.formatTimeHH(this.seconds))[0];
    }

    public String getTimeLeftHHDigit2() {
        return this.splitDigits(this.formatTimeHH(this.seconds))[1];
    }

    public String getTimeLeftMM() {
        return this.formatTimeMM(this.seconds);
    }

    public String getTimeLeftMMDigit1() {
        return this.splitDigits(this.formatTimeMM(this.seconds))[0];
    }

    public String getTimeLeftMMDigit2() {
        return this.splitDigits(this.formatTimeMM(this.seconds))[1];
    }

    public String getTimeLeftSS() {
        return this.formatTimeSS(this.seconds);
    }

    public String getTimeLeftSSDigit1() {
        return this.splitDigits(this.formatTimeSS(this.seconds))[0];
    }

    public String getTimeLeftSSDigit2() {
        return this.splitDigits(this.formatTimeSS(this.seconds))[1];
    }

    public boolean isActive() {
        return this.task != null;
    }

    public boolean isPaused() {
        return this.task == null && this.seconds > 0;
    }

    public void start() {
        this.startTask(this.seconds);
    }

    public void stop() {
        if (this.task != null) {
            Bukkit.getPluginManager().callEvent((Event)new VCTEvent(this, VCTEvent.VCTEventType.STOP, null));
            this.task.cancel();
        }
        if (this.bossbar != null) {
            this.bossbar.removeAll();
        }
    }

    public void add(int addSeconds) {
        if (this.seconds + addSeconds > this.maxValue) {
            this.seconds = this.maxValue;
            this.initialSeconds = this.maxValue;
        } else {
            this.seconds += addSeconds;
            this.initialSeconds += addSeconds;
        }
    }

    public void set(int setSeconds) {
        if (setSeconds > this.maxValue) {
            this.seconds = this.maxValue;
            this.initialSeconds = this.maxValue;
        } else if (setSeconds < this.minValue) {
            this.seconds = this.minValue;
            this.initialSeconds = this.minValue;
        } else {
            this.seconds = setSeconds;
            this.initialSeconds = setSeconds;
        }
    }

    public void take(int takeSeconds) {
        if (this.seconds - takeSeconds >= this.minValue) {
            this.seconds -= takeSeconds;
            this.initialSeconds -= takeSeconds;
        }
    }

    public void pause() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    public void resume() {
        if (this.task == null) {
            this.startTask(this.seconds);
        }
    }

    @Override
    public void run() {
        --this.seconds;
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.bossbar.addPlayer(player);
        }
        if (this.seconds == 0) {
            if (this.task != null) {
                Bukkit.getScheduler().cancelTask(this.task.getTaskId());
            }
            this.bossbar.removeAll();
            TimerManager.getInstance().removeTimer();
        }
    }
}

