/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.util;

import com.viaversion.viarewind.legacysupport.BukkitPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ReflectionUtil {
    private static final Map<String, Field> fieldCache = new HashMap<String, Field>();
    private static boolean staticFinalModificationBlocked;

    public static Method findMethod(Class<?> clazz, String[] methodNames, Class<?> ... parameterTypes) {
        for (String methodName : methodNames) {
            Method method = ReflectionUtil.getMethod(clazz, methodName, parameterTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                return null;
            }
            return ReflectionUtil.getMethod(superClass, methodName, parameterTypes);
        }
    }

    public static Field getFieldAndCache(Class<?> clazz, String fieldName) {
        String key = clazz.getName() + ":" + fieldName;
        if (fieldCache.containsKey(key)) {
            return fieldCache.get(key);
        }
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        fieldCache.put(key, field);
        return field;
    }

    public static Field getFieldAccessible(Class<?> clazz, String fieldName) {
        Field field = ReflectionUtil.getFieldAndCache(clazz, fieldName);
        if (field != null) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Field failSafeGetField(Class<?> clazz, String fieldName) {
        try {
            return ReflectionUtil.getFieldAccessible(clazz, fieldName);
        }
        catch (Exception e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to get field " + fieldName + " in class " + clazz.getName(), e);
            return null;
        }
    }

    public static void setValue(Class<?> clazz, Object object, String name, Object value, boolean isFinal) throws IllegalAccessException {
        Field field = ReflectionUtil.getFieldAccessible(clazz, name);
        if (isFinal) {
            ReflectionUtil.removeFinal(field);
        }
        field.set(object, value);
    }

    public static void removeFinal(Field field) {
        int modifiers = field.getModifiers();
        if (!Modifier.isFinal(modifiers)) {
            return;
        }
        if (!staticFinalModificationBlocked) {
            ReflectionUtil.failSafeSetValue(Field.class, field, "modifiers", modifiers & 0xFFFFFFEF);
            return;
        }
        try {
            Field[] fields;
            Method getDeclaredFields0 = Class.class.getDeclaredMethod("getDeclaredFields0", Boolean.TYPE);
            getDeclaredFields0.setAccessible(true);
            for (Field classField : fields = (Field[])getDeclaredFields0.invoke(Field.class, false)) {
                if (!"modifiers".equals(classField.getName())) continue;
                classField.setAccessible(true);
                classField.set(field, modifiers & 0xFFFFFFEF);
                break;
            }
        }
        catch (ReflectiveOperationException e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to remove final modifier from field " + field.getName(), e);
        }
    }

    public static void setValue(Class<?> clazz, Object object, String name, Object value) throws IllegalAccessException {
        ReflectionUtil.setValue(clazz, object, name, value, false);
    }

    public static void failSafeSetValue(Class<?> clazz, Object object, String name, Object value) {
        try {
            ReflectionUtil.setValue(clazz, object, name, value);
        }
        catch (Exception e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to set value for field " + name + " in class " + clazz.getName(), e);
        }
    }

    public static Class<?> failSafeGetClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to get class " + name, e);
            return null;
        }
    }

    static {
        try {
            Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException ex) {
            staticFinalModificationBlocked = true;
        }
    }
}

