/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.feature;

import com.viaversion.viarewind.legacysupport.BukkitPlugin;
import com.viaversion.viarewind.legacysupport.util.NMSUtil;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.plugin.Plugin;

public class AreaEffectCloudEmulator
implements Listener {
    private final ArrayList<AreaEffectCloud> effectClouds = new ArrayList();

    public AreaEffectCloudEmulator(BukkitPlugin plugin) {
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
            Set affectedPlayers = Bukkit.getOnlinePlayers().stream().filter(p -> Via.getAPI().getPlayerProtocolVersion(p).olderThanOrEqualTo(ProtocolVersion.v1_8)).collect(Collectors.toSet());
            this.effectClouds.removeIf(e -> !e.isValid());
            this.effectClouds.forEach(cloud -> {
                Location location = cloud.getLocation();
                float radius = cloud.getRadius();
                Color data = NMSUtil.NEWER_THAN_V1_20_5 ? cloud.getColor() : null;
                float area = (float)Math.PI * radius * radius;
                int i = 0;
                while ((float)i < area) {
                    float f1 = (float)Math.random() * ((float)Math.PI * 2);
                    float f2 = (float)Math.sqrt(Math.random()) * radius;
                    float f3 = (float)Math.cos(f1) * f2;
                    float f6 = (float)Math.sin(f1) * f2;
                    if (cloud.getParticle() == Particle.SPELL_MOB) {
                        int color = cloud.getColor().asRGB();
                        int r = color >> 16 & 0xFF;
                        int g = color >> 8 & 0xFF;
                        int b = color & 0xFF;
                        affectedPlayers.stream().filter(player -> player.getWorld() == location.getWorld()).forEach(player -> player.spawnParticle(cloud.getParticle(), location.getX() + (double)f3, location.getY(), location.getZ() + (double)f6, 0, (double)((float)r / 255.0f), (double)((float)g / 255.0f), (double)((float)b / 255.0f), data));
                    }
                    ++i;
                }
            });
        }, 1L, 1L);
    }

    @EventHandler
    public void onEntitySpawn(LingeringPotionSplashEvent e) {
        this.effectClouds.add(e.getAreaEffectCloud());
    }
}

