/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.util;

import com.viaversion.viarewind.legacysupport.BukkitPlugin;
import com.viaversion.viarewind.legacysupport.util.ReflectionUtil;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NMSUtil {
    public static final boolean NEWER_THAN_V1_20_5 = BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_20_5);
    public static String nmsVersionPackage;
    private static Field playerConnectionField;

    public static Class<?> getBlockPositionClass() {
        if (BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            return ReflectionUtil.failSafeGetClass("net.minecraft.core.BlockPosition");
        }
        return NMSUtil.getLegacyNMSClass("BlockPosition");
    }

    public static Class<?> getNMSBlockClass(String name) {
        if (BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            return ReflectionUtil.failSafeGetClass("net.minecraft.world.level.block." + name);
        }
        return NMSUtil.getLegacyNMSClass(name);
    }

    public static Class getSoundCategoryClass() {
        if (BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            return ReflectionUtil.failSafeGetClass("net.minecraft.sounds.SoundCategory");
        }
        return NMSUtil.getLegacyNMSClass("SoundCategory");
    }

    public static Class<?> getPacketClass() {
        if (BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            return ReflectionUtil.failSafeGetClass("net.minecraft.network.protocol.Packet");
        }
        return NMSUtil.getLegacyNMSClass("Packet");
    }

    public static Class<?> getGamePacketClass(String packet) {
        if (BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            return ReflectionUtil.failSafeGetClass("net.minecraft.network.protocol.game." + packet);
        }
        return NMSUtil.getLegacyNMSClass(packet);
    }

    public static Class<?> getPlayerConnectionClass() {
        if (BukkitPlugin.getInstance().getServerProtocol().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            return ReflectionUtil.failSafeGetClass("net.minecraft.server.network.PlayerConnection");
        }
        return NMSUtil.getLegacyNMSClass("PlayerConnection");
    }

    public static Object getNMSPlayer(Player player) {
        try {
            return player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to get EntityPlayer from player", e);
            return null;
        }
    }

    public static void sendPacket(Player player, Object packet) {
        Object playerConnection;
        Object nmsPlayer = NMSUtil.getNMSPlayer(player);
        if (nmsPlayer == null) {
            return;
        }
        if (playerConnectionField == null) {
            playerConnection = NMSUtil.getPlayerConnectionClass();
            for (Field field : nmsPlayer.getClass().getFields()) {
                if (field.getType() != playerConnection) continue;
                playerConnectionField = field;
                break;
            }
            if (playerConnectionField == null) {
                BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to find PlayerConnection field in EntityPlayer");
                return;
            }
        }
        try {
            playerConnection = playerConnectionField.get(nmsPlayer);
        }
        catch (IllegalAccessException e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to get PlayerConnection from EntityPlayer", e);
            return;
        }
        try {
            Method sendPacket = ReflectionUtil.findMethod(playerConnection.getClass(), new String[]{"sendPacket", "a"}, NMSUtil.getPacketClass());
            sendPacket.invoke(playerConnection, packet);
        }
        catch (IllegalAccessException | NullPointerException | InvocationTargetException e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Failed to send packet to player", e);
        }
    }

    public static Class<?> getLegacyNMSClass(String name) {
        try {
            return Class.forName("net.minecraft.server." + nmsVersionPackage + "." + name);
        }
        catch (ClassNotFoundException e) {
            BukkitPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not find NMS class " + name + "! NMS version package: " + nmsVersionPackage, e);
            return null;
        }
    }

    static {
        if (BukkitPlugin.getInstance().getServerProtocol().olderThan(ProtocolVersion.v1_17)) {
            nmsVersionPackage = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        }
    }
}

