/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.feature;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class EnchantingGuiEmulator
implements Listener {
    private final boolean newMaterialNames = Material.getMaterial((String)"LAPIS_LAZULI") != null;
    private final Material lapisMaterial = this.newMaterialNames ? Material.LAPIS_LAZULI : Material.getMaterial((String)"INK_SACK");

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent e) {
        if (!(e.getInventory() instanceof EnchantingInventory)) {
            return;
        }
        Player player = (Player)e.getPlayer();
        if (Via.getAPI().getPlayerProtocolVersion((Object)player).newerThanOrEqualTo(ProtocolVersion.v1_8)) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        ItemStack lapis = this.newMaterialNames ? new ItemStack(this.lapisMaterial) : new ItemStack(this.lapisMaterial, 1, 4);
        int amount = 0;
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || !item.isSimilar(lapis)) continue;
            if (amount + item.getAmount() > 64) {
                item.setAmount(amount + item.getAmount() - 64);
                amount = 64;
            } else {
                amount += item.getAmount();
                item = new ItemStack(Material.AIR);
            }
            inv.setItem(i, item);
            if (amount == 64) break;
        }
        if (amount == 0) {
            return;
        }
        EnchantingInventory replacement = (EnchantingInventory)e.getInventory();
        lapis.setAmount(amount);
        replacement.setSecondary(lapis);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent e) {
        if (!(e.getInventory() instanceof EnchantingInventory)) {
            return;
        }
        Player player = (Player)e.getPlayer();
        if (Via.getAPI().getPlayerProtocolVersion((Object)player).newerThanOrEqualTo(ProtocolVersion.v1_8)) {
            return;
        }
        PlayerInventory inv = player.getInventory();
        EnchantingInventory replacement = (EnchantingInventory)e.getInventory();
        ItemStack item = replacement.getSecondary();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        replacement.setSecondary(new ItemStack(Material.AIR));
        HashMap remaining = inv.addItem(new ItemStack[]{item});
        if (!remaining.isEmpty()) {
            Location location = player.getLocation();
            for (ItemStack value : remaining.values()) {
                player.getWorld().dropItem(location, value);
            }
        }
    }
}

