/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.feature;

import com.viaversion.viarewind.legacysupport.util.NMSUtil;
import com.viaversion.viarewind.legacysupport.util.ReflectionUtil;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockCollisionChanges {
    public static void fixLilyPad(Logger logger, ProtocolVersion serverVersion) {
        try {
            Field boundingBoxField = ReflectionUtil.getFieldAccessible(NMSUtil.getNMSBlockClass("BlockWaterLily"), serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_2) ? "a" : "b");
            BlockCollisionChanges.setBoundingBox(boundingBoxField.get(null), 0.0625, 0.0, 0.0625, 0.9375, 0.015625, 0.9375);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not fix lily pad bounding box.", ex);
        }
    }

    public static void fixCarpet(Logger logger, ProtocolVersion serverVersion) {
        try {
            Class<?> blockCarpetClass = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_16_4) ? NMSUtil.getNMSBlockClass("BlockCarpet") : NMSUtil.getNMSBlockClass("CarpetBlock");
            Field boundingBoxField = ReflectionUtil.getFieldAccessible(blockCarpetClass, serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_2) ? "a" : "b");
            BlockCollisionChanges.setBoundingBox(boundingBoxField.get(0), 0.0, -1.0E-7, 0.0, 1.0, 1.0E-7, 1.0);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not fix carpet bounding box.", ex);
        }
    }

    public static void fixLadder(Logger logger, ProtocolVersion serverVersion) {
        try {
            if (serverVersion.newerThanOrEqualTo(ProtocolVersion.v1_20_5)) {
                Class<?> blockLadderClass = NMSUtil.getNMSBlockClass("BlockLadder");
                HashMap<String, double[]> overrides = new HashMap<String, double[]>();
                overrides.put("EAST", new double[]{0.0, 0.0, 0.0, 0.125, 1.0, 1.0});
                overrides.put("WEST", new double[]{0.875, 0.0, 0.0, 1.0, 1.0, 1.0});
                overrides.put("SOUTH", new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.125});
                overrides.put("NORTH", new double[]{0.0, 0.0, 0.875, 1.0, 1.0, 1.0});
                Map shapesMap = null;
                for (Field field : blockLadderClass.getDeclaredFields()) {
                    Map casted;
                    if (!Modifier.isStatic(field.getModifiers()) || !Map.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    Object value = field.get(null);
                    if (!(value instanceof Map)) continue;
                    shapesMap = casted = (Map)value;
                    break;
                }
                boolean updated = false;
                if (shapesMap != null) {
                    updated = BlockCollisionChanges.updateShapesMap(shapesMap, overrides);
                }
                if (!updated) {
                    updated = BlockCollisionChanges.updateShapeConstants(blockLadderClass, overrides);
                }
                if (!updated) {
                    throw new IllegalStateException("Could not adjust ladder shapes for modern versions");
                }
            } else {
                boolean pre1_12_2 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_12_2);
                boolean pre1_13_2 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_13_2);
                boolean pre1_16_4 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_16_4);
                boolean pre1_20_2 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_2);
                Class<?> blockLadderClass = NMSUtil.getNMSBlockClass("BlockLadder");
                Field boundingBoxEastField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "b" : (pre1_13_2 ? "c" : (pre1_16_4 ? "c" : (pre1_20_2 ? "d" : "e"))));
                Field boundingBoxWestField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "c" : (pre1_13_2 ? "o" : (pre1_16_4 ? "d" : (pre1_20_2 ? "e" : "f"))));
                Field boundingBoxSouthField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "d" : (pre1_13_2 ? "p" : (pre1_16_4 ? "e" : (pre1_20_2 ? "f" : "g"))));
                Field boundingBoxNorthField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "e" : (pre1_13_2 ? "q" : (pre1_16_4 ? "f" : (pre1_20_2 ? "g" : "h"))));
                BlockCollisionChanges.setBoundingBox(boundingBoxEastField.get(null), 0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
                BlockCollisionChanges.setBoundingBox(boundingBoxWestField.get(null), 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
                BlockCollisionChanges.setBoundingBox(boundingBoxSouthField.get(null), 0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
                BlockCollisionChanges.setBoundingBox(boundingBoxNorthField.get(null), 0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not fix ladder bounding box.", ex);
        }
    }

    private static void setBoundingBox(Object boundingBox, double ... values) throws ReflectiveOperationException {
        switch (boundingBox.getClass().getSimpleName()) {
            case "AxisAlignedBB": {
                BlockCollisionChanges.setAxisAlignedBB(boundingBox, values);
                break;
            }
            case "VoxelShapeArray": 
            case "ArrayVoxelShape": {
                BlockCollisionChanges.setVoxelShapeArray(boundingBox, values);
                break;
            }
            case "AABBVoxelShape": {
                BlockCollisionChanges.setAABBVoxelShape(boundingBox, values);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown bounding box type: " + boundingBox.getClass().getName());
            }
        }
    }

    private static void setAABBVoxelShape(Object boundingBox, double[] values) throws ReflectiveOperationException {
        for (Field field : boundingBox.getClass().getFields()) {
            if (field.getType().getSimpleName().equals("AxisAlignedBB")) {
                BlockCollisionChanges.setBoundingBox(field.get(boundingBox), values);
            }
            if (!field.getType().getSimpleName().equals("DoubleList")) continue;
            Object doubleList = field.get(boundingBox);
            doubleList.getClass().getMethod("clear", new Class[0]).invoke(doubleList, new Object[0]);
        }
    }

    private static void setAxisAlignedBB(Object boundingBox, double[] values) throws ReflectiveOperationException {
        Field[] doubleFields = (Field[])Arrays.stream(boundingBox.getClass().getDeclaredFields()).filter(f -> f.getType() == Double.TYPE && !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
        if (doubleFields.length < 6) {
            throw new IllegalStateException("Invalid field count for " + boundingBox.getClass().getName() + ": " + doubleFields.length);
        }
        for (int i = 0; i < 6; ++i) {
            Field currentField = doubleFields[i];
            currentField.setAccessible(true);
            currentField.setDouble(boundingBox, values[i]);
        }
    }

    private static void setVoxelShapeArray(Object voxelShapeArray, double[] values) throws ReflectiveOperationException {
        Field[] doubleListFields = (Field[])Arrays.stream(voxelShapeArray.getClass().getDeclaredFields()).filter(f -> f.getType().getSimpleName().equals("DoubleList")).toArray(Field[]::new);
        if (doubleListFields.length < 3) {
            throw new IllegalStateException("Invalid field count for " + voxelShapeArray.getClass().getName() + ": " + doubleListFields.length);
        }
        String doubleArrayListClass = doubleListFields[0].getType().getName().replace("DoubleList", "DoubleArrayList");
        Method wrapMethod = Class.forName(doubleArrayListClass).getMethod("wrap", double[].class);
        for (int i = 0; i < 3; ++i) {
            double[] array = new double[]{values[i], values[i + 3]};
            Field field = doubleListFields[i];
            field.setAccessible(true);
            field.set(voxelShapeArray, wrapMethod.invoke(null, new Object[]{array}));
        }
        Class<?> voxelShape = voxelShapeArray.getClass().getSuperclass();
        Field shape = ReflectionUtil.getFieldAccessible(voxelShape, "a");
        Field cachedShapeData = ReflectionUtil.getFieldAccessible(shape.getType(), "cachedShapeData");
        if (cachedShapeData == null) {
            return;
        }
        cachedShapeData.set(shape.get(voxelShapeArray), null);
        Field isEmpty = ReflectionUtil.getFieldAccessible(voxelShape, "isEmpty");
        isEmpty.setBoolean(voxelShapeArray, true);
        Method initCache = ReflectionUtil.findMethod(voxelShape, new String[]{"initCache", "moonrise$initCache"}, new Class[0]);
        if (initCache == null) {
            throw new IllegalStateException("Could not find initCache method in " + voxelShape.getName());
        }
        initCache.invoke(voxelShapeArray, new Object[0]);
    }

    private static boolean updateShapesMap(Map<Object, Object> shapes, Map<String, double[]> overrides) throws ReflectiveOperationException {
        Method blockBoxMethod;
        if (shapes == null) {
            return false;
        }
        Class<?> directionClass = Class.forName("net.minecraft.core.Direction");
        Class<?> shapesClass = Class.forName("net.minecraft.world.phys.shapes.Shapes");
        Class<?> blockClass = Class.forName("net.minecraft.world.level.block.Block");
        Method shapesBoxMethod = ReflectionUtil.findMethod(shapesClass, new String[]{"box", "a"}, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
        if (shapesBoxMethod != null) {
            shapesBoxMethod.setAccessible(true);
        }
        if ((blockBoxMethod = ReflectionUtil.findMethod(blockClass, new String[]{"box", "a"}, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE)) != null) {
            blockBoxMethod.setAccessible(true);
        }
        Method shapesCreateMethod = null;
        Constructor<?> aabbConstructor = null;
        if (shapesBoxMethod == null) {
            Class<?> aabbClass = Class.forName("net.minecraft.world.phys.AABB");
            shapesCreateMethod = ReflectionUtil.findMethod(shapesClass, new String[]{"create", "a"}, aabbClass);
            if (shapesCreateMethod != null) {
                shapesCreateMethod.setAccessible(true);
                aabbConstructor = aabbClass.getDeclaredConstructor(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                aabbConstructor.setAccessible(true);
            }
        }
        Method directionValueOf = directionClass.getMethod("valueOf", String.class);
        directionValueOf.setAccessible(true);
        boolean updated = false;
        try {
            for (Map.Entry<String, double[]> entry : overrides.entrySet()) {
                Object direction = directionValueOf.invoke(null, entry.getKey());
                Object voxelShape = BlockCollisionChanges.createVoxelShape(shapesBoxMethod, blockBoxMethod, shapesCreateMethod, aabbConstructor, entry.getValue());
                shapes.put(direction, voxelShape);
                updated = true;
            }
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
        return updated;
    }

    private static boolean updateShapeConstants(Class<?> blockLadderClass, Map<String, double[]> overrides) throws ReflectiveOperationException {
        Class<?> voxelShapeInterface = Class.forName("net.minecraft.world.phys.shapes.VoxelShape");
        boolean updated = false;
        for (Field field : blockLadderClass.getDeclaredFields()) {
            double[] override;
            String orientation;
            double[] currentBounds;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object shapeObject = field.get(null);
            if (shapeObject == null || !voxelShapeInterface.isAssignableFrom(shapeObject.getClass()) && !shapeObject.getClass().getSimpleName().contains("VoxelShape") || (currentBounds = BlockCollisionChanges.getBoundingBoxValues(shapeObject)) == null || (orientation = BlockCollisionChanges.detectOrientation(currentBounds)) == null || (override = overrides.get(orientation)) == null) continue;
            BlockCollisionChanges.setBoundingBox(shapeObject, override);
            updated = true;
        }
        return updated;
    }

    private static double[] getBoundingBoxValues(Object boundingBox) throws ReflectiveOperationException {
        switch (boundingBox.getClass().getSimpleName()) {
            case "AxisAlignedBB": {
                return BlockCollisionChanges.getAxisAlignedBBValues(boundingBox);
            }
            case "VoxelShapeArray": 
            case "ArrayVoxelShape": {
                return BlockCollisionChanges.getVoxelShapeArrayValues(boundingBox);
            }
            case "AABBVoxelShape": {
                return BlockCollisionChanges.getAABBVoxelShapeValues(boundingBox);
            }
        }
        return null;
    }

    private static double[] getAABBVoxelShapeValues(Object boundingBox) throws ReflectiveOperationException {
        for (Field field : boundingBox.getClass().getFields()) {
            if (!field.getType().getSimpleName().equals("AxisAlignedBB")) continue;
            return BlockCollisionChanges.getBoundingBoxValues(field.get(boundingBox));
        }
        return null;
    }

    private static double[] getAxisAlignedBBValues(Object boundingBox) throws ReflectiveOperationException {
        Field[] doubleFields = (Field[])Arrays.stream(boundingBox.getClass().getDeclaredFields()).filter(f -> f.getType() == Double.TYPE && !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
        if (doubleFields.length < 6) {
            throw new IllegalStateException("Invalid field count for " + boundingBox.getClass().getName() + ": " + doubleFields.length);
        }
        double[] values = new double[6];
        for (int i = 0; i < 6; ++i) {
            Field currentField = doubleFields[i];
            currentField.setAccessible(true);
            values[i] = currentField.getDouble(boundingBox);
        }
        return values;
    }

    private static double[] getVoxelShapeArrayValues(Object voxelShapeArray) throws ReflectiveOperationException {
        Field[] doubleListFields = (Field[])Arrays.stream(voxelShapeArray.getClass().getDeclaredFields()).filter(f -> f.getType().getSimpleName().equals("DoubleList")).toArray(Field[]::new);
        if (doubleListFields.length < 3) {
            throw new IllegalStateException("Invalid field count for " + voxelShapeArray.getClass().getName() + ": " + doubleListFields.length);
        }
        double[] values = new double[6];
        for (int i = 0; i < 3; ++i) {
            Field field = doubleListFields[i];
            field.setAccessible(true);
            Object doubleList = field.get(voxelShapeArray);
            if (doubleList == null) {
                return null;
            }
            Method getDouble = ReflectionUtil.findMethod(doubleList.getClass(), new String[]{"getDouble", "get"}, Integer.TYPE);
            if (getDouble == null) {
                return null;
            }
            getDouble.setAccessible(true);
            values[i] = ((Number)getDouble.invoke(doubleList, 0)).doubleValue();
            values[i + 3] = ((Number)getDouble.invoke(doubleList, 1)).doubleValue();
        }
        return values;
    }

    private static String detectOrientation(double[] bounds) {
        double epsilon = 0.001;
        double minX = bounds[0];
        double minZ = bounds[2];
        double maxX = bounds[3];
        double maxZ = bounds[5];
        if (minX <= 0.001 && maxX <= 0.5) {
            return "EAST";
        }
        if (maxX >= 0.999 && minX >= 0.5) {
            return "WEST";
        }
        if (minZ <= 0.001 && maxZ <= 0.5) {
            return "SOUTH";
        }
        if (maxZ >= 0.999 && minZ >= 0.5) {
            return "NORTH";
        }
        return null;
    }

    private static Object createVoxelShape(Method shapesBoxMethod, Method blockBoxMethod, Method shapesCreateMethod, Constructor<?> aabbConstructor, double[] values) throws ReflectiveOperationException {
        if (shapesBoxMethod != null) {
            return shapesBoxMethod.invoke(null, values[0], values[1], values[2], values[3], values[4], values[5]);
        }
        if (shapesCreateMethod != null && aabbConstructor != null) {
            Object aabb = aabbConstructor.newInstance(values[0], values[1], values[2], values[3], values[4], values[5]);
            return shapesCreateMethod.invoke(null, aabb);
        }
        if (blockBoxMethod != null) {
            double scale = 16.0;
            return blockBoxMethod.invoke(null, values[0] * 16.0, values[1] * 16.0, values[2] * 16.0, values[3] * 16.0, values[4] * 16.0, values[5] * 16.0);
        }
        throw new IllegalStateException("Unable to create voxel shape for ladder bounding box.");
    }
}

