/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport;

import com.viaversion.viarewind.legacysupport.feature.AnvilCostFix;
import com.viaversion.viarewind.legacysupport.feature.AreaEffectCloudEmulator;
import com.viaversion.viarewind.legacysupport.feature.BlockCollisionChanges;
import com.viaversion.viarewind.legacysupport.feature.BlockPlaceSoundEmulator;
import com.viaversion.viarewind.legacysupport.feature.BrewingInteractionEmulator;
import com.viaversion.viarewind.legacysupport.feature.ElytraVelocityEmulator;
import com.viaversion.viarewind.legacysupport.feature.EnchantingGuiEmulator;
import com.viaversion.viarewind.legacysupport.feature.SlimeBounceEmulator;
import com.viaversion.viarewind.legacysupport.versioninfo.VersionInformer;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitPlugin
extends JavaPlugin {
    private ProtocolVersion serverProtocol;

    public void onEnable() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        if (Via.getManager().getInjector().lateProtocolVersionSetting()) {
            Via.getPlatform().runSync(this::enable, 1L);
        } else {
            this.enable();
        }
    }

    private void enable() {
        this.serverProtocol = Via.getAPI().getServerVersion().lowestSupportedProtocolVersion();
        if (!this.serverProtocol.isKnown()) {
            return;
        }
        FileConfiguration config = this.getConfig();
        if (this.serverProtocol.equals((Object)ProtocolVersion.v1_8) && config.getBoolean("anvil-cost-fix")) {
            Bukkit.getPluginManager().registerEvents((Listener)new AnvilCostFix(), (Plugin)this);
        }
        if (this.serverProtocol.newerThanOrEqualTo(ProtocolVersion.v1_8)) {
            if (config.getBoolean("enchanting-gui-fix")) {
                Bukkit.getPluginManager().registerEvents((Listener)new EnchantingGuiEmulator(), (Plugin)this);
            }
            if (config.getBoolean("slime-fix")) {
                Bukkit.getPluginManager().registerEvents((Listener)new SlimeBounceEmulator(), (Plugin)this);
            }
        }
        if (this.serverProtocol.newerThanOrEqualTo(ProtocolVersion.v1_9)) {
            if (config.getBoolean("sound-fix")) {
                Bukkit.getPluginManager().registerEvents((Listener)new BlockPlaceSoundEmulator(this), (Plugin)this);
            }
            if (config.getBoolean("ladder-fix")) {
                BlockCollisionChanges.fixLadder(this.getLogger(), this.serverProtocol);
            }
            if (config.getBoolean("area-effect-cloud-particles")) {
                Bukkit.getPluginManager().registerEvents((Listener)new AreaEffectCloudEmulator(this), (Plugin)this);
            }
            if (config.getBoolean("elytra-fix")) {
                Bukkit.getPluginManager().registerEvents((Listener)new ElytraVelocityEmulator(), (Plugin)this);
            }
            if (config.getBoolean("brewing-stand-gui-fix")) {
                Bukkit.getPluginManager().registerEvents((Listener)new BrewingInteractionEmulator(), (Plugin)this);
            }
            if (config.getBoolean("lily-pad-fix")) {
                BlockCollisionChanges.fixLilyPad(this.getLogger(), this.serverProtocol);
            }
        }
        if (this.serverProtocol.newerThanOrEqualTo(ProtocolVersion.v1_14_4) && config.getBoolean("carpet-fix")) {
            BlockCollisionChanges.fixCarpet(this.getLogger(), this.serverProtocol);
        }
        if (config.getBoolean("versioninfo.active")) {
            new VersionInformer(this, config);
        }
    }

    public ProtocolVersion getServerProtocol() {
        return this.serverProtocol;
    }

    public static BukkitPlugin getInstance() {
        return (BukkitPlugin)BukkitPlugin.getPlugin(BukkitPlugin.class);
    }
}

