/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.versioninfo;

import com.viaversion.viarewind.legacysupport.BukkitPlugin;
import com.viaversion.viaversion.api.Via;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class VersionInformer
implements Listener {
    private final String[] versionMessage;
    private final int maxVersion;

    public VersionInformer(BukkitPlugin plugin, FileConfiguration config) {
        String message = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("versioninfo.message")).replace("%version%", Bukkit.getVersion().split(" ")[2].replace(")", ""));
        this.versionMessage = message.split(System.lineSeparator());
        this.maxVersion = config.getInt("versioninfo.max-version");
        String interval = config.getString("versioninfo.interval");
        if (interval.equalsIgnoreCase("JOIN")) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        } else {
            long ticks;
            try {
                ticks = Long.parseLong(interval);
            }
            catch (NumberFormatException e) {
                Bukkit.getLogger().warning("Invalid interval for versioninfo.interval, defaulting to 6000");
                ticks = 6000L;
            }
            Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> Bukkit.getOnlinePlayers().forEach(this::inform), ticks, ticks);
        }
    }

    protected void inform(Player player) {
        int version = Via.getAPI().getPlayerVersion((Object)player);
        if (version == -1 || version > this.maxVersion) {
            return;
        }
        player.sendMessage(this.versionMessage);
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        this.inform(e.getPlayer());
    }
}

