/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.feature;

import com.viaversion.viarewind.legacysupport.BukkitPlugin;
import com.viaversion.viarewind.legacysupport.util.NMSUtil;
import com.viaversion.viarewind.legacysupport.util.ReflectionUtil;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.lang.reflect.Method;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class BlockPlaceSoundEmulator
implements Listener {
    private static boolean isSoundCategory = false;

    public BlockPlaceSoundEmulator(BukkitPlugin plugin) {
        try {
            Class.forName("org.bukkit.event.entity.EntityPickupItemEvent");
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onItemPickUp(EntityPickupItemEvent e) {
                    if (!(e.getEntity() instanceof Player)) {
                        return;
                    }
                    BlockPlaceSoundEmulator.this.onItemPickUp((Player)e.getEntity());
                }
            }, (Plugin)plugin);
        }
        catch (Exception ex) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
                public void onItemPickUp(PlayerPickupItemEvent e) {
                    BlockPlaceSoundEmulator.this.onItemPickUp(e.getPlayer());
                }
            }, (Plugin)plugin);
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent e) {
        Player player = e.getPlayer();
        if (Via.getAPI().getPlayerProtocolVersion((Object)player).newerThanOrEqualTo(ProtocolVersion.v1_9)) {
            return;
        }
        if (Via.getAPI().getServerVersion().lowestSupportedProtocolVersion().newerThanOrEqualTo(ProtocolVersion.v1_17)) {
            player.playSound(e.getBlockPlaced().getLocation(), e.getBlock().getBlockData().getSoundGroup().getPlaceSound(), 1.0f, 0.8f);
        } else {
            try {
                BlockPlaceSoundEmulator.playBlockPlaceSoundNMS(player, e.getBlock());
            }
            catch (Exception exception) {
                Via.getPlatform().getLogger().log(Level.SEVERE, "Could not play block place sound.", exception);
            }
        }
    }

    private void onItemPickUp(Player player) {
        float volume = 0.2f;
        float pitch = (float)((Math.random() - Math.random()) * (double)0.7f + 1.0) * 2.0f;
        BlockPlaceSoundEmulator.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.2f, pitch);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    private void onExperienceOrbPickup(PlayerExpChangeEvent e) {
        float volume = 0.1f;
        float pitch = (float)(0.5 * ((Math.random() - Math.random()) * (double)0.7f + (double)1.8f));
        BlockPlaceSoundEmulator.playSound(e.getPlayer().getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.1f, pitch);
    }

    private static void playSound(Location loc, Sound sound, float volume, float pitch) {
        Bukkit.getOnlinePlayers().stream().filter(p -> p.getWorld() == loc.getWorld()).filter(p -> p.getLocation().distanceSquared(loc) < 256.0).filter(p -> Via.getAPI().getPlayerVersion(p) <= 47).forEach(p -> {
            if (isSoundCategory) {
                p.playSound(loc, sound, SoundCategory.valueOf((String)"PLAYERS"), volume, pitch);
            } else {
                p.playSound(loc, sound, volume, pitch);
            }
        });
    }

    private static void playBlockPlaceSoundNMS(Player player, Block block) throws Exception {
        Method pitchMethod;
        Method volumeMethod;
        Method soundEffectMethod;
        World world = block.getWorld();
        Object nmsWorld = world.getClass().getMethod("getHandle", new Class[0]).invoke((Object)world, new Object[0]);
        Class<?> blockPositionClass = NMSUtil.getBlockPositionClass();
        Object blockPosition = null;
        if (blockPositionClass != null) {
            blockPosition = blockPositionClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(block.getX(), block.getY(), block.getZ());
        }
        Method getTypeMethod = nmsWorld.getClass().getMethod("getType", blockPositionClass);
        getTypeMethod.setAccessible(true);
        Object blockData = getTypeMethod.invoke(nmsWorld, blockPosition);
        Method getBlock = blockData.getClass().getMethod("getBlock", new Class[0]);
        getBlock.setAccessible(true);
        Object nmsBlock = getBlock.invoke(blockData, new Object[0]);
        int serverProtocol = Via.getAPI().getServerVersion().lowestSupportedVersion();
        Method getStepSound = serverProtocol > ProtocolVersion.v1_8.getVersion() && serverProtocol < ProtocolVersion.v1_12.getVersion() ? ReflectionUtil.getMethod(nmsBlock.getClass(), "w", new Class[0]) : (serverProtocol > ProtocolVersion.v1_10.getVersion() && serverProtocol < ProtocolVersion.v1_13.getVersion() ? ReflectionUtil.getMethod(nmsBlock.getClass(), "getStepSound", new Class[0]) : ReflectionUtil.getMethod(nmsBlock.getClass(), "getStepSound", blockData.getClass()));
        if (getStepSound == null) {
            Via.getPlatform().getLogger().severe("Could not find getStepSound method in " + nmsBlock.getClass().getName());
            return;
        }
        getStepSound.setAccessible(true);
        Object soundType = getStepSound.getParameterCount() == 0 ? getStepSound.invoke(nmsBlock, new Object[0]) : getStepSound.invoke(nmsBlock, blockData);
        try {
            soundEffectMethod = soundType.getClass().getMethod("getPlaceSound", new Class[0]);
            volumeMethod = soundType.getClass().getMethod("getVolume", new Class[0]);
            pitchMethod = soundType.getClass().getMethod("getPitch", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            soundEffectMethod = soundType.getClass().getMethod("e", new Class[0]);
            volumeMethod = soundType.getClass().getMethod("a", new Class[0]);
            pitchMethod = soundType.getClass().getMethod("b", new Class[0]);
        }
        Object soundEffect = soundEffectMethod.invoke(soundType, new Object[0]);
        float volume = ((Float)volumeMethod.invoke(soundType, new Object[0])).floatValue();
        float pitch = ((Float)pitchMethod.invoke(soundType, new Object[0])).floatValue();
        Object soundCategory = Enum.valueOf(NMSUtil.getSoundCategoryClass(), "BLOCKS");
        volume = (volume + 1.0f) / 2.0f;
        pitch = (float)((double)pitch * 0.8);
        BlockPlaceSoundEmulator.playSound(player, soundEffect, soundCategory, (double)block.getX() + 0.5, (double)block.getY() + 0.5, (double)block.getZ() + 0.5, volume, pitch);
    }

    private static void playSound(Player player, Object soundEffect, Object soundCategory, double x, double y, double z, float volume, float pitch) {
        try {
            Object packet = NMSUtil.getGamePacketClass("PacketPlayOutNamedSoundEffect").getConstructor(soundEffect.getClass(), soundCategory.getClass(), Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).newInstance(soundEffect, soundCategory, x, y, z, Float.valueOf(volume), Float.valueOf(pitch));
            NMSUtil.sendPacket(player, packet);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        try {
            Class.forName("org.bukkit.SoundCategory");
            isSoundCategory = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

