/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.legacysupport.feature;

import com.viaversion.viarewind.legacysupport.util.NMSUtil;
import com.viaversion.viarewind.legacysupport.util.ReflectionUtil;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockCollisionChanges {
    public static void fixLilyPad(Logger logger, ProtocolVersion serverVersion) {
        try {
            Field boundingBoxField = ReflectionUtil.getFieldAccessible(NMSUtil.getNMSBlockClass("BlockWaterLily"), serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_2) ? "a" : "b");
            BlockCollisionChanges.setBoundingBox(boundingBoxField.get(null), 0.0625, 0.0, 0.0625, 0.9375, 0.015625, 0.9375);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not fix lily pad bounding box.", ex);
        }
    }

    public static void fixCarpet(Logger logger, ProtocolVersion serverVersion) {
        try {
            Class<?> blockCarpetClass = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_16_4) ? NMSUtil.getNMSBlockClass("BlockCarpet") : NMSUtil.getNMSBlockClass("CarpetBlock");
            Field boundingBoxField = ReflectionUtil.getFieldAccessible(blockCarpetClass, serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_2) ? "a" : "b");
            BlockCollisionChanges.setBoundingBox(boundingBoxField.get(0), 0.0, -1.0E-7, 0.0, 1.0, 1.0E-7, 1.0);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not fix carpet bounding box.", ex);
        }
    }

    public static void fixLadder(Logger logger, ProtocolVersion serverVersion) {
        try {
            if (serverVersion.newerThanOrEqualTo(ProtocolVersion.v1_20_5)) {
                Class<?> blockLadderClass = NMSUtil.getNMSBlockClass("BlockLadder");
                Field shapesField = ReflectionUtil.getFieldAccessible(blockLadderClass, "d");
                shapesField.setAccessible(true);
                Class<?> blockClass = Class.forName("net.minecraft.world.level.block.Block");
                Method boxZMethod = blockClass.getDeclaredMethod("boxZ", Double.TYPE, Double.TYPE, Double.TYPE);
                boxZMethod.setAccessible(true);
                Object voxelShape = boxZMethod.invoke(null, 16.0, 14.0, 16.0);
                Class<?> shapesClass = Class.forName("net.minecraft.world.phys.shapes.Shapes");
                Class<?> voxelShapeInterface = Class.forName("net.minecraft.world.phys.shapes.VoxelShape");
                Method rotateHorizontalMethod = shapesClass.getDeclaredMethod("rotateHorizontal", voxelShapeInterface);
                rotateHorizontalMethod.setAccessible(true);
                Map rotatedMap = (Map)rotateHorizontalMethod.invoke(null, voxelShape);
                Map shapes = (Map)shapesField.get(null);
                shapes.clear();
                shapes.putAll(rotatedMap);
            } else {
                boolean pre1_12_2 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_12_2);
                boolean pre1_13_2 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_13_2);
                boolean pre1_16_4 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_16_4);
                boolean pre1_20_2 = serverVersion.olderThanOrEqualTo(ProtocolVersion.v1_20_2);
                Class<?> blockLadderClass = NMSUtil.getNMSBlockClass("BlockLadder");
                Field boundingBoxEastField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "b" : (pre1_13_2 ? "c" : (pre1_16_4 ? "c" : (pre1_20_2 ? "d" : "e"))));
                Field boundingBoxWestField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "c" : (pre1_13_2 ? "o" : (pre1_16_4 ? "d" : (pre1_20_2 ? "e" : "f"))));
                Field boundingBoxSouthField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "d" : (pre1_13_2 ? "p" : (pre1_16_4 ? "e" : (pre1_20_2 ? "f" : "g"))));
                Field boundingBoxNorthField = ReflectionUtil.getFieldAccessible(blockLadderClass, pre1_12_2 ? "e" : (pre1_13_2 ? "q" : (pre1_16_4 ? "f" : (pre1_20_2 ? "g" : "h"))));
                BlockCollisionChanges.setBoundingBox(boundingBoxEastField.get(null), 0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
                BlockCollisionChanges.setBoundingBox(boundingBoxWestField.get(null), 0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
                BlockCollisionChanges.setBoundingBox(boundingBoxSouthField.get(null), 0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
                BlockCollisionChanges.setBoundingBox(boundingBoxNorthField.get(null), 0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not fix ladder bounding box.", ex);
        }
    }

    private static void setBoundingBox(Object boundingBox, double ... values) throws ReflectiveOperationException {
        switch (boundingBox.getClass().getSimpleName()) {
            case "AxisAlignedBB": {
                BlockCollisionChanges.setAxisAlignedBB(boundingBox, values);
                break;
            }
            case "VoxelShapeArray": 
            case "ArrayVoxelShape": {
                BlockCollisionChanges.setVoxelShapeArray(boundingBox, values);
                break;
            }
            case "AABBVoxelShape": {
                BlockCollisionChanges.setAABBVoxelShape(boundingBox, values);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown bounding box type: " + boundingBox.getClass().getName());
            }
        }
    }

    private static void setAABBVoxelShape(Object boundingBox, double[] values) throws ReflectiveOperationException {
        for (Field field : boundingBox.getClass().getFields()) {
            if (field.getType().getSimpleName().equals("AxisAlignedBB")) {
                BlockCollisionChanges.setBoundingBox(field.get(boundingBox), values);
            }
            if (!field.getType().getSimpleName().equals("DoubleList")) continue;
            Object doubleList = field.get(boundingBox);
            doubleList.getClass().getMethod("clear", new Class[0]).invoke(doubleList, new Object[0]);
        }
    }

    private static void setAxisAlignedBB(Object boundingBox, double[] values) throws ReflectiveOperationException {
        Field[] doubleFields = (Field[])Arrays.stream(boundingBox.getClass().getDeclaredFields()).filter(f -> f.getType() == Double.TYPE && !Modifier.isStatic(f.getModifiers())).toArray(Field[]::new);
        if (doubleFields.length < 6) {
            throw new IllegalStateException("Invalid field count for " + boundingBox.getClass().getName() + ": " + doubleFields.length);
        }
        for (int i = 0; i < 6; ++i) {
            Field currentField = doubleFields[i];
            currentField.setAccessible(true);
            currentField.setDouble(boundingBox, values[i]);
        }
    }

    private static void setVoxelShapeArray(Object voxelShapeArray, double[] values) throws ReflectiveOperationException {
        Field[] doubleListFields = (Field[])Arrays.stream(voxelShapeArray.getClass().getDeclaredFields()).filter(f -> f.getType().getSimpleName().equals("DoubleList")).toArray(Field[]::new);
        if (doubleListFields.length < 3) {
            throw new IllegalStateException("Invalid field count for " + voxelShapeArray.getClass().getName() + ": " + doubleListFields.length);
        }
        String doubleArrayListClass = doubleListFields[0].getType().getName().replace("DoubleList", "DoubleArrayList");
        Method wrapMethod = Class.forName(doubleArrayListClass).getMethod("wrap", double[].class);
        for (int i = 0; i < 3; ++i) {
            double[] array = new double[]{values[i], values[i + 3]};
            Field field = doubleListFields[i];
            field.setAccessible(true);
            field.set(voxelShapeArray, wrapMethod.invoke(null, new Object[]{array}));
        }
        Class<?> voxelShape = voxelShapeArray.getClass().getSuperclass();
        Field shape = ReflectionUtil.getFieldAccessible(voxelShape, "a");
        Field cachedShapeData = ReflectionUtil.getFieldAccessible(shape.getType(), "cachedShapeData");
        if (cachedShapeData == null) {
            return;
        }
        cachedShapeData.set(shape.get(voxelShapeArray), null);
        Field isEmpty = ReflectionUtil.getFieldAccessible(voxelShape, "isEmpty");
        isEmpty.setBoolean(voxelShapeArray, true);
        Method initCache = ReflectionUtil.findMethod(voxelShape, new String[]{"initCache", "moonrise$initCache"}, new Class[0]);
        if (initCache == null) {
            throw new IllegalStateException("Could not find initCache method in " + voxelShape.getName());
        }
        initCache.invoke(voxelShapeArray, new Object[0]);
    }
}

