/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.v1_21_9to1_21_7.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.rewriters.BackwardsRegistryRewriter;
import com.viaversion.viabackwards.api.rewriters.EntityRewriter;
import com.viaversion.viabackwards.protocol.v1_21_9to1_21_7.Protocol1_21_9To1_21_7;
import com.viaversion.viabackwards.protocol.v1_21_9to1_21_7.storage.DimensionScaleStorage;
import com.viaversion.viabackwards.protocol.v1_21_9to1_21_7.storage.MannequinData;
import com.viaversion.viabackwards.protocol.v1_21_9to1_21_7.storage.PlayerRotationStorage;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.GameProfile;
import com.viaversion.viaversion.api.minecraft.GlobalBlockPosition;
import com.viaversion.viaversion.api.minecraft.RegistryEntry;
import com.viaversion.viaversion.api.minecraft.ResolvableProfile;
import com.viaversion.viaversion.api.minecraft.Vector3d;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_6;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_9;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_21_5;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_21_9;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.VersionedTypes;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ClientboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_5to1_21_6.packet.ServerboundPackets1_21_6;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundConfigurationPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPacket1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import com.viaversion.viaversion.rewriter.RegistryDataRewriter;
import com.viaversion.viaversion.rewriter.entitydata.EntityDataHandler;
import java.util.BitSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EntityPacketRewriter1_21_9
extends EntityRewriter<ClientboundPacket1_21_9, Protocol1_21_9To1_21_7> {
    public EntityPacketRewriter1_21_9(Protocol1_21_9To1_21_7 protocol) {
        super(protocol, ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).optionalComponentType, ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).booleanType);
    }

    public void registerPackets() {
        this.registerSetEntityData((ClientboundPacketType)ClientboundPackets1_21_9.SET_ENTITY_DATA);
        this.registerRemoveEntities((ClientboundPacketType)ClientboundPackets1_21_9.REMOVE_ENTITIES);
        this.registerPlayerAbilities((ClientboundPacketType)ClientboundPackets1_21_9.PLAYER_ABILITIES);
        this.registerGameEvent((ClientboundPacketType)ClientboundPackets1_21_9.GAME_EVENT);
        this.registerLogin1_20_5((ClientboundPacketType)ClientboundPackets1_21_9.LOGIN);
        this.registerRespawn1_20_5((ClientboundPacketType)ClientboundPackets1_21_9.RESPAWN);
        ((Protocol1_21_9To1_21_7)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_21_9.ADD_ENTITY, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            UUID uuid = (UUID)wrapper.passthrough(Types.UUID);
            int entityTypeId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            Vector3d movement = (Vector3d)wrapper.read(Types.MOVEMENT_VECTOR);
            wrapper.passthrough((Type)Types.BYTE);
            wrapper.passthrough((Type)Types.BYTE);
            wrapper.passthrough((Type)Types.BYTE);
            int data = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            EntityType entityType = this.trackAndRewrite(wrapper, entityTypeId, entityId);
            if (((Protocol1_21_9To1_21_7)this.protocol).getMappingData() != null && entityType == EntityTypes1_21_9.FALLING_BLOCK) {
                int mappedBlockStateId = ((Protocol1_21_9To1_21_7)this.protocol).getMappingData().getNewBlockStateId(data);
                wrapper.set((Type)Types.VAR_INT, 2, (Object)mappedBlockStateId);
            }
            this.writeMovementShorts(wrapper, movement);
            if (EntityTypes1_21_9.getTypeFromId((int)entityTypeId) == EntityTypes1_21_9.MANNEQUIN) {
                String name = this.randomHackyEmptyName();
                MannequinData mannequinData = new MannequinData(uuid, name);
                this.tracker(wrapper.user()).entity(entityId).data().put((Object)mannequinData);
                this.sendInitialPlayerInfoUpdate(wrapper, mannequinData);
            }
        });
        ((Protocol1_21_9To1_21_7)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_21_9.SET_ENTITY_MOTION, wrapper -> {
            wrapper.passthrough((Type)Types.VAR_INT);
            this.writeMovementShorts(wrapper, (Vector3d)wrapper.read(Types.MOVEMENT_VECTOR));
        });
        ((Protocol1_21_9To1_21_7)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_21_9.PLAYER_ROTATION, wrapper -> {
            PlayerRotationStorage storage = (PlayerRotationStorage)wrapper.user().get(PlayerRotationStorage.class);
            float yRot = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
            if (((Boolean)wrapper.read((Type)Types.BOOLEAN)).booleanValue()) {
                yRot = storage.yaw() + yRot;
            }
            float xRot = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
            if (((Boolean)wrapper.read((Type)Types.BOOLEAN)).booleanValue()) {
                xRot = storage.pitch() + xRot;
            }
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(yRot));
            wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf(xRot));
            storage.setRotation(yRot, xRot);
        });
        ((Protocol1_21_9To1_21_7)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_21_9.SET_DEFAULT_SPAWN_POSITION, wrapper -> {
            GlobalBlockPosition pos = (GlobalBlockPosition)wrapper.read(Types.GLOBAL_POSITION);
            wrapper.write(Types.BLOCK_POSITION1_14, (Object)new BlockPosition(pos.x(), pos.y(), pos.z()));
            wrapper.passthrough((Type)Types.FLOAT);
            wrapper.read((Type)Types.FLOAT);
        });
        BackwardsRegistryRewriter registryDataRewriter = new BackwardsRegistryRewriter((BackwardsProtocol)this.protocol){

            public void trackDimensionAndBiomes(UserConnection connection, String registryKey, RegistryEntry[] entries) {
                super.trackDimensionAndBiomes(connection, registryKey, entries);
                if (!registryKey.equals("dimension_type")) {
                    return;
                }
                DimensionScaleStorage dimensionScaleStorage = (DimensionScaleStorage)connection.get(DimensionScaleStorage.class);
                for (int i = 0; i < entries.length; ++i) {
                    RegistryEntry entry = entries[i];
                    CompoundTag dimension = (CompoundTag)entry.tag();
                    if (dimension == null) continue;
                    double coordinateScale = dimension.getDouble("coordinate_scale", 1.0);
                    dimensionScaleStorage.setScale(i, coordinateScale);
                }
            }
        };
        ((Protocol1_21_9To1_21_7)this.protocol).registerClientbound((ClientboundPacketType)ClientboundConfigurationPackets1_21_9.REGISTRY_DATA, arg_0 -> ((RegistryDataRewriter)registryDataRewriter).handle(arg_0));
        ((Protocol1_21_9To1_21_7)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.MOVE_PLAYER_POS_ROT, wrapper -> {
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.passthrough((Type)Types.DOUBLE);
            this.storePlayerRotation(wrapper);
        });
        ((Protocol1_21_9To1_21_7)this.protocol).registerServerbound((ServerboundPacketType)ServerboundPackets1_21_6.MOVE_PLAYER_ROT, this::storePlayerRotation);
    }

    private void sendInitialPlayerInfoUpdate(PacketWrapper wrapper, MannequinData mannequinData) {
        PacketWrapper playerInfo = wrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE);
        BitSet actions = new BitSet(8);
        for (int i = 0; i < 8; ++i) {
            actions.set(i);
        }
        playerInfo.write((Type)Types.PROFILE_ACTIONS_ENUM1_21_4, (Object)actions);
        playerInfo.write((Type)Types.VAR_INT, (Object)1);
        playerInfo.write(Types.UUID, (Object)mannequinData.uuid());
        playerInfo.write(Types.STRING, (Object)mannequinData.name());
        playerInfo.write(Types.PROFILE_PROPERTY_ARRAY, (Object)new GameProfile.Property[0]);
        playerInfo.write((Type)Types.BOOLEAN, (Object)false);
        playerInfo.write((Type)Types.VAR_INT, (Object)0);
        playerInfo.write((Type)Types.BOOLEAN, (Object)false);
        playerInfo.write((Type)Types.VAR_INT, (Object)0);
        playerInfo.write(Types.OPTIONAL_TAG, null);
        playerInfo.write((Type)Types.VAR_INT, (Object)1000);
        playerInfo.write((Type)Types.BOOLEAN, (Object)true);
        playerInfo.send(Protocol1_21_9To1_21_7.class);
        this.sendPlayerTeamDisplayName(wrapper.user(), mannequinData, null);
    }

    private void sendPlayerInfoDisplayNameUpdate(UserConnection connection, MannequinData mannequinData, @Nullable Tag displayName) {
        PacketWrapper playerInfo = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE, (UserConnection)connection);
        BitSet actions = new BitSet(8);
        actions.set(5);
        playerInfo.write((Type)Types.PROFILE_ACTIONS_ENUM1_21_4, (Object)actions);
        playerInfo.write((Type)Types.VAR_INT, (Object)1);
        playerInfo.write(Types.UUID, (Object)mannequinData.uuid());
        playerInfo.write(Types.OPTIONAL_TAG, (Object)displayName);
        playerInfo.send(Protocol1_21_9To1_21_7.class);
        this.sendPlayerTeamDisplayName(connection, mannequinData, displayName);
    }

    private void sendPlayerTeamDisplayName(UserConnection connection, MannequinData mannequinData, Tag displayName) {
        Tag nonNullDisplayName = displayName != null ? displayName : new StringTag("Mannequin");
        PacketWrapper addTeam = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.SET_PLAYER_TEAM, (UserConnection)connection);
        addTeam.write(Types.STRING, (Object)mannequinData.name());
        addTeam.write((Type)Types.BYTE, (Object)(mannequinData.hasTeam() ? (byte)2 : 0));
        addTeam.write(Types.TAG, (Object)nonNullDisplayName);
        addTeam.write((Type)Types.BYTE, (Object)0);
        addTeam.write((Type)Types.VAR_INT, (Object)0);
        addTeam.write((Type)Types.VAR_INT, (Object)0);
        addTeam.write((Type)Types.VAR_INT, (Object)15);
        addTeam.write(Types.TAG, (Object)nonNullDisplayName);
        addTeam.write(Types.TAG, (Object)new StringTag(""));
        if (!mannequinData.hasTeam()) {
            addTeam.write(Types.STRING_ARRAY, (Object)new String[]{mannequinData.name()});
        }
        addTeam.send(Protocol1_21_9To1_21_7.class);
    }

    private void sendPlayerInfoProfileUpdate(UserConnection connection, UUID uuid, @Nullable String name, GameProfile.Property[] properties) {
        PacketWrapper playerInfo = PacketWrapper.create((PacketType)ClientboundPackets1_21_6.PLAYER_INFO_UPDATE, (UserConnection)connection);
        BitSet actions = new BitSet(8);
        actions.set(0);
        playerInfo.write((Type)Types.PROFILE_ACTIONS_ENUM1_21_4, (Object)actions);
        playerInfo.write((Type)Types.VAR_INT, (Object)1);
        playerInfo.write(Types.UUID, (Object)uuid);
        playerInfo.write(Types.STRING, (Object)(name != null ? name : this.randomHackyEmptyName()));
        playerInfo.write(Types.PROFILE_PROPERTY_ARRAY, (Object)properties);
        playerInfo.send(Protocol1_21_9To1_21_7.class);
    }

    private String randomHackyEmptyName() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            int random = ThreadLocalRandom.current().nextInt("0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".length());
            builder.append('\u00a7').append("0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".charAt(random));
        }
        return builder.toString();
    }

    private void writeMovementShorts(PacketWrapper wrapper, Vector3d movement) {
        wrapper.write((Type)Types.SHORT, (Object)((short)(movement.x() * 8000.0)));
        wrapper.write((Type)Types.SHORT, (Object)((short)(movement.y() * 8000.0)));
        wrapper.write((Type)Types.SHORT, (Object)((short)(movement.z() * 8000.0)));
    }

    private void storePlayerRotation(PacketWrapper wrapper) {
        float yaw = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
        float pitch = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
        ((PlayerRotationStorage)wrapper.user().get(PlayerRotationStorage.class)).setRotation(yaw, pitch);
    }

    protected void registerRewrites() {
        EntityDataTypes1_21_5 entityDataTypes = (EntityDataTypes1_21_5)((Protocol1_21_9To1_21_7)this.protocol).mappedTypes().entityDataTypes();
        this.filter().handler((event, data) -> {
            int id = data.dataType().typeId();
            if (id == ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).copperGolemState.typeId() || id == ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).weatheringCopperState.typeId()) {
                event.cancel();
                return;
            }
            if (id == ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).mannequinProfileType.typeId()) {
                if (event.entityType() == null) {
                    event.cancel();
                }
                return;
            }
            if (id > ((EntityDataTypes1_21_9)VersionedTypes.V1_21_9.entityDataTypes).armadilloState.typeId()) {
                id -= 2;
            }
            if (id >= entityDataTypes.compoundTagType.typeId()) {
                ++id;
            }
            data.setDataType(entityDataTypes.byId(id));
        });
        this.registerEntityDataTypeHandler1_20_3(entityDataTypes.itemType, entityDataTypes.blockStateType, entityDataTypes.optionalBlockStateType, entityDataTypes.particleType, entityDataTypes.particlesType, entityDataTypes.componentType, entityDataTypes.optionalComponentType);
        EntityDataHandler shoulderDataHandler = (event, data) -> {
            CompoundTag entityTag = new CompoundTag();
            Integer value = (Integer)data.value();
            if (value != null) {
                entityTag.putInt("id", EntityTypes1_21_6.PARROT.getId());
                entityTag.putInt("Variant", value.intValue());
            }
            data.setTypeAndValue(((EntityDataTypes1_21_5)((Protocol1_21_9To1_21_7)this.protocol).mappedTypes().entityDataTypes).compoundTagType, (Object)entityTag);
        };
        this.filter().type((EntityType)EntityTypes1_21_9.PLAYER).index(19).handler(shoulderDataHandler);
        this.filter().type((EntityType)EntityTypes1_21_9.PLAYER).index(20).handler(shoulderDataHandler);
        this.filter().type((EntityType)EntityTypes1_21_9.PLAYER).handler((event, data) -> {
            if (event.index() == 15) {
                event.setIndex(18);
            } else if (event.index() == 16) {
                event.setIndex(17);
            } else if (event.index() == 17 || event.index() == 18) {
                event.setIndex(event.index() - 2);
            }
        });
        this.filter().type((EntityType)EntityTypes1_21_9.MANNEQUIN).handler((event, data) -> {
            if (event.index() == 2) {
                Tag displayName = (Tag)data.value();
                MannequinData mannequinData = (MannequinData)event.trackedEntity().data().get(MannequinData.class);
                this.sendPlayerInfoDisplayNameUpdate(event.user(), mannequinData, displayName);
            } else if (event.index() == 17) {
                ResolvableProfile profile = (ResolvableProfile)data.value();
                UUID uuid = ((MannequinData)event.trackedEntity().data().get(MannequinData.class)).uuid();
                this.sendPlayerInfoProfileUpdate(event.user(), uuid, profile.profile().name(), profile.profile().properties());
                event.cancel();
            } else if (event.index() == 15) {
                event.setIndex(18);
            } else if (event.index() == 16) {
                event.setIndex(17);
            } else if (event.index() == 18) {
                event.cancel();
            } else if (event.index() == 19) {
                event.cancel();
            }
        });
    }

    public void onMappingDataLoaded() {
        this.mapTypes();
        this.mapEntityTypeWithData((EntityType)EntityTypes1_21_9.COPPER_GOLEM, (EntityType)EntityTypes1_21_9.FROG).tagName();
        this.mapEntityTypeWithData((EntityType)EntityTypes1_21_9.MANNEQUIN, (EntityType)EntityTypes1_21_9.PLAYER);
    }

    public EntityType typeFromId(int type) {
        return EntityTypes1_21_9.getTypeFromId((int)type);
    }
}

